/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.stream.provider.twitter;

import java.util.List;
import org.openimaj.stream.provider.twitter.AbstractTwitterSearchDataset;
import org.openimaj.util.api.auth.common.TwitterAPIToken;
import org.openimaj.util.concurrent.BlockingDroppingQueue;
import org.openimaj.util.data.Context;
import twitter4j.Query;
import twitter4j.Status;

public class ContextRoundRobinTwitterSearchAPIDataset
extends AbstractTwitterSearchDataset<Context> {
    private List<Query> queries;
    private int currentQuery;

    public ContextRoundRobinTwitterSearchAPIDataset(List<Query> queries, TwitterAPIToken token, BlockingDroppingQueue<Context> buffer) {
        super(token, buffer, queries.get(0));
        this.queries = queries;
        this.currentQuery = 0;
    }

    @Override
    public Query getQuery() {
        Query retQuery = this.queries.get(this.currentQuery);
        this.nextQuery();
        return retQuery;
    }

    private void nextQuery() {
        ++this.currentQuery;
        if (this.currentQuery >= this.queries.size()) {
            this.currentQuery = 0;
        }
    }

    @Override
    public void registerStatus(Query query, Status status, String json) throws InterruptedException {
        Context c = new Context();
        c.put((Object)"query", (Object)query);
        c.put((Object)"status", (Object)status);
        c.put((Object)"status_json", (Object)json);
        this.register(c);
    }
}

