/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.stream.provider.twitter;

import org.openimaj.data.dataset.StreamingDataset;
import org.openimaj.util.api.auth.common.TwitterAPIToken;
import org.openimaj.util.concurrent.BlockingDroppingQueue;
import org.openimaj.util.stream.BlockingDroppingBufferedStream;
import twitter4j.FilterQuery;
import twitter4j.Status;
import twitter4j.StatusAdapter;
import twitter4j.StatusListener;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;
import twitter4j.json.DataObjectFactory;

public abstract class AbstractTwitterStatusesFilterDataset<T>
extends BlockingDroppingBufferedStream<T>
implements StreamingDataset<T> {
    public AbstractTwitterStatusesFilterDataset(FilterQuery query, TwitterAPIToken token, BlockingDroppingQueue<T> buffer) {
        super(buffer);
        TwitterStream twitterStream = new TwitterStreamFactory(this.makeConfiguration(token)).getInstance();
        twitterStream.addListener((StatusListener)new StatusAdapter(){

            public void onStatus(Status status) {
                try {
                    AbstractTwitterStatusesFilterDataset.this.registerStatus(status, DataObjectFactory.getRawJSON((Object)status));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        twitterStream.filter(query);
    }

    private Configuration makeConfiguration(TwitterAPIToken token) {
        ConfigurationBuilder cb = new ConfigurationBuilder().setOAuthConsumerKey(token.consumerKey).setOAuthConsumerSecret(token.consumerSecret).setOAuthAccessToken(token.accessToken).setOAuthAccessTokenSecret(token.accessSecret);
        return cb.build();
    }

    protected abstract void registerStatus(Status var1, String var2) throws InterruptedException;

    public T getRandomInstance() {
        return (T)this.next();
    }

    public int numInstances() {
        return Integer.MAX_VALUE;
    }
}

