/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.stream.provider.twitter;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openimaj.data.dataset.StreamingDataset;
import org.openimaj.stream.provider.twitter.AbstractTwitterSearchDataset;
import org.openimaj.stream.provider.twitter.TwitterSearchDataset;
import org.openimaj.twitter.utils.Twitter4jUtil;
import org.openimaj.util.api.auth.common.TwitterAPIToken;
import org.openimaj.util.concurrent.BlockingDroppingQueue;
import org.openimaj.util.parallel.GlobalExecutorPool;
import org.openimaj.util.stream.BlockingDroppingBufferedStream;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;
import twitter4j.json.DataObjectFactory;

public abstract class AbstractTwitterSearchDataset<T>
extends BlockingDroppingBufferedStream<T>
implements StreamingDataset<T> {
    private static final long DEFAULT_ERROR_BUT_NO_WAIT_TIME = 5000L;
    private static final long SLEEP_PER_SEARCH = 2000L;
    private static final int ZERO_RESULT_BACKOFF = 1000;
    protected Query query;
    protected Logger logger = Logger.getLogger(TwitterSearchDataset.class);
    protected Configuration config;
    protected Twitter twitter;

    protected AbstractTwitterSearchDataset(TwitterAPIToken token, BlockingDroppingQueue<T> buffer, Query query) {
        super(buffer);
        this.config = this.makeConfiguration(token);
        this.twitter = new TwitterFactory(this.config).getInstance();
        this.query = query;
        this.startSearch();
    }

    protected abstract void registerStatus(Query var1, Status var2, String var3) throws InterruptedException;

    private void startSearch() {
        GlobalExecutorPool.getPool().execute(new TwitterAPIRunnable(this.twitter));
    }

    public abstract Query getQuery();

    protected Configuration makeConfiguration(TwitterAPIToken token) {
        ConfigurationBuilder cb = new ConfigurationBuilder().setOAuthConsumerKey(token.consumerKey).setOAuthConsumerSecret(token.consumerSecret).setOAuthAccessToken(token.accessToken).setOAuthAccessTokenSecret(token.accessSecret);
        cb.setJSONStoreEnabled(true);
        return cb.build();
    }

    public T getRandomInstance() {
        return (T)this.next();
    }

    public int numInstances() {
        return Integer.MAX_VALUE;
    }

    final class TwitterAPIRunnable
    implements Runnable {
        private final Twitter twitter;
        private Map<Query, org.openimaj.stream.provider.twitter.AbstractTwitterSearchDataset$TwitterAPIRunnable.QueryMetaInfo> metaInfoMap;

        private TwitterAPIRunnable(Twitter twitter) {
            this.twitter = twitter;
            this.metaInfoMap = new HashMap<Query, org.openimaj.stream.provider.twitter.AbstractTwitterSearchDataset$TwitterAPIRunnable.QueryMetaInfo>();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        AbstractTwitterSearchDataset.this.logger.debug((Object)"Querying...");
                        Query query = AbstractTwitterSearchDataset.this.getQuery();
                        QueryMetaInfo metaInfo = (QueryMetaInfo)this.metaInfoMap.get(query);
                        if (metaInfo == null) {
                            metaInfo = new QueryMetaInfo();
                            this.metaInfoMap.put(query, (org.openimaj.stream.provider.twitter.AbstractTwitterSearchDataset$TwitterAPIRunnable.QueryMetaInfo)metaInfo);
                        }
                        QueryResult res = this.twitter.search(query);
                        if (metaInfo.newest != -1L) {
                            query.sinceId(metaInfo.newestID + 1L);
                        }
                        if (res.getCount() == 0) {
                            metaInfo.backoff++;
                            Thread.sleep(1000 * metaInfo.backoff);
                            AbstractTwitterSearchDataset.this.logger.error((Object)"Backing off");
                        } else {
                            metaInfo.backoff = 0;
                        }
                        for (Status status : res.getTweets()) {
                            String rawjson = DataObjectFactory.getRawJSON((Object)status);
                            rawjson = DataObjectFactory.getRawJSON((Object)status);
                            AbstractTwitterSearchDataset.this.registerStatus(query, status, rawjson);
                            long tweetTime = status.getCreatedAt().getTime();
                            if (tweetTime <= metaInfo.newest) continue;
                            metaInfo.newest = tweetTime;
                            metaInfo.newestID = status.getId();
                        }
                        Thread.sleep(2000L);
                    }
                }
                catch (InterruptedException e) {
                    AbstractTwitterSearchDataset.this.logger.error((Object)"Thread interuppted!", (Throwable)e);
                    AbstractTwitterSearchDataset.this.close();
                    continue;
                }
                catch (TwitterException e) {
                    long waitTime = Twitter4jUtil.handleTwitterException((TwitterException)e, (long)5000L);
                    try {
                        Thread.sleep(waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    continue;
                }
                break;
            }
        }

        private class QueryMetaInfo {
            private long newestID = -1L;
            private long newest = -1L;
            private int backoff = 0;

            private QueryMetaInfo() {
            }
        }
    }
}

