/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.stream.provider;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openimaj.stream.provider.irc.AbstractIRCStreamDataset;
import org.openimaj.util.concurrent.ArrayBlockingDroppingQueue;
import org.openimaj.util.concurrent.BlockingDroppingQueue;

public class WikipediaEditsDataset
extends AbstractIRCStreamDataset<WikipediaEdit> {
    private static final String RCPMTPA_REGEX = "\\x0314\\[\\[\\x0307(.+?)\\x0314\\]\\]\\x034 (.*?)\\x0310.*\\x0302(.*?)\\x03.+\\x0303(.+?)\\x03.+\\x03 [(](.*)[)] \\x0310(.*)\\u0003.*";
    private static Map<String, String> languageChannels = new HashMap<String, String>();
    private static Pattern regex;

    public WikipediaEditsDataset(BlockingDroppingQueue<WikipediaEdit> buffer, String language) throws IOException {
        super(buffer, "irc.wikimedia.org", languageChannels.get(language));
    }

    public WikipediaEditsDataset(String lang) throws IOException {
        this((BlockingDroppingQueue<WikipediaEdit>)new ArrayBlockingDroppingQueue(1), lang);
    }

    @Override
    public WikipediaEdit construct(String channel, String sender, String login, String hostname, String message) {
        if (!sender.equals("rc-pmtpa")) {
            return null;
        }
        try {
            return new WikipediaEdit(message);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        languageChannels.put("en", "#en.wikipedia");
        regex = Pattern.compile(RCPMTPA_REGEX);
    }

    public static class WikipediaEdit {
        public int change;
        public String user;
        public boolean anon;
        public String flag;
        public boolean isRobot;
        public boolean isNewPage;
        public boolean isUnpatrolled;
        public String page;
        public URL wikipedia;
        public String wikipediaUrl;
        public URL pageUrl;
        public URL userUrl;
        public String comment;

        protected WikipediaEdit(String message) throws IOException {
            Matcher m = regex.matcher(message);
            if (!m.matches()) {
                throw new IOException("Wikipedia message not parseable");
            }
            String group1 = m.group(1);
            String group2 = m.group(2);
            String group3 = m.group(3);
            String group4 = m.group(4);
            String group5 = m.group(5).replace("+", "").replace("-", "");
            int neg = m.group(5).contains("-") ? -1 : 1;
            String group6 = m.group(6);
            this.change = neg * Integer.parseInt(group5);
            this.user = group4;
            this.anon = Pattern.matches("\\d+.\\d+.\\d+.\\d+", this.user);
            this.flag = group2;
            this.isRobot = this.flag.contains("M");
            this.isNewPage = this.flag.contains("N");
            this.isUnpatrolled = this.flag.contains("!");
            this.page = group1;
            this.wikipedia = new URL(group3);
            this.wikipediaUrl = "http://" + this.wikipedia.getHost();
            this.pageUrl = new URL(this.wikipediaUrl + "/wiki/" + this.page.replace(" ", "_"));
            this.userUrl = !this.anon ? new URL(this.wikipediaUrl + "/wiki/User:" + this.user.replace(" ", "_")) : null;
            this.comment = group6;
        }

        public String toString() {
            return String.format("User: %s, Change: %d", this.user, this.change);
        }
    }
}

