/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.stream.functions;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import org.openimaj.image.ImageUtilities;
import org.openimaj.io.HttpUtils;
import org.openimaj.stream.functions.SiteSpecificURLExtractor;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.web.scraping.SiteSpecificConsumer;
import org.openimaj.web.scraping.images.CommonHTMLConsumers;
import org.openimaj.web.scraping.images.FacebookConsumer;
import org.openimaj.web.scraping.images.ImgurConsumer;
import org.openimaj.web.scraping.images.InstagramConsumer;
import org.openimaj.web.scraping.images.OwlyImageConsumer;
import org.openimaj.web.scraping.images.TmblrPhotoConsumer;
import org.openimaj.web.scraping.images.TwipleConsumer;
import org.openimaj.web.scraping.images.TwitPicConsumer;
import org.openimaj.web.scraping.images.TwitterPhotoConsumer;
import org.openimaj.web.scraping.images.YfrogConsumer;

public class ImageSiteURLExtractor
extends SiteSpecificURLExtractor {
    private static final Logger logger = Logger.getLogger(ImageSiteURLExtractor.class);
    private boolean fallback = false;

    public ImageSiteURLExtractor(boolean tumblr, boolean fallback) {
        this(tumblr);
        this.fallback = fallback;
    }

    public ImageSiteURLExtractor(boolean tumblr) {
        this.siteSpecific.addAll(Arrays.asList(new TwitterPhotoConsumer(), new InstagramConsumer(), new TwitPicConsumer(), new ImgurConsumer(), new FacebookConsumer(), new YfrogConsumer(), new OwlyImageConsumer(), new TwipleConsumer(), CommonHTMLConsumers.FOTOLOG, CommonHTMLConsumers.PHOTONUI, CommonHTMLConsumers.PICS_LOCKERZ));
        if (tumblr) {
            this.siteSpecific.add(new TmblrPhotoConsumer());
        }
    }

    public ImageSiteURLExtractor() {
        this(true);
    }

    @Override
    protected List<URL> processURLs(URL url) {
        logger.debug((Object)("Resolving URL: " + url));
        logger.debug((Object)"Attempting site specific consumers");
        for (SiteSpecificConsumer consumer : this.siteSpecific) {
            if (!consumer.canConsume(url)) continue;
            logger.debug((Object)("Site specific consumer: " + consumer.getClass().getName() + " working on link"));
            List urlList = consumer.consume(url);
            if (urlList == null || urlList.isEmpty()) continue;
            logger.debug((Object)"Site specific consumer returned non-null, returning the URLs");
            return urlList;
        }
        if (this.fallback) {
            try {
                logger.debug((Object)"Site specific consumers failed, trying the raw link");
                StatusConsumerRedirectStrategy redirector = new StatusConsumerRedirectStrategy();
                IndependentPair headersBais = HttpUtils.readURLAsByteArrayInputStream((URL)url, (int)1000, (int)1000, (RedirectStrategy)redirector, (String)"Mozilla/5.0 (Windows; U; Windows NT 6.0; ru; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)");
                if (redirector.wasRedirected()) {
                    logger.debug((Object)"Redirect intercepted, adding redirection to list");
                    URL redirect = redirector.redirection();
                    if (!redirect.toString().equals(url.toString())) {
                        return this.processURLs(redirect);
                    }
                }
                HttpEntity headers = (HttpEntity)headersBais.firstObject();
                ByteArrayInputStream bais = (ByteArrayInputStream)headersBais.getSecondObject();
                String typeValue = headers.getContentType().getValue();
                if (typeValue.contains("text")) {
                    logger.debug((Object)(url + " ignored -- text content"));
                    return null;
                }
                if (typeValue.contains("gif")) {
                    return Lists.newArrayList((Object[])new URL[]{url});
                }
                ImageUtilities.readMBF((InputStream)bais);
                return Lists.newArrayList((Object[])new URL[]{url});
            }
            catch (Throwable e) {
                logger.debug((Object)(url + " ignored -- exception"), e);
            }
        }
        return null;
    }

    private static class StatusConsumerRedirectStrategy
    extends HttpUtils.MetaRefreshRedirectStrategy {
        private boolean wasRedirected = false;
        private URL redirection;

        private StatusConsumerRedirectStrategy() {
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            this.wasRedirected = super.isRedirected(request, response, context);
            if (this.wasRedirected) {
                try {
                    this.redirection = this.getRedirect(request, response, context).getURI().toURL();
                }
                catch (MalformedURLException e) {
                    this.wasRedirected = false;
                }
            }
            return false;
        }

        public boolean wasRedirected() {
            return this.wasRedirected;
        }

        public URL redirection() {
            return this.redirection;
        }
    }
}

