/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.ISimpleMediaFile;
import com.xuggle.xuggler.ITimeValue;

public class SimpleMediaFile
implements ISimpleMediaFile {
    private String mURL = null;
    private boolean mHasAudio = true;
    private int mAudioBitRate = 64000;
    private boolean mAudioBitRateKnown = false;
    private int mAudioChannels = 1;
    private boolean mAudioChannelsKnown = false;
    private int mAudioSampleRate = 44100;
    private boolean mAudioSampleRateKnown = false;
    private IRational mAudioTimeBase = null;
    private ICodec.ID mAudioCodec = ICodec.ID.CODEC_ID_NONE;
    private IAudioSamples.Format mAudioSamplesFormat = IAudioSamples.Format.FMT_S16;
    private boolean mHasVideo = true;
    private ICodec.ID mVideoCodec = ICodec.ID.CODEC_ID_NONE;
    private int mVideoHeight = 1;
    private boolean mVideoHeightKnown = false;
    private int mVideoWidth = 1;
    private boolean mVideoWidthKnown = false;
    private int mVideoBitRate = 320000;
    private boolean mVideoBitRateKnown = false;
    private IRational mVideoTimeBase = null;
    private IRational mVideoFrameRate = null;
    private int mVideoGOPS = 15;
    private boolean mVideoGOPSKnown = false;
    private int mVideoGlobalQuality = 0;
    private boolean mVideoGlobalQualityKnown = false;
    private IPixelFormat.Type mPixelFormat = IPixelFormat.Type.YUV420P;
    private boolean mVideoPixelFormatKnown = false;
    private IContainerFormat mContainerFormat = null;
    private ITimeValue mDuration = null;

    public SimpleMediaFile() {
    }

    public SimpleMediaFile(ISimpleMediaFile src) {
        if (src == null) {
            throw new IllegalArgumentException("cannot pass null src");
        }
        this.setHasAudio(src.hasAudio());
        this.setAudioBitRate(src.getAudioBitRate());
        this.setAudioChannels(src.getAudioChannels());
        this.setAudioSampleRate(src.getAudioSampleRate());
        this.setAudioSampleFormat(src.getAudioSampleFormat());
        this.setHasVideo(src.hasVideo());
        this.setAudioCodec(src.getAudioCodec());
        this.setVideoCodec(src.getVideoCodec());
        this.setVideoHeight(src.getVideoHeight());
        this.setVideoWidth(src.getVideoWidth());
        IRational srcRational = src.getVideoTimeBase();
        this.setVideoTimeBase(srcRational);
        srcRational = src.getVideoFrameRate();
        this.setVideoFrameRate(srcRational);
        srcRational = src.getAudioTimeBase();
        this.setAudioTimeBase(srcRational);
        this.setVideoNumPicturesInGroupOfPictures(src.getVideoNumPicturesInGroupOfPictures());
        this.setVideoGlobalQuality(src.getVideoGlobalQuality());
        this.setVideoPixelFormat(src.getVideoPixelFormat());
        this.setContainerFormat(src.getContainerFormat());
        this.setDuration(src.getDuration());
        this.setURL(src.getURL());
        this.setAudioBitRateKnown(src.isAudioBitRateKnown());
        this.setAudioChannelsKnown(src.isAudioChannelsKnown());
        this.setAudioSampleRateKnown(src.isAudioSampleRateKnown());
        this.setVideoHeightKnown(src.isVideoHeightKnown());
        this.setVideoWidthKnown(src.isVideoWidthKnown());
        this.setVideoNumPicturesInGroupOfPicturesKnown(src.isVideoNumPicturesInGroupOfPicturesKnown());
        this.setVideoPixelFormatKnown(src.isVideoPixelFormatKnown());
        this.setVideoGlobalQualityKnown(src.isVideoGlobalQualityKnown());
    }

    @Override
    public int getAudioBitRate() {
        return this.mAudioBitRate;
    }

    @Override
    public int getAudioChannels() {
        return this.mAudioChannels;
    }

    @Override
    public int getAudioSampleRate() {
        return this.mAudioSampleRate;
    }

    @Override
    public void setAudioBitRate(int bitRate) {
        this.mAudioBitRate = bitRate;
        this.setAudioBitRateKnown(true);
    }

    @Override
    public void setAudioChannels(int numChannels) {
        if (numChannels < 1 || numChannels > 2) {
            throw new IllegalArgumentException("only supports 1 or 2 channels");
        }
        this.mAudioChannels = numChannels;
        this.setAudioChannelsKnown(true);
    }

    @Override
    public void setAudioSampleRate(int sampleRate) {
        this.mAudioSampleRate = sampleRate;
        this.setAudioSampleRateKnown(true);
    }

    @Override
    public ICodec.ID getAudioCodec() {
        return this.mAudioCodec;
    }

    @Override
    public void setAudioCodec(ICodec.ID audioCodec) {
        this.mAudioCodec = audioCodec;
    }

    @Override
    public ICodec.ID getVideoCodec() {
        return this.mVideoCodec;
    }

    @Override
    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    @Override
    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    @Override
    public int getVideoBitRate() {
        return this.mVideoBitRate;
    }

    @Override
    public void setVideoCodec(ICodec.ID videoCodec) {
        this.mVideoCodec = videoCodec;
    }

    @Override
    public void setVideoHeight(int height) {
        this.mVideoHeight = height;
        this.setVideoHeightKnown(true);
    }

    @Override
    public void setVideoWidth(int width) {
        this.mVideoWidth = width;
        this.setVideoWidthKnown(true);
    }

    @Override
    public IRational getVideoTimeBase() {
        return this.mVideoTimeBase;
    }

    @Override
    public void setVideoTimeBase(IRational timeBase) {
        this.mVideoTimeBase = timeBase;
    }

    @Override
    public void setVideoBitRate(int bitRate) {
        this.mVideoBitRate = bitRate;
        this.setVideoBitRateKnown(true);
    }

    @Override
    public IPixelFormat.Type getVideoPixelFormat() {
        return this.mPixelFormat;
    }

    @Override
    public void setVideoPixelFormat(IPixelFormat.Type pixelFormat) {
        this.mPixelFormat = pixelFormat;
        this.setVideoPixelFormatKnown(true);
    }

    @Override
    public IRational getVideoFrameRate() {
        return this.mVideoFrameRate;
    }

    @Override
    public int getVideoGlobalQuality() {
        return this.mVideoGlobalQuality;
    }

    @Override
    public int getVideoNumPicturesInGroupOfPictures() {
        return this.mVideoGOPS;
    }

    @Override
    public void setVideoFrameRate(IRational frameRate) {
        this.mVideoFrameRate = frameRate;
    }

    @Override
    public void setVideoGlobalQuality(int quality) {
        this.mVideoGlobalQuality = quality;
        this.setVideoGlobalQualityKnown(true);
    }

    @Override
    public void setVideoNumPicturesInGroupOfPictures(int gops) {
        this.mVideoGOPS = gops;
        this.setVideoNumPicturesInGroupOfPicturesKnown(true);
    }

    @Override
    public boolean hasAudio() {
        return this.mHasAudio;
    }

    @Override
    public boolean hasVideo() {
        return this.mHasVideo;
    }

    @Override
    public void setHasAudio(boolean hasAudio) {
        this.mHasAudio = hasAudio;
    }

    @Override
    public void setHasVideo(boolean hasVideo) {
        this.mHasVideo = hasVideo;
    }

    @Override
    public IContainerFormat getContainerFormat() {
        return this.mContainerFormat;
    }

    @Override
    public void setContainerFormat(IContainerFormat aFormat) {
        this.mContainerFormat = aFormat;
    }

    @Override
    public IRational getAudioTimeBase() {
        return this.mAudioTimeBase;
    }

    @Override
    public void setAudioTimeBase(IRational aTimeBase) {
        this.mAudioTimeBase = aTimeBase;
    }

    @Override
    public void setAudioBitRateKnown(boolean audioBitRateKnown) {
        this.mAudioBitRateKnown = audioBitRateKnown;
    }

    @Override
    public boolean isAudioBitRateKnown() {
        return this.mAudioBitRateKnown;
    }

    @Override
    public void setAudioChannelsKnown(boolean audioChannelsKnown) {
        this.mAudioChannelsKnown = audioChannelsKnown;
    }

    @Override
    public boolean isAudioChannelsKnown() {
        return this.mAudioChannelsKnown;
    }

    @Override
    public void setAudioSampleRateKnown(boolean audioSampleRateKnown) {
        this.mAudioSampleRateKnown = audioSampleRateKnown;
    }

    @Override
    public boolean isAudioSampleRateKnown() {
        return this.mAudioSampleRateKnown;
    }

    @Override
    public void setVideoHeightKnown(boolean videoHeightKnown) {
        this.mVideoHeightKnown = videoHeightKnown;
    }

    @Override
    public boolean isVideoHeightKnown() {
        return this.mVideoHeightKnown;
    }

    @Override
    public void setVideoWidthKnown(boolean videoWidthKnown) {
        this.mVideoWidthKnown = videoWidthKnown;
    }

    @Override
    public boolean isVideoWidthKnown() {
        return this.mVideoWidthKnown;
    }

    @Override
    public void setVideoBitRateKnown(boolean videoBitRateKnown) {
        this.mVideoBitRateKnown = videoBitRateKnown;
    }

    @Override
    public boolean isVideoBitRateKnown() {
        return this.mVideoBitRateKnown;
    }

    @Override
    public void setVideoNumPicturesInGroupOfPicturesKnown(boolean videoGOPSKnown) {
        this.mVideoGOPSKnown = videoGOPSKnown;
    }

    @Override
    public boolean isVideoNumPicturesInGroupOfPicturesKnown() {
        return this.mVideoGOPSKnown;
    }

    @Override
    public void setVideoGlobalQualityKnown(boolean videoGlobalQualityKnown) {
        this.mVideoGlobalQualityKnown = videoGlobalQualityKnown;
    }

    @Override
    public boolean isVideoGlobalQualityKnown() {
        return this.mVideoGlobalQualityKnown;
    }

    @Override
    public void setVideoPixelFormatKnown(boolean videoPixelFormatKnown) {
        this.mVideoPixelFormatKnown = videoPixelFormatKnown;
    }

    @Override
    public boolean isVideoPixelFormatKnown() {
        return this.mVideoPixelFormatKnown;
    }

    @Override
    public void setDuration(ITimeValue duration) {
        this.mDuration = duration;
    }

    @Override
    public ITimeValue getDuration() {
        return this.mDuration;
    }

    @Override
    public void setURL(String uRL) {
        this.mURL = uRL;
    }

    @Override
    public String getURL() {
        return this.mURL;
    }

    @Override
    public IAudioSamples.Format getAudioSampleFormat() {
        return this.mAudioSamplesFormat;
    }

    @Override
    public void setAudioSampleFormat(IAudioSamples.Format aFormat) {
        if (aFormat == null) {
            throw new IllegalArgumentException("cannot set to null format");
        }
        this.mAudioSamplesFormat = aFormat;
    }
}

