/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IMediaData;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.XugglerJNI;
import java.util.concurrent.atomic.AtomicLong;

public class IVideoPicture
extends IMediaData {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IVideoPicture(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGIVideoPictureUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected IVideoPicture(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(XugglerJNI.SWIGIVideoPictureUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IVideoPicture obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public IVideoPicture copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new IVideoPicture(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    @Override
    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IVideoPicture) {
            equal = ((IVideoPicture)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    @Override
    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + "@" + this.hashCode() + "[");
        result.append("pixel type:" + (Object)((Object)this.getPixelType()) + ";");
        result.append("width:" + this.getWidth() + ";");
        result.append("height:" + this.getHeight() + ";");
        result.append("time stamp:" + this.getTimeStamp() + ";");
        result.append("complete:" + this.isComplete() + ";");
        result.append("size:" + this.getSize() + ";");
        result.append("key:" + this.isKey() + ";");
        IRational timeBase = IRational.make(1, (int)Global.DEFAULT_PTS_PER_SECOND);
        result.append("time base:" + timeBase + ";");
        if (timeBase != null) {
            timeBase.delete();
        }
        result.append("]");
        return result.toString();
    }

    public boolean isKeyFrame() {
        return XugglerJNI.IVideoPicture_isKeyFrame(this.swigCPtr, this);
    }

    public void setKeyFrame(boolean aIsKey) {
        XugglerJNI.IVideoPicture_setKeyFrame(this.swigCPtr, this, aIsKey);
    }

    public boolean isComplete() {
        return XugglerJNI.IVideoPicture_isComplete(this.swigCPtr, this);
    }

    @Override
    public int getSize() {
        return XugglerJNI.IVideoPicture_getSize(this.swigCPtr, this);
    }

    public int getWidth() {
        return XugglerJNI.IVideoPicture_getWidth(this.swigCPtr, this);
    }

    public int getHeight() {
        return XugglerJNI.IVideoPicture_getHeight(this.swigCPtr, this);
    }

    public IPixelFormat.Type getPixelType() {
        return IPixelFormat.Type.swigToEnum(XugglerJNI.IVideoPicture_getPixelType(this.swigCPtr, this));
    }

    public long getPts() {
        return XugglerJNI.IVideoPicture_getPts(this.swigCPtr, this);
    }

    public void setPts(long value) {
        XugglerJNI.IVideoPicture_setPts(this.swigCPtr, this, value);
    }

    public int getQuality() {
        return XugglerJNI.IVideoPicture_getQuality(this.swigCPtr, this);
    }

    public void setQuality(int newQuality) {
        XugglerJNI.IVideoPicture_setQuality(this.swigCPtr, this, newQuality);
    }

    public int getDataLineSize(int lineNo) {
        return XugglerJNI.IVideoPicture_getDataLineSize(this.swigCPtr, this, lineNo);
    }

    public void setComplete(boolean aIsComplete, IPixelFormat.Type format, int width, int height, long pts) {
        XugglerJNI.IVideoPicture_setComplete(this.swigCPtr, this, aIsComplete, format.swigValue(), width, height, pts);
    }

    public boolean copy(IVideoPicture srcPicture) {
        return XugglerJNI.IVideoPicture_copy(this.swigCPtr, this, IVideoPicture.getCPtr(srcPicture), srcPicture);
    }

    public static IVideoPicture make(IPixelFormat.Type format, int width, int height) {
        long cPtr = XugglerJNI.IVideoPicture_make__SWIG_0(format.swigValue(), width, height);
        return cPtr == 0L ? null : new IVideoPicture(cPtr, false);
    }

    public static IVideoPicture make(IVideoPicture src) {
        long cPtr = XugglerJNI.IVideoPicture_make__SWIG_1(IVideoPicture.getCPtr(src), src);
        return cPtr == 0L ? null : new IVideoPicture(cPtr, false);
    }

    public PictType getPictureType() {
        return PictType.swigToEnum(XugglerJNI.IVideoPicture_getPictureType(this.swigCPtr, this));
    }

    public void setPictureType(PictType type) {
        XugglerJNI.IVideoPicture_setPictureType(this.swigCPtr, this, type.swigValue());
    }

    public static IVideoPicture make(IBuffer buffer, IPixelFormat.Type format, int width, int height) {
        long cPtr = XugglerJNI.IVideoPicture_make__SWIG_2(IBuffer.getCPtr(buffer), buffer, format.swigValue(), width, height);
        return cPtr == 0L ? null : new IVideoPicture(cPtr, false);
    }

    public static enum PictType {
        DEFAULT_TYPE(XugglerJNI.IVideoPicture_DEFAULT_TYPE_get()),
        I_TYPE(XugglerJNI.IVideoPicture_I_TYPE_get()),
        P_TYPE(XugglerJNI.IVideoPicture_P_TYPE_get()),
        B_TYPE(XugglerJNI.IVideoPicture_B_TYPE_get()),
        S_TYPE(XugglerJNI.IVideoPicture_S_TYPE_get()),
        SI_TYPE(XugglerJNI.IVideoPicture_SI_TYPE_get()),
        SP_TYPE(XugglerJNI.IVideoPicture_SP_TYPE_get()),
        BI_TYPE(XugglerJNI.IVideoPicture_BI_TYPE_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static PictType swigToEnum(int swigValue) {
            PictType[] swigValues = (PictType[])PictType.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (PictType swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + PictType.class + " with value " + swigValue);
        }

        private PictType() {
            this.swigValue = SwigNext.next++;
        }

        private PictType(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private PictType(PictType swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

