/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.Intersection;
import org.openrdf.query.algebra.SPARQLIntersection;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class SPARQLIntersectionOptimizer
implements QueryOptimizer {
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new SPARQLIntersectionVisitor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SPARQLIntersectionVisitor
    extends QueryModelVisitorBase<RuntimeException> {
        protected SPARQLIntersectionVisitor() {
        }

        @Override
        public void meet(Intersection node) {
            if (node instanceof SPARQLIntersection) {
                this.meet((SPARQLIntersection)node);
            } else {
                super.meet(node);
            }
        }

        @Override
        public void meet(SPARQLIntersection node) {
            ArrayList<TupleExpr> intersectionArgs = this.getIntersectionArgs(node, new ArrayList());
            List<TupleExpr> orderedIntersectionArgs = this.reorderIntersectionArgs(intersectionArgs);
            SPARQLIntersection replacement = new SPARQLIntersection(orderedIntersectionArgs.get(0), orderedIntersectionArgs.get(1));
            for (int i = 2; i < orderedIntersectionArgs.size(); ++i) {
                replacement = new SPARQLIntersection(replacement, orderedIntersectionArgs.get(i));
            }
            node.replaceWith(replacement);
        }

        protected <L extends List<TupleExpr>> L getIntersectionArgs(TupleExpr tupleExpr, L intersectionArgs) {
            if (tupleExpr instanceof SPARQLIntersection) {
                SPARQLIntersection sparqlIntersection = (SPARQLIntersection)tupleExpr;
                this.getIntersectionArgs(sparqlIntersection.getLeftArg(), intersectionArgs);
                this.getIntersectionArgs(sparqlIntersection.getRightArg(), intersectionArgs);
            } else {
                intersectionArgs.add((TupleExpr)tupleExpr);
            }
            return intersectionArgs;
        }

        protected List<TupleExpr> reorderIntersectionArgs(List<TupleExpr> intersectionArgs) {
            ArrayList<TupleExpr> result = new ArrayList<TupleExpr>();
            HashMap intersectionSizes = new HashMap();
            int maxIntersectionSize = 0;
            for (int i = 0; i < intersectionArgs.size(); ++i) {
                TupleExpr firstArg = intersectionArgs.get(i);
                for (int j = i + 1; j < intersectionArgs.size(); ++j) {
                    TupleExpr secondArg = intersectionArgs.get(j);
                    Set<String> names = firstArg.getBindingNames();
                    names.retainAll(secondArg.getBindingNames());
                    int interSectionSize = names.size();
                    if (interSectionSize > maxIntersectionSize) {
                        maxIntersectionSize = interSectionSize;
                    }
                    List l = null;
                    l = intersectionSizes.containsKey(interSectionSize) ? (List)intersectionSizes.get(interSectionSize) : new ArrayList();
                    TupleExpr[] tupleTuple = new TupleExpr[]{firstArg, secondArg};
                    l.add(tupleTuple);
                    intersectionSizes.put(interSectionSize, l);
                }
            }
            TupleExpr[] maxUnionTupleTuple = null;
            int currentUnionSize = -1;
            List list = (List)intersectionSizes.get(maxIntersectionSize);
            for (TupleExpr[] tupleTuple : list) {
                Set<String> names = tupleTuple[0].getBindingNames();
                names.addAll(tupleTuple[1].getBindingNames());
                int unionSize = names.size();
                if (unionSize <= currentUnionSize) continue;
                maxUnionTupleTuple = tupleTuple;
                currentUnionSize = unionSize;
            }
            result.add((TupleExpr)maxUnionTupleTuple[0]);
            result.add((TupleExpr)maxUnionTupleTuple[1]);
            while (result.size() < intersectionArgs.size()) {
                result.add(this.getNextElement(result, intersectionArgs));
            }
            return result;
        }

        private TupleExpr getNextElement(List<TupleExpr> currentList, List<TupleExpr> intersectionArgs) {
            HashSet<String> currentListNames = new HashSet<String>();
            for (TupleExpr expr : currentList) {
                currentListNames.addAll(expr.getBindingNames());
            }
            TupleExpr selected = null;
            int currentUnionSize = -1;
            int currentIntersectionSize = -1;
            for (TupleExpr candidate : intersectionArgs) {
                if (currentList.contains(candidate)) continue;
                Set<String> names = candidate.getBindingNames();
                names.retainAll(currentListNames);
                int intersectionSize = names.size();
                names = candidate.getBindingNames();
                names.addAll(currentListNames);
                int unionSize = names.size();
                if (intersectionSize > currentIntersectionSize) {
                    selected = candidate;
                    currentIntersectionSize = intersectionSize;
                    currentUnionSize = unionSize;
                    continue;
                }
                if (intersectionSize != currentIntersectionSize || unionSize <= currentUnionSize) continue;
                selected = candidate;
                currentIntersectionSize = intersectionSize;
                currentUnionSize = unionSize;
            }
            return selected;
        }
    }
}

