/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ConvertingIteration;
import info.aduna.iteration.DelayedIteration;
import info.aduna.iteration.DistinctIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.FilterIteration;
import info.aduna.iteration.IntersectIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.LimitIteration;
import info.aduna.iteration.LookAheadIteration;
import info.aduna.iteration.OffsetIteration;
import info.aduna.iteration.ReducedIteration;
import info.aduna.iteration.SingletonIteration;
import info.aduna.iteration.UnionIteration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Pattern;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.ArbitraryLengthPath;
import org.openrdf.query.algebra.BNodeGenerator;
import org.openrdf.query.algebra.BinaryTupleOperator;
import org.openrdf.query.algebra.BindingSetAssignment;
import org.openrdf.query.algebra.Bound;
import org.openrdf.query.algebra.Coalesce;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.CompareAll;
import org.openrdf.query.algebra.CompareAny;
import org.openrdf.query.algebra.Datatype;
import org.openrdf.query.algebra.Difference;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Exists;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.FunctionCall;
import org.openrdf.query.algebra.Group;
import org.openrdf.query.algebra.IRIFunction;
import org.openrdf.query.algebra.If;
import org.openrdf.query.algebra.In;
import org.openrdf.query.algebra.Intersection;
import org.openrdf.query.algebra.IsBNode;
import org.openrdf.query.algebra.IsLiteral;
import org.openrdf.query.algebra.IsNumeric;
import org.openrdf.query.algebra.IsResource;
import org.openrdf.query.algebra.IsURI;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.Label;
import org.openrdf.query.algebra.Lang;
import org.openrdf.query.algebra.LangMatches;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.Like;
import org.openrdf.query.algebra.LocalName;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.query.algebra.MultiProjection;
import org.openrdf.query.algebra.Namespace;
import org.openrdf.query.algebra.Not;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.Reduced;
import org.openrdf.query.algebra.Regex;
import org.openrdf.query.algebra.SPARQLIntersection;
import org.openrdf.query.algebra.SameTerm;
import org.openrdf.query.algebra.Service;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.Slice;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.Str;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.ZeroLengthPath;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.federation.FederatedService;
import org.openrdf.query.algebra.evaluation.federation.FederatedServiceManager;
import org.openrdf.query.algebra.evaluation.federation.ServiceJoinIterator;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.function.FunctionRegistry;
import org.openrdf.query.algebra.evaluation.impl.ExternalSet;
import org.openrdf.query.algebra.evaluation.iterator.BadlyDesignedLeftJoinIterator;
import org.openrdf.query.algebra.evaluation.iterator.ExtensionIterator;
import org.openrdf.query.algebra.evaluation.iterator.FilterIterator;
import org.openrdf.query.algebra.evaluation.iterator.GroupIterator;
import org.openrdf.query.algebra.evaluation.iterator.JoinIterator;
import org.openrdf.query.algebra.evaluation.iterator.LeftJoinIterator;
import org.openrdf.query.algebra.evaluation.iterator.MultiProjectionIterator;
import org.openrdf.query.algebra.evaluation.iterator.OrderIterator;
import org.openrdf.query.algebra.evaluation.iterator.ProjectionIterator;
import org.openrdf.query.algebra.evaluation.iterator.SPARQLMinusIteration;
import org.openrdf.query.algebra.evaluation.iterator.SilentIteration;
import org.openrdf.query.algebra.evaluation.util.MathUtil;
import org.openrdf.query.algebra.evaluation.util.OrderComparator;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;
import org.openrdf.query.algebra.evaluation.util.ValueComparator;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.algebra.helpers.VarNameCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationStrategyImpl
implements EvaluationStrategy {
    protected final TripleSource tripleSource;
    protected final Dataset dataset;

    public EvaluationStrategyImpl(TripleSource tripleSource) {
        this(tripleSource, null);
    }

    public EvaluationStrategyImpl(TripleSource tripleSource, Dataset dataset) {
        this.tripleSource = tripleSource;
        this.dataset = dataset;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof StatementPattern) {
            return this.evaluate((StatementPattern)expr, bindings);
        }
        if (expr instanceof UnaryTupleOperator) {
            return this.evaluate((UnaryTupleOperator)expr, bindings);
        }
        if (expr instanceof BinaryTupleOperator) {
            return this.evaluate((BinaryTupleOperator)expr, bindings);
        }
        if (expr instanceof SingletonSet) {
            return this.evaluate((SingletonSet)expr, bindings);
        }
        if (expr instanceof EmptySet) {
            return this.evaluate((EmptySet)expr, bindings);
        }
        if (expr instanceof ExternalSet) {
            return this.evaluate((ExternalSet)expr, bindings);
        }
        if (expr instanceof ZeroLengthPath) {
            return this.evaluate((ZeroLengthPath)expr, bindings);
        }
        if (expr instanceof ArbitraryLengthPath) {
            return this.evaluate((ArbitraryLengthPath)expr, bindings);
        }
        if (expr instanceof BindingSetAssignment) {
            return this.evaluate((BindingSetAssignment)expr, bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported tuple expr type: " + expr.getClass());
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(ArbitraryLengthPath alp, BindingSet bindings) throws QueryEvaluationException {
        StatementPattern.Scope scope = alp.getScope();
        Var subjectVar = alp.getSubjectVar();
        TupleExpr pathExpression = alp.getPathExpression();
        Var objVar = alp.getObjectVar();
        Var contextVar = alp.getContextVar();
        long minLength = alp.getMinLength();
        return new PathIteration(scope, subjectVar, pathExpression, objVar, contextVar, minLength, bindings);
    }

    private Var createAnonVar(String varName) {
        Var var = new Var(varName);
        var.setAnonymous(true);
        return var;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(ZeroLengthPath zlp, BindingSet bindings) throws QueryEvaluationException {
        Var subjectVar = zlp.getSubjectVar();
        Var objVar = zlp.getObjectVar();
        Value subj = null;
        try {
            subj = this.evaluate(subjectVar, bindings);
        }
        catch (QueryEvaluationException e) {
            // empty catch block
        }
        Value obj = null;
        try {
            obj = this.evaluate(objVar, bindings);
        }
        catch (QueryEvaluationException e) {
            // empty catch block
        }
        if (subj != null && obj != null && !subj.equals(obj)) {
            return new EmptyIteration<BindingSet, QueryEvaluationException>();
        }
        return new ZeroLengthPathIteration(subjectVar, objVar, subj, obj, bindings);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service service, BindingSet bindings) throws QueryEvaluationException {
        String serviceUri;
        Var serviceRef = service.getServiceRef();
        if (serviceRef.hasValue()) {
            serviceUri = serviceRef.getValue().stringValue();
        } else if (bindings != null && bindings.hasBinding(serviceRef.getName())) {
            serviceUri = bindings.getBinding(serviceRef.getName()).getValue().stringValue();
        } else {
            throw new QueryEvaluationException("SERVICE variables must be bound at evaluation time.");
        }
        try {
            FederatedService fs = FederatedServiceManager.getInstance().getService(serviceUri);
            HashSet<String> freeVars = new HashSet<String>(service.getServiceVars());
            freeVars.removeAll(bindings.getBindingNames());
            String baseUri = service.getBaseURI();
            String queryString = service.getQueryString(freeVars);
            if (freeVars.size() == 0) {
                return fs.evaluate(queryString, bindings, baseUri, FederatedService.QueryType.ASK, service);
            }
            CloseableIteration<BindingSet, QueryEvaluationException> result = fs.evaluate(queryString, bindings, baseUri, FederatedService.QueryType.SELECT, service);
            if (service.isSilent()) {
                return new SilentIteration(result);
            }
            return result;
        }
        catch (QueryEvaluationException e) {
            if (service.isSilent()) {
                return new SingletonIteration<BindingSet, QueryEvaluationException>(bindings);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (service.isSilent()) {
                return new SingletonIteration<BindingSet, QueryEvaluationException>(bindings);
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(StatementPattern sp, final BindingSet bindings) throws QueryEvaluationException {
        void var11_14;
        final Var subjVar = sp.getSubjectVar();
        final Var predVar = sp.getPredicateVar();
        final Var objVar = sp.getObjectVar();
        final Var conVar = sp.getContextVar();
        final Value subjValue = this.getVarValue(subjVar, bindings);
        final Value predValue = this.getVarValue(predVar, bindings);
        final Value objValue = this.getVarValue(objVar, bindings);
        Value contextValue = this.getVarValue(conVar, bindings);
        Object var11_11 = null;
        try {
            Resource[] contexts;
            if (this.dataset != null) {
                Set<URI> graphs = null;
                graphs = sp.getScope() == StatementPattern.Scope.DEFAULT_CONTEXTS ? this.dataset.getDefaultGraphs() : this.dataset.getNamedGraphs();
                if (graphs.isEmpty()) {
                    return new EmptyIteration<BindingSet, QueryEvaluationException>();
                }
                if (contextValue != null) {
                    if (!graphs.contains(contextValue)) return new EmptyIteration<BindingSet, QueryEvaluationException>();
                    contexts = new Resource[]{(Resource)contextValue};
                } else {
                    contexts = graphs.toArray(new Resource[graphs.size()]);
                }
            } else {
                contexts = contextValue != null ? new Resource[]{(Resource)contextValue} : new Resource[]{};
            }
            CloseableIteration<? extends Statement, QueryEvaluationException> closeableIteration = this.tripleSource.getStatements((Resource)subjValue, (URI)predValue, objValue, contexts);
            if (contexts.length == 0 && sp.getScope() == StatementPattern.Scope.NAMED_CONTEXTS) {
                FilterIteration<Statement, QueryEvaluationException> filterIteration = new FilterIteration<Statement, QueryEvaluationException>(closeableIteration){

                    @Override
                    protected boolean accept(Statement st) {
                        return st.getContext() != null;
                    }
                };
            }
        }
        catch (ClassCastException e) {
            return new EmptyIteration<BindingSet, QueryEvaluationException>();
        }
        FilterIteration<Statement, QueryEvaluationException> filterIteration = new FilterIteration<Statement, QueryEvaluationException>((Iteration)var11_14){

            @Override
            protected boolean accept(Statement st) {
                Resource subj = st.getSubject();
                URI pred = st.getPredicate();
                Value obj = st.getObject();
                Resource context = st.getContext();
                if (subjVar != null && subjValue == null) {
                    if (subjVar.equals(predVar) && !subj.equals(pred)) {
                        return false;
                    }
                    if (subjVar.equals(objVar) && !subj.equals(obj)) {
                        return false;
                    }
                    if (subjVar.equals(conVar) && !subj.equals(context)) {
                        return false;
                    }
                }
                if (predVar != null && predValue == null) {
                    if (predVar.equals(objVar) && !((Object)pred).equals(obj)) {
                        return false;
                    }
                    if (predVar.equals(conVar) && !((Object)pred).equals(context)) {
                        return false;
                    }
                }
                return objVar == null || objValue != null || !objVar.equals(conVar) || obj.equals(context);
            }
        };
        return new ConvertingIteration<Statement, BindingSet, QueryEvaluationException>((Iteration)filterIteration){

            @Override
            protected BindingSet convert(Statement st) {
                QueryBindingSet result = new QueryBindingSet(bindings);
                if (subjVar != null && !result.hasBinding(subjVar.getName())) {
                    result.addBinding(subjVar.getName(), st.getSubject());
                }
                if (predVar != null && !result.hasBinding(predVar.getName())) {
                    result.addBinding(predVar.getName(), st.getPredicate());
                }
                if (objVar != null && !result.hasBinding(objVar.getName())) {
                    result.addBinding(objVar.getName(), st.getObject());
                }
                if (conVar != null && !result.hasBinding(conVar.getName()) && st.getContext() != null) {
                    result.addBinding(conVar.getName(), st.getContext());
                }
                return result;
            }
        };
    }

    protected Value getVarValue(Var var, BindingSet bindings) {
        if (var == null) {
            return null;
        }
        if (var.hasValue()) {
            return var.getValue();
        }
        return bindings.getValue(var.getName());
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(UnaryTupleOperator expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof Projection) {
            return this.evaluate((Projection)expr, bindings);
        }
        if (expr instanceof MultiProjection) {
            return this.evaluate((MultiProjection)expr, bindings);
        }
        if (expr instanceof Filter) {
            return this.evaluate((Filter)expr, bindings);
        }
        if (expr instanceof Service) {
            return this.evaluate((Service)expr, bindings);
        }
        if (expr instanceof Slice) {
            return this.evaluate((Slice)expr, bindings);
        }
        if (expr instanceof Extension) {
            return this.evaluate((Extension)expr, bindings);
        }
        if (expr instanceof Distinct) {
            return this.evaluate((Distinct)expr, bindings);
        }
        if (expr instanceof Reduced) {
            return this.evaluate((Reduced)expr, bindings);
        }
        if (expr instanceof Group) {
            return this.evaluate((Group)expr, bindings);
        }
        if (expr instanceof Order) {
            return this.evaluate((Order)expr, bindings);
        }
        if (expr instanceof QueryRoot) {
            return this.evaluate(((QueryRoot)expr).getArg(), bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unknown unary tuple operator type: " + expr.getClass());
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSetAssignment bsa, BindingSet bindings) throws QueryEvaluationException {
        final List<BindingSet> bindingSets = bsa.getBindingSets();
        CloseableIteration<BindingSet, QueryEvaluationException> result = new CloseableIteration<BindingSet, QueryEvaluationException>(){
            private int i = 0;

            @Override
            public boolean hasNext() throws QueryEvaluationException {
                return bindingSets.size() > this.i;
            }

            @Override
            public BindingSet next() throws QueryEvaluationException {
                return (BindingSet)bindingSets.get(this.i++);
            }

            @Override
            public void remove() throws QueryEvaluationException {
            }

            @Override
            public void close() throws QueryEvaluationException {
            }
        };
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Projection projection, BindingSet bindings) throws QueryEvaluationException {
        ProjectionIterator result = this.evaluate(projection.getArg(), bindings);
        result = new ProjectionIterator(projection, result, bindings);
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(MultiProjection multiProjection, BindingSet bindings) throws QueryEvaluationException {
        MultiProjectionIterator result = this.evaluate(multiProjection.getArg(), bindings);
        result = new MultiProjectionIterator(multiProjection, result, bindings);
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Filter filter, BindingSet bindings) throws QueryEvaluationException {
        FilterIterator result = this.evaluate(filter.getArg(), bindings);
        result = new FilterIterator(filter, result, this);
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Slice slice, BindingSet bindings) throws QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> result = this.evaluate(slice.getArg(), bindings);
        if (slice.hasOffset()) {
            result = new OffsetIteration<BindingSet, QueryEvaluationException>(result, slice.getOffset());
        }
        if (slice.hasLimit()) {
            result = new LimitIteration<BindingSet, QueryEvaluationException>(result, slice.getLimit());
        }
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Extension extension, BindingSet bindings) throws QueryEvaluationException {
        ExtensionIterator result;
        try {
            result = this.evaluate(extension.getArg(), bindings);
        }
        catch (ValueExprEvaluationException e) {
            result = new EmptyIteration<BindingSet, QueryEvaluationException>();
        }
        result = new ExtensionIterator(extension, result, this);
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Distinct distinct, BindingSet bindings) throws QueryEvaluationException {
        return new DistinctIteration<BindingSet, QueryEvaluationException>(this.evaluate(distinct.getArg(), bindings));
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Reduced reduced, BindingSet bindings) throws QueryEvaluationException {
        return new ReducedIteration<BindingSet, QueryEvaluationException>(this.evaluate(reduced.getArg(), bindings));
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Group node, BindingSet bindings) throws QueryEvaluationException {
        return new GroupIterator(this, node, bindings);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Order node, BindingSet bindings) throws QueryEvaluationException {
        ValueComparator vcmp = new ValueComparator();
        OrderComparator cmp = new OrderComparator(this, node, vcmp);
        boolean reduced = this.isReduced(node);
        long limit = this.getLimit(node);
        return new OrderIterator(this.evaluate(node.getArg(), bindings), cmp, limit, reduced);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BinaryTupleOperator expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof Join) {
            return this.evaluate((Join)expr, bindings);
        }
        if (expr instanceof LeftJoin) {
            return this.evaluate((LeftJoin)expr, bindings);
        }
        if (expr instanceof Union) {
            return this.evaluate((Union)expr, bindings);
        }
        if (expr instanceof Intersection) {
            return this.evaluate((Intersection)expr, bindings);
        }
        if (expr instanceof Difference) {
            return this.evaluate((Difference)expr, bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported binary tuple operator type: " + expr.getClass());
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Join join, BindingSet bindings) throws QueryEvaluationException {
        if (join.getRightArg() instanceof Service) {
            CloseableIteration<BindingSet, QueryEvaluationException> leftIter = this.evaluate(join.getLeftArg(), bindings);
            return new ServiceJoinIterator(leftIter, (Service)join.getRightArg(), bindings, this);
        }
        return new JoinIterator(this, join, bindings);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(LeftJoin leftJoin, BindingSet bindings) throws QueryEvaluationException {
        VarNameCollector optionalVarCollector = new VarNameCollector();
        leftJoin.getRightArg().visit(optionalVarCollector);
        if (leftJoin.hasCondition()) {
            leftJoin.getCondition().visit(optionalVarCollector);
        }
        Set<String> problemVars = optionalVarCollector.getVarNames();
        problemVars.removeAll(leftJoin.getLeftArg().getBindingNames());
        problemVars.retainAll(bindings.getBindingNames());
        if (problemVars.isEmpty()) {
            return new LeftJoinIterator(this, leftJoin, bindings);
        }
        return new BadlyDesignedLeftJoinIterator(this, leftJoin, bindings, problemVars);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final Union union, final BindingSet bindings) throws QueryEvaluationException {
        DelayedIteration<BindingSet, QueryEvaluationException> leftArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(union.getLeftArg(), bindings);
            }
        };
        DelayedIteration<BindingSet, QueryEvaluationException> rightArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(union.getRightArg(), bindings);
            }
        };
        return new UnionIteration<BindingSet, QueryEvaluationException>(leftArg, rightArg);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final Intersection intersection, final BindingSet bindings) throws QueryEvaluationException {
        if (intersection instanceof SPARQLIntersection) {
            return this.evaluate((SPARQLIntersection)intersection, bindings);
        }
        DelayedIteration<BindingSet, QueryEvaluationException> leftArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(intersection.getLeftArg(), bindings);
            }
        };
        DelayedIteration<BindingSet, QueryEvaluationException> rightArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(intersection.getRightArg(), bindings);
            }
        };
        return new IntersectIteration<BindingSet, QueryEvaluationException>(leftArg, rightArg);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(final Difference difference, final BindingSet bindings) throws QueryEvaluationException {
        DelayedIteration<BindingSet, QueryEvaluationException> leftArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(difference.getLeftArg(), bindings);
            }
        };
        DelayedIteration<BindingSet, QueryEvaluationException> rightArg = new DelayedIteration<BindingSet, QueryEvaluationException>(){

            @Override
            protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
                return EvaluationStrategyImpl.this.evaluate(difference.getRightArg(), bindings);
            }
        };
        return new SPARQLMinusIteration<QueryEvaluationException>(leftArg, rightArg);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(SingletonSet singletonSet, BindingSet bindings) throws QueryEvaluationException {
        return new SingletonIteration<BindingSet, QueryEvaluationException>(bindings);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(EmptySet emptySet, BindingSet bindings) throws QueryEvaluationException {
        return new EmptyIteration<BindingSet, QueryEvaluationException>();
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(ExternalSet external, BindingSet bindings) throws QueryEvaluationException {
        return external.evaluate(bindings);
    }

    @Override
    public Value evaluate(ValueExpr expr, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        if (expr instanceof Var) {
            return this.evaluate((Var)expr, bindings);
        }
        if (expr instanceof ValueConstant) {
            return this.evaluate((ValueConstant)expr, bindings);
        }
        if (expr instanceof BNodeGenerator) {
            return this.evaluate((BNodeGenerator)expr, bindings);
        }
        if (expr instanceof Bound) {
            return this.evaluate((Bound)expr, bindings);
        }
        if (expr instanceof Str) {
            return this.evaluate((Str)expr, bindings);
        }
        if (expr instanceof Label) {
            return this.evaluate((Label)expr, bindings);
        }
        if (expr instanceof Lang) {
            return this.evaluate((Lang)expr, bindings);
        }
        if (expr instanceof LangMatches) {
            return this.evaluate((LangMatches)expr, bindings);
        }
        if (expr instanceof Datatype) {
            return this.evaluate((Datatype)expr, bindings);
        }
        if (expr instanceof Namespace) {
            return this.evaluate((Namespace)expr, bindings);
        }
        if (expr instanceof LocalName) {
            return this.evaluate((LocalName)expr, bindings);
        }
        if (expr instanceof IsResource) {
            return this.evaluate((IsResource)expr, bindings);
        }
        if (expr instanceof IsURI) {
            return this.evaluate((IsURI)expr, bindings);
        }
        if (expr instanceof IsBNode) {
            return this.evaluate((IsBNode)expr, bindings);
        }
        if (expr instanceof IsLiteral) {
            return this.evaluate((IsLiteral)expr, bindings);
        }
        if (expr instanceof IsNumeric) {
            return this.evaluate((IsNumeric)expr, bindings);
        }
        if (expr instanceof IRIFunction) {
            return this.evaluate((IRIFunction)expr, bindings);
        }
        if (expr instanceof Regex) {
            return this.evaluate((Regex)expr, bindings);
        }
        if (expr instanceof Coalesce) {
            return this.evaluate((Coalesce)expr, bindings);
        }
        if (expr instanceof Like) {
            return this.evaluate((Like)expr, bindings);
        }
        if (expr instanceof FunctionCall) {
            return this.evaluate((FunctionCall)expr, bindings);
        }
        if (expr instanceof And) {
            return this.evaluate((And)expr, bindings);
        }
        if (expr instanceof Or) {
            return this.evaluate((Or)expr, bindings);
        }
        if (expr instanceof Not) {
            return this.evaluate((Not)expr, bindings);
        }
        if (expr instanceof SameTerm) {
            return this.evaluate((SameTerm)expr, bindings);
        }
        if (expr instanceof Compare) {
            return this.evaluate((Compare)expr, bindings);
        }
        if (expr instanceof MathExpr) {
            return this.evaluate((MathExpr)expr, bindings);
        }
        if (expr instanceof In) {
            return this.evaluate((In)expr, bindings);
        }
        if (expr instanceof CompareAny) {
            return this.evaluate((CompareAny)expr, bindings);
        }
        if (expr instanceof CompareAll) {
            return this.evaluate((CompareAll)expr, bindings);
        }
        if (expr instanceof Exists) {
            return this.evaluate((Exists)expr, bindings);
        }
        if (expr instanceof If) {
            return this.evaluate((If)expr, bindings);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported value expr type: " + expr.getClass());
    }

    public Value evaluate(Var var, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value value = var.getValue();
        if (value == null) {
            value = bindings.getValue(var.getName());
        }
        if (value == null) {
            throw new ValueExprEvaluationException();
        }
        return value;
    }

    public Value evaluate(ValueConstant valueConstant, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        return valueConstant.getValue();
    }

    public Value evaluate(BNodeGenerator node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        ValueExpr nodeIdExpr = node.getNodeIdExpr();
        if (nodeIdExpr != null) {
            Value nodeId = this.evaluate(nodeIdExpr, bindings);
            if (nodeId instanceof Literal) {
                String nodeLabel = ((Literal)nodeId).getLabel() + bindings.toString().hashCode();
                return this.tripleSource.getValueFactory().createBNode(nodeLabel);
            }
            throw new ValueExprEvaluationException("BNODE function argument must be a literal");
        }
        return this.tripleSource.getValueFactory().createBNode();
    }

    public Value evaluate(Bound node, BindingSet bindings) throws QueryEvaluationException {
        try {
            Value argValue = this.evaluate(node.getArg(), bindings);
            return BooleanLiteralImpl.valueOf(argValue != null);
        }
        catch (ValueExprEvaluationException e) {
            return BooleanLiteralImpl.FALSE;
        }
    }

    public Value evaluate(Str node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof URI) {
            return this.tripleSource.getValueFactory().createLiteral(argValue.toString());
        }
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            if (QueryEvaluationUtil.isSimpleLiteral(literal) && literal.getDatatype() == null) {
                return literal;
            }
            return this.tripleSource.getValueFactory().createLiteral(literal.getLabel());
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Label node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            if (QueryEvaluationUtil.isSimpleLiteral(literal) && literal.getDatatype() == null) {
                return literal;
            }
            return this.tripleSource.getValueFactory().createLiteral(literal.getLabel());
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Lang node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            String langTag = literal.getLanguage();
            if (langTag == null) {
                langTag = "";
            }
            return this.tripleSource.getValueFactory().createLiteral(langTag);
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Datatype node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value v = this.evaluate(node.getArg(), bindings);
        if (v instanceof Literal) {
            Literal literal = (Literal)v;
            if (literal.getDatatype() != null) {
                return literal.getDatatype();
            }
            if (literal.getLanguage() != null) {
                return RDF.LANGSTRING;
            }
            return XMLSchema.STRING;
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Namespace node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof URI) {
            URI uri = (URI)argValue;
            return this.tripleSource.getValueFactory().createURI(uri.getNamespace());
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(LocalName node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof URI) {
            URI uri = (URI)argValue;
            return this.tripleSource.getValueFactory().createLiteral(uri.getLocalName());
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(IsResource node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteralImpl.valueOf(argValue instanceof Resource);
    }

    public Value evaluate(IsURI node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteralImpl.valueOf(argValue instanceof URI);
    }

    public Value evaluate(IsBNode node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteralImpl.valueOf(argValue instanceof BNode);
    }

    public Value evaluate(IsLiteral node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        return BooleanLiteralImpl.valueOf(argValue instanceof Literal);
    }

    public Value evaluate(IsNumeric node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            Literal lit = (Literal)argValue;
            URI datatype = lit.getDatatype();
            return BooleanLiteralImpl.valueOf(datatype != null && XMLDatatypeUtil.isNumericDatatype(datatype));
        }
        return BooleanLiteralImpl.FALSE;
    }

    public URI evaluate(IRIFunction node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        if (argValue instanceof Literal) {
            Literal lit = (Literal)argValue;
            String baseURI = node.getBaseURI();
            URI result = null;
            try {
                result = this.tripleSource.getValueFactory().createURI(lit.getLabel());
            }
            catch (IllegalArgumentException e) {
                try {
                    result = this.tripleSource.getValueFactory().createURI(baseURI, lit.getLabel());
                }
                catch (IllegalArgumentException e1) {
                    throw new ValueExprEvaluationException(e1.getMessage());
                }
            }
            return result;
        }
        if (argValue instanceof URI) {
            return (URI)argValue;
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Regex node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value arg = this.evaluate(node.getArg(), bindings);
        Value parg = this.evaluate(node.getPatternArg(), bindings);
        Value farg = null;
        ValueExpr flagsArg = node.getFlagsArg();
        if (flagsArg != null) {
            farg = this.evaluate(flagsArg, bindings);
        }
        if (QueryEvaluationUtil.isStringLiteral(arg) && QueryEvaluationUtil.isSimpleLiteral(parg) && (farg == null || QueryEvaluationUtil.isSimpleLiteral(farg))) {
            String text = ((Literal)arg).getLabel();
            String ptn = ((Literal)parg).getLabel();
            String flags = "";
            if (farg != null) {
                flags = ((Literal)farg).getLabel();
            }
            int f = 0;
            block8: for (char c : flags.toCharArray()) {
                switch (c) {
                    case 's': {
                        f |= 0x20;
                        continue block8;
                    }
                    case 'm': {
                        f |= 8;
                        continue block8;
                    }
                    case 'i': {
                        f |= 2;
                        continue block8;
                    }
                    case 'x': {
                        f |= 4;
                        continue block8;
                    }
                    case 'd': {
                        f |= 1;
                        continue block8;
                    }
                    case 'u': {
                        f |= 0x40;
                        continue block8;
                    }
                    default: {
                        throw new ValueExprEvaluationException(flags);
                    }
                }
            }
            Pattern pattern = Pattern.compile(ptn, f);
            boolean result = pattern.matcher(text).find();
            return BooleanLiteralImpl.valueOf(result);
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(LangMatches node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value langTagValue = this.evaluate(node.getLeftArg(), bindings);
        Value langRangeValue = this.evaluate(node.getRightArg(), bindings);
        if (QueryEvaluationUtil.isSimpleLiteral(langTagValue) && QueryEvaluationUtil.isSimpleLiteral(langRangeValue)) {
            String langTag = ((Literal)langTagValue).getLabel();
            String langRange = ((Literal)langRangeValue).getLabel();
            boolean result = false;
            if (langRange.equals("*")) {
                result = langTag.length() > 0;
            } else if (langTag.length() == langRange.length()) {
                result = langTag.equalsIgnoreCase(langRange);
            } else if (langTag.length() > langRange.length()) {
                String prefix = langTag.substring(0, langRange.length());
                result = prefix.equalsIgnoreCase(langRange) && langTag.charAt(langRange.length()) == '-';
            }
            return BooleanLiteralImpl.valueOf(result);
        }
        throw new ValueExprEvaluationException();
    }

    public Value evaluate(Like node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        String snippet;
        Value val = this.evaluate(node.getArg(), bindings);
        String strVal = null;
        if (val instanceof URI) {
            strVal = ((Object)((URI)val)).toString();
        } else if (val instanceof Literal) {
            strVal = ((Literal)val).getLabel();
        }
        if (strVal == null) {
            throw new ValueExprEvaluationException();
        }
        if (!node.isCaseSensitive()) {
            strVal = strVal.toLowerCase();
        }
        int valIndex = 0;
        int prevPatternIndex = -1;
        int patternIndex = node.getOpPattern().indexOf(42);
        if (patternIndex == -1) {
            return BooleanLiteralImpl.valueOf(node.getOpPattern().equals(strVal));
        }
        if (patternIndex > 0) {
            snippet = node.getOpPattern().substring(0, patternIndex);
            if (!strVal.startsWith(snippet)) {
                return BooleanLiteralImpl.FALSE;
            }
            valIndex += snippet.length();
            prevPatternIndex = patternIndex;
            patternIndex = node.getOpPattern().indexOf(42, patternIndex + 1);
        }
        while (patternIndex != -1) {
            snippet = node.getOpPattern().substring(prevPatternIndex + 1, patternIndex);
            valIndex = strVal.indexOf(snippet, valIndex);
            if (valIndex == -1) {
                return BooleanLiteralImpl.FALSE;
            }
            valIndex += snippet.length();
            prevPatternIndex = patternIndex;
            patternIndex = node.getOpPattern().indexOf(42, patternIndex + 1);
        }
        snippet = node.getOpPattern().substring(prevPatternIndex + 1);
        if (snippet.length() > 0) {
            int i;
            valIndex = strVal.indexOf(snippet, valIndex);
            while ((i = strVal.indexOf(snippet, valIndex + 1)) != -1) {
                valIndex = i;
            }
            if (valIndex == -1) {
                return BooleanLiteralImpl.FALSE;
            }
            if ((valIndex += snippet.length()) < strVal.length()) {
                return BooleanLiteralImpl.FALSE;
            }
        }
        return BooleanLiteralImpl.TRUE;
    }

    public Value evaluate(FunctionCall node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Function function = (Function)FunctionRegistry.getInstance().get(node.getURI());
        if (function == null) {
            throw new QueryEvaluationException("Unknown function '" + node.getURI() + "'");
        }
        List<ValueExpr> args = node.getArgs();
        Value[] argValues = new Value[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            argValues[i] = this.evaluate(args.get(i), bindings);
        }
        return function.evaluate(this.tripleSource.getValueFactory(), argValues);
    }

    public Value evaluate(And node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        try {
            Value leftValue = this.evaluate(node.getLeftArg(), bindings);
            if (!QueryEvaluationUtil.getEffectiveBooleanValue(leftValue)) {
                return BooleanLiteralImpl.FALSE;
            }
        }
        catch (ValueExprEvaluationException e) {
            Value rightValue = this.evaluate(node.getRightArg(), bindings);
            if (!QueryEvaluationUtil.getEffectiveBooleanValue(rightValue)) {
                return BooleanLiteralImpl.FALSE;
            }
            throw new ValueExprEvaluationException();
        }
        Value rightValue = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteralImpl.valueOf(QueryEvaluationUtil.getEffectiveBooleanValue(rightValue));
    }

    public Value evaluate(Or node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        try {
            Value leftValue = this.evaluate(node.getLeftArg(), bindings);
            if (QueryEvaluationUtil.getEffectiveBooleanValue(leftValue)) {
                return BooleanLiteralImpl.TRUE;
            }
        }
        catch (ValueExprEvaluationException e) {
            Value rightValue = this.evaluate(node.getRightArg(), bindings);
            if (QueryEvaluationUtil.getEffectiveBooleanValue(rightValue)) {
                return BooleanLiteralImpl.TRUE;
            }
            throw new ValueExprEvaluationException();
        }
        Value rightValue = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteralImpl.valueOf(QueryEvaluationUtil.getEffectiveBooleanValue(rightValue));
    }

    public Value evaluate(Not node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value argValue = this.evaluate(node.getArg(), bindings);
        boolean argBoolean = QueryEvaluationUtil.getEffectiveBooleanValue(argValue);
        return BooleanLiteralImpl.valueOf(!argBoolean);
    }

    public Value evaluate(SameTerm node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value leftVal = this.evaluate(node.getLeftArg(), bindings);
        Value rightVal = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteralImpl.valueOf(leftVal != null && leftVal.equals(rightVal));
    }

    public Value evaluate(Coalesce node, BindingSet bindings) throws ValueExprEvaluationException {
        Value result = null;
        for (ValueExpr expr : node.getArguments()) {
            try {
                result = this.evaluate(expr, bindings);
                break;
            }
            catch (ValueExprEvaluationException e) {
            }
            catch (QueryEvaluationException e) {
            }
        }
        if (result == null) {
            throw new ValueExprEvaluationException("COALESCE arguments do not evaluate to a value: " + node.getSignature());
        }
        return result;
    }

    public Value evaluate(Compare node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value leftVal = this.evaluate(node.getLeftArg(), bindings);
        Value rightVal = this.evaluate(node.getRightArg(), bindings);
        return BooleanLiteralImpl.valueOf(QueryEvaluationUtil.compare(leftVal, rightVal, node.getOperator()));
    }

    public Value evaluate(MathExpr node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value leftVal = this.evaluate(node.getLeftArg(), bindings);
        Value rightVal = this.evaluate(node.getRightArg(), bindings);
        if (leftVal instanceof Literal && rightVal instanceof Literal) {
            return MathUtil.compute((Literal)leftVal, (Literal)rightVal, node.getOperator());
        }
        throw new ValueExprEvaluationException("Both arguments must be numeric literals");
    }

    public Value evaluate(If node, BindingSet bindings) throws QueryEvaluationException {
        boolean conditionIsTrue;
        Value result = null;
        try {
            Value value = this.evaluate(node.getCondition(), bindings);
            conditionIsTrue = QueryEvaluationUtil.getEffectiveBooleanValue(value);
        }
        catch (ValueExprEvaluationException e) {
            return null;
        }
        result = conditionIsTrue ? this.evaluate(node.getResult(), bindings) : this.evaluate(node.getAlternative(), bindings);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evaluate(In node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value leftValue = this.evaluate(node.getArg(), bindings);
        boolean result = false;
        String bindingName = node.getSubQuery().getBindingNames().iterator().next();
        CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);
        try {
            while (!result && iter.hasNext()) {
                BindingSet bindingSet = (BindingSet)iter.next();
                Value rightValue = bindingSet.getValue(bindingName);
                result = leftValue == null && rightValue == null || leftValue != null && leftValue.equals(rightValue);
            }
        }
        finally {
            iter.close();
        }
        return BooleanLiteralImpl.valueOf(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evaluate(CompareAny node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        boolean result;
        block7: {
            Value leftValue = this.evaluate(node.getArg(), bindings);
            result = false;
            String bindingName = node.getSubQuery().getBindingNames().iterator().next();
            CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);
            block5: while (true) {
                while (!result && iter.hasNext()) {
                    BindingSet bindingSet = (BindingSet)iter.next();
                    Value rightValue = bindingSet.getValue(bindingName);
                    try {
                        result = QueryEvaluationUtil.compare(leftValue, rightValue, node.getOperator());
                        continue block5;
                    }
                    catch (ValueExprEvaluationException e) {
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                iter.close();
            }
        }
        return BooleanLiteralImpl.valueOf(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evaluate(CompareAll node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        boolean result;
        block7: {
            Value leftValue = this.evaluate(node.getArg(), bindings);
            result = true;
            String bindingName = node.getSubQuery().getBindingNames().iterator().next();
            CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);
            block5: while (true) {
                while (result && iter.hasNext()) {
                    BindingSet bindingSet = (BindingSet)iter.next();
                    Value rightValue = bindingSet.getValue(bindingName);
                    try {
                        result = QueryEvaluationUtil.compare(leftValue, rightValue, node.getOperator());
                        continue block5;
                    }
                    catch (ValueExprEvaluationException e) {
                        result = false;
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                iter.close();
            }
        }
        return BooleanLiteralImpl.valueOf(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evaluate(Exists node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(node.getSubQuery(), bindings);
        try {
            BooleanLiteralImpl booleanLiteralImpl = BooleanLiteralImpl.valueOf(iter.hasNext());
            return booleanLiteralImpl;
        }
        finally {
            iter.close();
        }
    }

    @Override
    public boolean isTrue(ValueExpr expr, BindingSet bindings) throws QueryEvaluationException {
        try {
            Value value = this.evaluate(expr, bindings);
            return QueryEvaluationUtil.getEffectiveBooleanValue(value);
        }
        catch (ValueExprEvaluationException e) {
            return false;
        }
    }

    private boolean isReduced(QueryModelNode node) {
        QueryModelNode parent = node.getParentNode();
        if (parent instanceof Slice) {
            return this.isReduced(parent);
        }
        return parent instanceof Distinct || parent instanceof Reduced;
    }

    private long getLimit(QueryModelNode node) {
        QueryModelNode parent;
        long offset = 0L;
        if (node instanceof Slice) {
            Slice slice = (Slice)node;
            if (slice.hasOffset() && slice.hasLimit()) {
                return slice.getOffset() + slice.getLimit();
            }
            if (slice.hasLimit()) {
                return slice.getLimit();
            }
            if (slice.hasOffset()) {
                offset = slice.getOffset();
            }
        }
        if ((parent = node.getParentNode()) instanceof Distinct || parent instanceof Reduced || parent instanceof Slice) {
            long limit = this.getLimit(parent);
            if (offset > 0L && limit < Long.MAX_VALUE) {
                return offset + limit;
            }
            return limit;
        }
        return Long.MAX_VALUE;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(SPARQLIntersection intersection, BindingSet bindings) throws QueryEvaluationException {
        TupleExpr arg1 = intersection.getLeftArg();
        while (arg1 instanceof UnaryTupleOperator && !(arg1 instanceof Projection)) {
            arg1 = ((UnaryTupleOperator)arg1).getArg();
        }
        TupleExpr arg2 = intersection.getRightArg();
        while (arg2 instanceof UnaryTupleOperator && !(arg2 instanceof Projection)) {
            arg2 = ((UnaryTupleOperator)arg2).getArg();
        }
        Set<String> commonVars = arg1.getBindingNames();
        commonVars.retainAll(arg2.getAssuredBindingNames());
        return this.intersect(this.evaluate(intersection.getLeftArg(), bindings), this.evaluate(intersection.getRightArg(), bindings), commonVars);
    }

    private CloseableIteration<BindingSet, QueryEvaluationException> intersect(CloseableIteration<BindingSet, QueryEvaluationException> iter1, CloseableIteration<BindingSet, QueryEvaluationException> iter2, final Set<String> commonVars) throws QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> iter;
        ArrayList<BindingSet> list1 = new ArrayList<BindingSet>();
        ArrayList<BindingSet> list2 = new ArrayList<BindingSet>();
        while (iter1.hasNext() && iter2.hasNext()) {
            BindingSet b = (BindingSet)iter1.next();
            list1.add(b);
            b = (BindingSet)iter2.next();
            list2.add(b);
        }
        if (iter1.hasNext()) {
            iter = iter1;
            ArrayList<BindingSet> swap = list1;
            list1 = list2;
            list2 = swap;
        } else {
            iter = iter2;
        }
        final HashMap<Binding, HashSet<BindingSet>> map = new HashMap<Binding, HashSet<BindingSet>>();
        for (BindingSet b : list1) {
            BindingSet key = this.calcKey(b, commonVars);
            for (Binding b1 : key) {
                HashSet<BindingSet> set = (HashSet<BindingSet>)map.get(b1);
                if (set == null) {
                    set = new HashSet<BindingSet>();
                    map.put(b1, set);
                }
                set.add(b);
            }
            if (key.size() != 0) continue;
            HashSet<BindingSet> set = (HashSet<BindingSet>)map.get(null);
            if (set == null) {
                set = new HashSet<BindingSet>();
                map.put(null, set);
            }
            set.add(b);
        }
        final Iterator longListIter = list2.iterator();
        final CloseableIteration<BindingSet, QueryEvaluationException> longIter = new CloseableIteration<BindingSet, QueryEvaluationException>(){
            boolean initialized;
            BindingSet res;

            @Override
            public boolean hasNext() throws QueryEvaluationException {
                if (!this.initialized) {
                    this.next();
                    this.initialized = true;
                }
                return this.res != null;
            }

            @Override
            public BindingSet next() throws QueryEvaluationException {
                BindingSet ret = this.res;
                this.res = null;
                if (longListIter.hasNext()) {
                    this.res = (BindingSet)longListIter.next();
                } else if (iter.hasNext()) {
                    this.res = (BindingSet)iter.next();
                }
                return ret;
            }

            @Override
            public void remove() {
            }

            @Override
            public void close() throws QueryEvaluationException {
            }
        };
        return new CloseableIteration<BindingSet, QueryEvaluationException>(){
            boolean initialized;
            BindingSet res;
            Iterator<BindingSet> mergeIter = this.newMergeIter();

            Iterator<BindingSet> newMergeIter() throws QueryEvaluationException {
                block0: while (longIter.hasNext()) {
                    final BindingSet current = (BindingSet)longIter.next();
                    BindingSet key = EvaluationStrategyImpl.this.calcKey(current, commonVars);
                    Set set = new HashSet();
                    boolean firstIteration = true;
                    for (Binding b : key) {
                        Set s = (Set)map.get(b);
                        if (s == null) continue block0;
                        if (firstIteration) {
                            set.addAll(s);
                            firstIteration = false;
                            continue;
                        }
                        set.retainAll(s);
                        if (set.size() != 0) continue;
                        continue block0;
                    }
                    if (key.size() == 0 && (set = (Set)map.get(null)) == null) {
                        set = new HashSet();
                    }
                    final Iterator setIter = set.iterator();
                    return new Iterator<BindingSet>(){
                        boolean initialized;
                        BindingSet res;

                        @Override
                        public boolean hasNext() {
                            if (!this.initialized) {
                                this.next();
                                this.initialized = true;
                            }
                            return this.res != null;
                        }

                        @Override
                        public BindingSet next() {
                            BindingSet ret = this.res;
                            this.res = null;
                            if (setIter.hasNext()) {
                                QueryBindingSet q = new QueryBindingSet();
                                q.addAll(current);
                                q.addAll((BindingSet)setIter.next());
                                this.res = q;
                            }
                            return ret;
                        }

                        @Override
                        public void remove() {
                        }
                    };
                }
                return null;
            }

            @Override
            public boolean hasNext() throws QueryEvaluationException {
                if (!this.initialized) {
                    this.next();
                    this.initialized = true;
                }
                return this.res != null;
            }

            @Override
            public BindingSet next() throws QueryEvaluationException {
                BindingSet ret = this.res;
                if (this.mergeIter != null && !this.mergeIter.hasNext()) {
                    this.mergeIter = this.newMergeIter();
                }
                this.res = this.mergeIter != null && this.mergeIter.hasNext() ? this.mergeIter.next() : null;
                return ret;
            }

            @Override
            public void remove() {
            }

            @Override
            public void close() throws QueryEvaluationException {
            }
        };
    }

    private BindingSet calcKey(BindingSet bindings, Set<String> commonVars) {
        QueryBindingSet q = new QueryBindingSet();
        for (String varName : commonVars) {
            Binding b = bindings.getBinding(varName);
            if (b == null) continue;
            q.addBinding(b);
        }
        return q;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ZeroLengthPathIteration
    extends LookAheadIteration<BindingSet, QueryEvaluationException> {
        private QueryBindingSet result;
        private Var subjectVar;
        private Var objVar;
        private Value subj;
        private Value obj;
        private BindingSet bindings;
        private CloseableIteration<BindingSet, QueryEvaluationException> subjectIter;
        private CloseableIteration<BindingSet, QueryEvaluationException> objectIter;
        private List<Value> reportedValues = new ArrayList<Value>();

        public ZeroLengthPathIteration(Var subjectVar, Var objVar, Value subj, Value obj, BindingSet bindings) {
            this.result = new QueryBindingSet(bindings);
            this.subjectVar = subjectVar;
            this.objVar = objVar;
            this.subj = subj;
            this.obj = obj;
            this.bindings = bindings;
            if (subj != null && obj == null) {
                this.result.addBinding(objVar.getName(), subj);
            }
            if (obj != null && subj == null) {
                this.result.addBinding(subjectVar.getName(), obj);
            }
        }

        @Override
        protected BindingSet getNextElement() throws QueryEvaluationException {
            if (this.subj == null && this.obj == null) {
                Value v;
                QueryBindingSet next;
                if (this.subjectIter == null) {
                    this.subjectIter = this.createSubjectIteration();
                }
                while (this.subjectIter.hasNext()) {
                    next = new QueryBindingSet((BindingSet)this.subjectIter.next());
                    v = next.getValue(this.subjectVar.getName());
                    if (this.reportedValues.contains(v)) continue;
                    next.addBinding(this.objVar.getName(), v);
                    this.reportedValues.add(v);
                    return next;
                }
                if (this.objectIter == null) {
                    this.objectIter = this.createObjectIteration();
                }
                while (this.objectIter.hasNext()) {
                    next = new QueryBindingSet((BindingSet)this.objectIter.next());
                    v = next.getValue(this.objVar.getName());
                    if (this.reportedValues.contains(v)) continue;
                    next.addBinding(this.subjectVar.getName(), v);
                    this.reportedValues.add(v);
                    return next;
                }
            } else {
                QueryBindingSet next = this.result;
                this.result = null;
                return next;
            }
            this.reportedValues = null;
            return null;
        }

        private CloseableIteration<BindingSet, QueryEvaluationException> createSubjectIteration() throws QueryEvaluationException {
            Var predicate = EvaluationStrategyImpl.this.createAnonVar("zero-length-internal-pred");
            Var endVar = EvaluationStrategyImpl.this.createAnonVar("zero-length-internal-end");
            StatementPattern subjects = new StatementPattern(this.subjectVar, predicate, endVar);
            CloseableIteration<BindingSet, QueryEvaluationException> iter = EvaluationStrategyImpl.this.evaluate(subjects, this.bindings);
            return iter;
        }

        private CloseableIteration<BindingSet, QueryEvaluationException> createObjectIteration() throws QueryEvaluationException {
            Var startVar = EvaluationStrategyImpl.this.createAnonVar("zero-length-internal-start");
            Var predicate = EvaluationStrategyImpl.this.createAnonVar("zero-length-internal-pred");
            StatementPattern subjects = new StatementPattern(startVar, predicate, this.objVar);
            CloseableIteration<BindingSet, QueryEvaluationException> iter = EvaluationStrategyImpl.this.evaluate(subjects, this.bindings);
            return iter;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VarReplacer
    extends QueryModelVisitorBase<QueryEvaluationException> {
        private Var toBeReplaced;
        private Var replacement;
        private long index;
        private boolean replaceAnons;

        public VarReplacer(Var toBeReplaced, Var replacement, long index, boolean replaceAnons) {
            this.toBeReplaced = toBeReplaced;
            this.replacement = replacement;
            this.index = index;
            this.replaceAnons = replaceAnons;
        }

        @Override
        public void meet(Var var) {
            if (this.toBeReplaced.equals(var) || this.toBeReplaced.isAnonymous() && var.isAnonymous() && this.toBeReplaced.hasValue() && this.toBeReplaced.getValue().equals(var.getValue())) {
                QueryModelNode parent = var.getParentNode();
                parent.replaceChildNode(var, this.replacement);
                this.replacement.setParentNode(parent);
            } else if (this.replaceAnons && var.isAnonymous() && !var.hasValue()) {
                Var replacementVar = EvaluationStrategyImpl.this.createAnonVar("anon-replace-" + var.getName() + this.index);
                QueryModelNode parent = var.getParentNode();
                parent.replaceChildNode(var, replacementVar);
                replacementVar.setParentNode(parent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathIteration
    extends LookAheadIteration<BindingSet, QueryEvaluationException> {
        private long currentLength;
        private CloseableIteration<BindingSet, QueryEvaluationException> currentIter;
        private BindingSet bindings;
        private StatementPattern.Scope scope;
        private Var startVar;
        private Var endVar;
        private final boolean startVarFixed;
        private final boolean endVarFixed;
        private Queue<ValuePair> valueQueue = new LinkedList<ValuePair>();
        private List<ValuePair> reportedValues = new ArrayList<ValuePair>();
        private TupleExpr pathExpression;
        private Var contextVar;
        private ValuePair currentVp;
        private static final String JOINVAR_PREFIX = "intermediate-join-";

        public PathIteration(StatementPattern.Scope scope, Var startVar, TupleExpr pathExpression, Var endVar, Var contextVar, long minLength, BindingSet bindings) throws QueryEvaluationException {
            this.scope = scope;
            this.startVar = startVar;
            this.endVar = endVar;
            this.startVarFixed = startVar.hasValue() || bindings.hasBinding(startVar.getName());
            this.endVarFixed = endVar.hasValue() || bindings.hasBinding(endVar.getName());
            this.pathExpression = pathExpression;
            this.contextVar = contextVar;
            this.currentLength = minLength;
            this.bindings = bindings;
            this.createIteration();
        }

        @Override
        protected BindingSet getNextElement() throws QueryEvaluationException {
            block10: {
                ValuePair vp;
                Value v2;
                Value v1;
                BindingSet nextElement;
                while (true) {
                    Value startValue;
                    if (!this.currentIter.hasNext()) {
                        this.createIteration();
                        if (!(this.currentIter instanceof EmptyIteration)) continue;
                    }
                    if (!this.currentIter.hasNext()) break block10;
                    nextElement = (BindingSet)this.currentIter.next();
                    if (!this.startVarFixed && !this.endVarFixed && this.currentVp != null && (startValue = this.currentVp.getStartValue()) != null) {
                        nextElement = new QueryBindingSet(nextElement);
                        ((QueryBindingSet)nextElement).addBinding(this.startVar.getName(), startValue);
                    }
                    if (this.startVarFixed && this.endVarFixed && this.currentLength > 2L) {
                        v1 = this.getVarValue(this.startVar, this.startVarFixed, nextElement);
                        v2 = nextElement.getValue("END_intermediate-join-");
                    } else if (this.startVarFixed && this.endVarFixed && this.currentLength == 2L) {
                        v1 = this.getVarValue(this.startVar, this.startVarFixed, nextElement);
                        v2 = nextElement.getValue(JOINVAR_PREFIX + (this.currentLength - 1L));
                    } else {
                        v1 = this.getVarValue(this.startVar, this.startVarFixed, nextElement);
                        v2 = this.getVarValue(this.endVar, this.endVarFixed, nextElement);
                    }
                    if (this.isCyclicPath(v1, v2)) continue;
                    vp = new ValuePair(v1, v2);
                    if (!this.startVarFixed || !this.endVarFixed) break;
                    Value endValue = this.getVarValue(this.endVar, this.endVarFixed, nextElement);
                    if (endValue.equals(v2)) {
                        this.reportedValues.add(vp);
                        if (!v1.equals(v2)) {
                            this.valueQueue.add(vp);
                        }
                        return nextElement;
                    }
                    if (v1.equals(v2)) continue;
                    this.valueQueue.add(vp);
                }
                this.reportedValues.add(vp);
                if (!v1.equals(v2)) {
                    this.valueQueue.add(vp);
                }
                return nextElement;
            }
            this.reportedValues = null;
            this.valueQueue = null;
            return null;
        }

        private Value getVarValue(Var var, boolean fixedValue, BindingSet bindingSet) {
            Value v;
            if (fixedValue) {
                v = var.getValue();
                if (v == null) {
                    v = this.bindings.getValue(var.getName());
                }
            } else {
                v = bindingSet.getValue(var.getName());
            }
            return v;
        }

        private boolean isCyclicPath(Value v1, Value v2) {
            if (this.currentLength <= 2L) {
                return false;
            }
            return this.reportedValues.contains(new ValuePair(v1, v2));
        }

        private void createIteration() throws QueryEvaluationException {
            if (this.currentLength == 0L) {
                ZeroLengthPath zlp = new ZeroLengthPath(this.scope, this.startVar, this.endVar, this.contextVar);
                this.currentIter = EvaluationStrategyImpl.this.evaluate(zlp, this.bindings);
                ++this.currentLength;
            } else if (this.currentLength == 1L) {
                TupleExpr pathExprClone = this.pathExpression.clone();
                if (this.startVarFixed && this.endVarFixed) {
                    Var replacement = EvaluationStrategyImpl.this.createAnonVar(JOINVAR_PREFIX + this.currentLength);
                    VarReplacer replacer = new VarReplacer(this.endVar, replacement, 0L, false);
                    pathExprClone.visit(replacer);
                }
                this.currentIter = EvaluationStrategyImpl.this.evaluate(pathExprClone, this.bindings);
                ++this.currentLength;
            } else {
                this.currentVp = this.valueQueue.poll();
                if (this.currentVp != null) {
                    TupleExpr pathExprClone = this.pathExpression.clone();
                    if (this.startVarFixed && this.endVarFixed) {
                        Var startReplacement = EvaluationStrategyImpl.this.createAnonVar(JOINVAR_PREFIX + this.currentLength);
                        Var endReplacement = EvaluationStrategyImpl.this.createAnonVar("END_intermediate-join-");
                        Value v = this.currentVp.getEndValue();
                        startReplacement.setValue(v);
                        VarReplacer replacer = new VarReplacer(this.startVar, startReplacement, 0L, false);
                        pathExprClone.visit(replacer);
                        replacer = new VarReplacer(this.endVar, endReplacement, 0L, false);
                        pathExprClone.visit(replacer);
                    } else {
                        Value v;
                        Var toBeReplaced;
                        if (!this.endVarFixed) {
                            toBeReplaced = this.startVar;
                            v = this.currentVp.getEndValue();
                        } else {
                            toBeReplaced = this.endVar;
                            v = this.currentVp.getStartValue();
                        }
                        Var replacement = EvaluationStrategyImpl.this.createAnonVar(JOINVAR_PREFIX + this.currentLength);
                        replacement.setValue(v);
                        VarReplacer replacer = new VarReplacer(toBeReplaced, replacement, 0L, false);
                        pathExprClone.visit(replacer);
                    }
                    this.currentIter = EvaluationStrategyImpl.this.evaluate(pathExprClone, this.bindings);
                } else {
                    this.currentIter = new EmptyIteration<BindingSet, QueryEvaluationException>();
                }
                ++this.currentLength;
            }
        }
    }

    private class ValuePair {
        private final Value startValue;
        private final Value endValue;

        public ValuePair(Value startValue, Value endValue) {
            this.startValue = startValue;
            this.endValue = endValue;
        }

        public Value getStartValue() {
            return this.startValue;
        }

        public Value getEndValue() {
            return this.endValue;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.endValue == null ? 0 : this.endValue.hashCode());
            result = 31 * result + (this.startValue == null ? 0 : this.startValue.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ValuePair)) {
                return false;
            }
            ValuePair other = (ValuePair)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.endValue == null ? other.endValue != null : !this.endValue.equals(other.endValue)) {
                return false;
            }
            return !(this.startValue == null ? other.startValue != null : !this.startValue.equals(other.startValue));
        }

        private EvaluationStrategyImpl getOuterType() {
            return EvaluationStrategyImpl.this;
        }
    }
}

