/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import opennlp.model.AbstractModel;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.UncloseableInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class POSModel
extends BaseModel {
    private static final String COMPONENT_NAME = "POSTaggerME";
    private static final String POS_MODEL_ENTRY_NAME = "pos.model";
    private static final String TAG_DICTIONARY_ENTRY_NAME = "tags.tagdict";
    private static final String NGRAM_DICTIONARY_ENTRY_NAME = "ngram.dictionary";

    public POSModel(String languageCode, AbstractModel posModel, POSDictionary tagDictionary, Dictionary ngramDict, Map<String, String> manifestInfoEntries) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries);
        if (posModel == null) {
            throw new IllegalArgumentException("The maxentPosModel param must not be null!");
        }
        this.artifactMap.put(POS_MODEL_ENTRY_NAME, posModel);
        if (tagDictionary != null) {
            this.artifactMap.put(TAG_DICTIONARY_ENTRY_NAME, tagDictionary);
        }
        if (ngramDict != null) {
            this.artifactMap.put(NGRAM_DICTIONARY_ENTRY_NAME, ngramDict);
        }
        this.checkArtifactMap();
    }

    public POSModel(String languageCode, AbstractModel posModel, POSDictionary tagDictionary, Dictionary ngramDict) {
        this(languageCode, posModel, tagDictionary, ngramDict, null);
    }

    public POSModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    @Override
    protected void createArtifactSerializers(Map<String, ArtifactSerializer> serializers) {
        super.createArtifactSerializers(serializers);
        POSDictionarySerializer.register(serializers);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        Object ngramDictEntry;
        super.validateArtifactMap();
        if (!(this.artifactMap.get(POS_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("POS model is incomplete!");
        }
        Object tagdictEntry = this.artifactMap.get(TAG_DICTIONARY_ENTRY_NAME);
        if (tagdictEntry != null) {
            if (tagdictEntry instanceof POSDictionary) {
                POSDictionary posDict = (POSDictionary)tagdictEntry;
                HashSet dictTags = new HashSet();
                for (String word : posDict) {
                    Collections.addAll(dictTags, posDict.getTags(word));
                }
                HashSet<String> modelTags = new HashSet<String>();
                AbstractModel posModel = this.getPosModel();
                for (int i = 0; i < posModel.getNumOutcomes(); ++i) {
                    modelTags.add(posModel.getOutcome(i));
                }
                if (!modelTags.containsAll(dictTags)) {
                    throw new InvalidFormatException("Tag dictioinary contains tags which are unkown by the model!");
                }
            } else {
                throw new InvalidFormatException("Abbreviations dictionary has wrong type!");
            }
        }
        if ((ngramDictEntry = this.artifactMap.get(NGRAM_DICTIONARY_ENTRY_NAME)) != null && !(ngramDictEntry instanceof Dictionary)) {
            throw new InvalidFormatException("NGram dictionary has wrong type!");
        }
    }

    public AbstractModel getPosModel() {
        return (AbstractModel)this.artifactMap.get(POS_MODEL_ENTRY_NAME);
    }

    public POSDictionary getTagDictionary() {
        return (POSDictionary)this.artifactMap.get(TAG_DICTIONARY_ENTRY_NAME);
    }

    public Dictionary getNgramDictionary() {
        return (Dictionary)this.artifactMap.get(NGRAM_DICTIONARY_ENTRY_NAME);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class POSDictionarySerializer
    implements ArtifactSerializer<POSDictionary> {
        POSDictionarySerializer() {
        }

        @Override
        public POSDictionary create(InputStream in) throws IOException, InvalidFormatException {
            return POSDictionary.create(new UncloseableInputStream(in));
        }

        @Override
        public void serialize(POSDictionary artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }

        static void register(Map<String, ArtifactSerializer> factories) {
            factories.put("tagdict", new POSDictionarySerializer());
        }
    }
}

