/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADSentenceStream
extends FilterObjectStream<String, Sentence> {
    private static final Pattern sentStart = Pattern.compile("<s[^>]*>");
    private static final Pattern sentEnd = Pattern.compile("</s>");
    private static final Pattern titleStart = Pattern.compile("<t[^>]*>");
    private static final Pattern titleEnd = Pattern.compile("</t>");
    private static final Pattern boxStart = Pattern.compile("<caixa[^>]*>");
    private static final Pattern boxEnd = Pattern.compile("</caixa>");
    private static final Pattern paraStart = Pattern.compile("<p[^>]*>");
    private static final Pattern textStart = Pattern.compile("<ext[^>]*>");
    private SentenceParser parser = new SentenceParser();
    private int paraID = 0;
    private boolean isTitle = false;
    private boolean isBox = false;

    public ADSentenceStream(ObjectStream<String> lineStream) {
        super(lineStream);
    }

    @Override
    public Sentence read() throws IOException {
        block19: {
            StringBuilder sentence = new StringBuilder();
            boolean sentenceStarted = false;
            while (true) {
                String line;
                if ((line = (String)this.samples.read()) != null) {
                    if (sentenceStarted) {
                        if (sentEnd.matcher(line).matches()) {
                            sentenceStarted = false;
                        } else {
                            sentence.append(line).append('\n');
                        }
                    } else if (sentStart.matcher(line).matches()) {
                        sentenceStarted = true;
                    } else if (paraStart.matcher(line).matches()) {
                        ++this.paraID;
                    } else if (titleStart.matcher(line).matches()) {
                        this.isTitle = true;
                    } else if (titleEnd.matcher(line).matches()) {
                        this.isTitle = false;
                    } else if (textStart.matcher(line).matches()) {
                        this.paraID = 0;
                    } else if (boxStart.matcher(line).matches()) {
                        this.isBox = true;
                    } else if (boxEnd.matcher(line).matches()) {
                        this.isBox = false;
                    }
                    if (sentenceStarted || sentence.length() <= 0) continue;
                    return this.parser.parse(sentence.toString(), this.paraID, this.isTitle, this.isBox);
                }
                if (!sentenceStarted) break block19;
                if (sentence.length() > 0) break;
            }
            return this.parser.parse(sentence.toString(), this.paraID, this.isTitle, this.isBox);
        }
        return null;
    }

    public static class SentenceParser {
        private Pattern rootPattern = Pattern.compile("^A\\d+$");
        private Pattern nodePattern = Pattern.compile("^([=-]*)([^:=]+:[^\\(\\s]+)(\\(([^\\)]+)\\))?\\s*$");
        private Pattern leafPattern = Pattern.compile("^([=-]*)([^:=]+:[^\\(\\s]+)\\(([\"'].+[\"'])?\\s*([^\\)]+)?\\)\\s+(.+)");
        private Pattern bizarreLeafPattern = Pattern.compile("^([=-]*)([^:=]+=[^\\(\\s]+)\\(([\"'].+[\"'])?\\s*([^\\)]+)?\\)\\s+(.+)");
        private Pattern punctuationPattern = Pattern.compile("^(=*)(\\W+)$");
        private String text;
        private String meta;

        public Sentence parse(String sentenceString, int para, boolean isTitle, boolean isBox) {
            BufferedReader reader = new BufferedReader(new StringReader(sentenceString));
            Sentence sentence = new Sentence();
            Node root = new Node();
            try {
                String line = reader.readLine();
                boolean useSameTextAndMeta = false;
                while (!line.startsWith("SOURCE")) {
                    if (line.equals("&&")) {
                        useSameTextAndMeta = true;
                        break;
                    }
                    line = reader.readLine();
                    if (line != null) continue;
                    return null;
                }
                if (!useSameTextAndMeta) {
                    String metaFromSource = line.substring(7);
                    line = reader.readLine();
                    int start = line.indexOf(" ");
                    this.text = line.substring(start + 1);
                    String titleTag = "";
                    if (isTitle) {
                        titleTag = " title";
                    }
                    String boxTag = "";
                    if (isBox) {
                        boxTag = " box";
                    }
                    this.meta = line.substring(0, start) + " p=" + para + titleTag + boxTag + metaFromSource;
                }
                sentence.setText(this.text);
                sentence.setMetadata(this.meta);
                line = reader.readLine();
                while (!this.rootPattern.matcher(line).matches()) {
                    line = reader.readLine();
                    if (line != null) continue;
                    return null;
                }
                Stack<Node> nodeStack = new Stack<Node>();
                root.setSyntacticTag(line);
                root.setLevel(0);
                nodeStack.add(root);
                line = reader.readLine();
                while (line != null && line.length() != 0 && !line.startsWith("</s>") && !line.equals("&&")) {
                    TreeElement element = this.getElement(line);
                    if (element != null) {
                        while (!nodeStack.isEmpty() && element.getLevel() > 0 && element.getLevel() <= ((Node)nodeStack.peek()).getLevel()) {
                            nodeStack.pop();
                        }
                        if (element.isLeaf()) {
                            if (nodeStack.isEmpty()) {
                                root.addElement(element);
                            } else {
                                Node peek = (Node)nodeStack.peek();
                                if (element.level == 0) {
                                    ((Node)nodeStack.firstElement()).addElement(element);
                                } else {
                                    Node parent = null;
                                    int index = nodeStack.size() - 1;
                                    while (parent == null) {
                                        if (peek.getLevel() < element.getLevel()) {
                                            parent = peek;
                                            continue;
                                        }
                                        if (--index > -1) {
                                            peek = (Node)nodeStack.get(index);
                                            continue;
                                        }
                                        parent = (Node)nodeStack.firstElement();
                                    }
                                    parent.addElement(element);
                                }
                            }
                        } else {
                            if (!nodeStack.isEmpty()) {
                                ((Node)nodeStack.peek()).addElement(element);
                            }
                            nodeStack.push((Node)element);
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                System.err.println(sentenceString);
                e.printStackTrace();
                return sentence;
            }
            sentence.setRoot(root);
            return sentence;
        }

        public TreeElement getElement(String line) {
            Matcher nodeMatcher = this.nodePattern.matcher(line);
            if (nodeMatcher.matches()) {
                int level = nodeMatcher.group(1).length();
                String syntacticTag = nodeMatcher.group(2);
                String morphologicalTag = nodeMatcher.group(3);
                Node node = new Node();
                node.setLevel(level);
                node.setSyntacticTag(syntacticTag);
                node.setMorphologicalTag(morphologicalTag);
                return node;
            }
            Matcher leafMatcher = this.leafPattern.matcher(line);
            if (leafMatcher.matches()) {
                int level = leafMatcher.group(1).length();
                String syntacticTag = leafMatcher.group(2);
                String lemma = leafMatcher.group(3);
                String morphologicalTag = leafMatcher.group(4);
                String lexeme = leafMatcher.group(5);
                Leaf leaf = new Leaf();
                leaf.setLevel(level);
                leaf.setSyntacticTag(syntacticTag);
                leaf.setMorphologicalTag(morphologicalTag);
                leaf.setLexeme(lexeme);
                if (lemma != null) {
                    if (lemma.length() > 2) {
                        lemma = lemma.substring(1, lemma.length() - 1);
                    }
                    leaf.setLemma(lemma);
                }
                return leaf;
            }
            Matcher punctuationMatcher = this.punctuationPattern.matcher(line);
            if (punctuationMatcher.matches()) {
                int level = punctuationMatcher.group(1).length();
                String lexeme = punctuationMatcher.group(2);
                Leaf leaf = new Leaf();
                leaf.setLevel(level);
                leaf.setLexeme(lexeme);
                return leaf;
            }
            if (line.equals("_") || line.startsWith("<lixo") || line.startsWith("pause")) {
                return null;
            }
            if (line.startsWith("=")) {
                Matcher bizarreLeafMatcher = this.bizarreLeafPattern.matcher(line);
                if (bizarreLeafMatcher.matches()) {
                    int level = bizarreLeafMatcher.group(1).length();
                    String syntacticTag = bizarreLeafMatcher.group(2);
                    String lemma = bizarreLeafMatcher.group(3);
                    String morphologicalTag = bizarreLeafMatcher.group(4);
                    String lexeme = bizarreLeafMatcher.group(5);
                    Leaf leaf = new Leaf();
                    leaf.setLevel(level);
                    leaf.setSyntacticTag(syntacticTag);
                    leaf.setMorphologicalTag(morphologicalTag);
                    leaf.setLexeme(lexeme);
                    if (lemma != null) {
                        if (lemma.length() > 2) {
                            lemma = lemma.substring(1, lemma.length() - 1);
                        }
                        leaf.setLemma(lemma);
                    }
                    return leaf;
                }
                int level = line.lastIndexOf("=");
                String lexeme = line.substring(level + 1);
                Leaf leaf = new Leaf();
                leaf.setLevel(level + 1);
                leaf.setSyntacticTag("");
                leaf.setMorphologicalTag("");
                leaf.setLexeme(lexeme);
                return leaf;
            }
            System.err.println("Couldn't parse leaf: " + line);
            Leaf leaf = new Leaf();
            leaf.setLevel(0);
            leaf.setSyntacticTag("");
            leaf.setMorphologicalTag("");
            leaf.setLexeme(line);
            return leaf;
        }

        public class Leaf
        extends TreeElement {
            private String word;
            private String lemma;

            public boolean isLeaf() {
                return true;
            }

            public void setLexeme(String lexeme) {
                this.word = lexeme;
            }

            public String getLexeme() {
                return this.word;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.getLevel(); ++i) {
                    sb.append("=");
                }
                if (this.getSyntacticTag() != null) {
                    sb.append(this.getSyntacticTag() + "(" + this.getMorphologicalTag() + ") ");
                }
                sb.append(this.word + "\n");
                return sb.toString();
            }

            public void setLemma(String lemma) {
                this.lemma = lemma;
            }

            public String getLemma() {
                return this.lemma;
            }
        }

        public class Node
        extends TreeElement {
            private List<TreeElement> elems;

            public Node() {
                this.elems = new ArrayList<TreeElement>();
            }

            public void addElement(TreeElement element) {
                this.elems.add(element);
            }

            public TreeElement[] getElements() {
                return this.elems.toArray(new TreeElement[this.elems.size()]);
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.getLevel(); ++i) {
                    sb.append("=");
                }
                sb.append(this.getSyntacticTag());
                if (this.getMorphologicalTag() != null) {
                    sb.append(this.getMorphologicalTag());
                }
                sb.append("\n");
                for (TreeElement element : this.elems) {
                    sb.append(element.toString());
                }
                return sb.toString();
            }
        }

        public abstract class TreeElement {
            private String syntacticTag;
            private String morphologicalTag;
            private int level;

            public boolean isLeaf() {
                return false;
            }

            public void setSyntacticTag(String syntacticTag) {
                this.syntacticTag = syntacticTag;
            }

            public String getSyntacticTag() {
                return this.syntacticTag;
            }

            public void setLevel(int level) {
                this.level = level;
            }

            public int getLevel() {
                return this.level;
            }

            public void setMorphologicalTag(String morphologicalTag) {
                this.morphologicalTag = morphologicalTag;
            }

            public String getMorphologicalTag() {
                return this.morphologicalTag;
            }
        }
    }

    public static class Sentence {
        private String text;
        private SentenceParser.Node root;
        private String metadata;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public SentenceParser.Node getRoot() {
            return this.root;
        }

        public void setRoot(SentenceParser.Node root) {
            this.root = root;
        }

        public void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        public String getMetadata() {
            return this.metadata;
        }
    }
}

