/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.sim;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import opennlp.tools.coref.mention.Dictionary;
import opennlp.tools.coref.mention.DictionaryFactory;
import opennlp.tools.coref.mention.HeadFinder;
import opennlp.tools.coref.mention.Mention;
import opennlp.tools.coref.mention.Parse;
import opennlp.tools.util.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
extends Mention {
    protected String headTokenText;
    protected String headTokenTag;
    protected Set<String> synsets;
    protected Object[] tokens;
    protected int headTokenIndex;

    public Context(Span span, Span headSpan, int entityId, Parse parse, String extentType, String nameType, HeadFinder headFinder) {
        super(span, headSpan, entityId, parse, extentType, nameType);
        this.init(headFinder);
    }

    public Context(Object[] tokens, String headToken, String headTag, String neType) {
        super(null, null, 1, null, null, neType);
        this.tokens = tokens;
        this.headTokenIndex = tokens.length - 1;
        this.headTokenText = headToken;
        this.headTokenTag = headTag;
        this.synsets = Context.getSynsetSet(this);
    }

    public Context(Mention mention, HeadFinder headFinder) {
        super(mention);
        this.init(headFinder);
    }

    private void init(HeadFinder headFinder) {
        Parse head = headFinder.getLastHead(this.parse);
        List<Parse> tokenList = head.getTokens();
        this.headTokenIndex = headFinder.getHeadIndex(head);
        Parse headToken = headFinder.getHeadToken(head);
        this.tokens = tokenList.toArray(new Parse[tokenList.size()]);
        this.headTokenTag = headToken.getSyntacticType();
        this.headTokenText = ((Object)headToken).toString();
        this.synsets = this.headTokenTag.startsWith("NN") && !this.headTokenTag.startsWith("NNP") ? Context.getSynsetSet(this) : Collections.emptySet();
    }

    public static Context[] constructContexts(Mention[] mentions, HeadFinder headFinder) {
        Context[] contexts = new Context[mentions.length];
        for (int mi = 0; mi < mentions.length; ++mi) {
            contexts[mi] = new Context(mentions[mi], headFinder);
        }
        return contexts;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        int tl = this.tokens.length;
        for (int ti = 0; ti < tl; ++ti) {
            sb.append(this.tokens[ti]).append(" ");
        }
        return sb.toString();
    }

    public Object[] getTokens() {
        return this.tokens;
    }

    public String getHeadTokenText() {
        return this.headTokenText;
    }

    public String getHeadTokenTag() {
        return this.headTokenTag;
    }

    public Set<String> getSynsets() {
        return this.synsets;
    }

    public static Context parseContext(String word) {
        String[] parts = word.split("/");
        if (parts.length == 2) {
            Object[] tokens = parts[0].split(" ");
            return new Context(tokens, tokens[tokens.length - 1], parts[1], null);
        }
        if (parts.length == 3) {
            Object[] tokens = parts[0].split(" ");
            return new Context(tokens, tokens[tokens.length - 1], parts[1], parts[2]);
        }
        return null;
    }

    private static Set<String> getSynsetSet(Context c) {
        HashSet<String> synsetSet = new HashSet<String>();
        String[] lemmas = Context.getLemmas(c);
        Dictionary dict = DictionaryFactory.getDictionary();
        for (int li = 0; li < lemmas.length; ++li) {
            String senseKey = dict.getSenseKey(lemmas[li], "NN", 0);
            if (senseKey == null) continue;
            synsetSet.add(senseKey);
            String[] synsets = dict.getParentSenseKeys(lemmas[li], "NN", 0);
            int sn = synsets.length;
            for (int si = 0; si < sn; ++si) {
                synsetSet.add(synsets[si]);
            }
        }
        return synsetSet;
    }

    private static String[] getLemmas(Context c) {
        String word = c.headTokenText.toLowerCase();
        return DictionaryFactory.getDictionary().getLemmas(word, "NN");
    }

    public int getHeadTokenIndex() {
        return this.headTokenIndex;
    }
}

