/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.mention;

import java.util.List;
import opennlp.tools.coref.mention.HeadFinder;
import opennlp.tools.coref.mention.Mention;
import opennlp.tools.coref.mention.Parse;
import opennlp.tools.coref.sim.Context;
import opennlp.tools.coref.sim.GenderEnum;
import opennlp.tools.coref.sim.NumberEnum;
import opennlp.tools.util.Span;

public class MentionContext
extends Context {
    private int nonDescriptorStart;
    private Parse head;
    private Span indexSpan;
    private int nounLocation;
    private int nounNumber;
    private int maxNounLocation;
    private int sentenceNumber;
    private Parse prevToken;
    private Parse nextToken;
    private Parse basalNextToken;
    private Parse headToken;
    private Parse firstToken;
    private String firstTokenText;
    private String firstTokenTag;
    private GenderEnum gender;
    private double genderProb;
    private NumberEnum number;
    private double numberProb;

    public MentionContext(Span span, Span headSpan, int entityId, Parse parse, String extentType, String nameType, int mentionIndex, int mentionsInSentence, int mentionIndexInDocument, int sentenceIndex, HeadFinder headFinder) {
        super(span, headSpan, entityId, parse, extentType, nameType, headFinder);
        this.nounLocation = mentionIndex;
        this.maxNounLocation = mentionsInSentence;
        this.nounNumber = mentionIndexInDocument;
        this.sentenceNumber = sentenceIndex;
        this.indexSpan = parse.getSpan();
        this.prevToken = parse.getPreviousToken();
        this.nextToken = parse.getNextToken();
        this.head = headFinder.getLastHead(parse);
        List<Parse> headTokens = this.head.getTokens();
        this.tokens = headTokens.toArray(new Parse[headTokens.size()]);
        this.basalNextToken = this.head.getNextToken();
        this.nonDescriptorStart = 0;
        this.initHeads(headFinder.getHeadIndex(this.head));
        this.gender = GenderEnum.UNKNOWN;
        this.genderProb = 0.0;
        this.number = NumberEnum.UNKNOWN;
        this.numberProb = 0.0;
    }

    public MentionContext(Mention mention, int mentionIndexInSentence, int mentionsInSentence, int mentionIndexInDocument, int sentenceIndex, HeadFinder headFinder) {
        this(mention.getSpan(), mention.getHeadSpan(), mention.getId(), mention.getParse(), mention.type, mention.nameType, mentionIndexInSentence, mentionsInSentence, mentionIndexInDocument, sentenceIndex, headFinder);
    }

    private void initHeads(int headIndex) {
        this.headTokenIndex = headIndex;
        this.headToken = (Parse)this.tokens[this.getHeadTokenIndex()];
        this.headTokenText = ((Object)this.headToken).toString();
        this.headTokenTag = this.headToken.getSyntacticType();
        this.firstToken = (Parse)this.tokens[0];
        this.firstTokenTag = this.firstToken.getSyntacticType();
        this.firstTokenText = ((Object)this.firstToken).toString();
    }

    public Parse getHeadTokenParse() {
        return this.headToken;
    }

    public String getHeadText() {
        StringBuffer headText = new StringBuffer();
        for (int hsi = 0; hsi < this.tokens.length; ++hsi) {
            headText.append(" ").append(this.tokens[hsi].toString());
        }
        return headText.toString().substring(1);
    }

    public Parse getHead() {
        return this.head;
    }

    public int getNonDescriptorStart() {
        return this.nonDescriptorStart;
    }

    public Span getIndexSpan() {
        return this.indexSpan;
    }

    public int getNounPhraseSentenceIndex() {
        return this.nounLocation;
    }

    public int getNounPhraseDocumentIndex() {
        return this.nounNumber;
    }

    public int getMaxNounPhraseSentenceIndex() {
        return this.maxNounLocation;
    }

    public Parse getNextTokenBasal() {
        return this.basalNextToken;
    }

    public Parse getPreviousToken() {
        return this.prevToken;
    }

    public Parse getNextToken() {
        return this.nextToken;
    }

    public int getSentenceNumber() {
        return this.sentenceNumber;
    }

    public Parse getFirstToken() {
        return this.firstToken;
    }

    public String getFirstTokenText() {
        return this.firstTokenText;
    }

    public String getFirstTokenTag() {
        return this.firstTokenTag;
    }

    public Parse[] getTokenParses() {
        return (Parse[])this.tokens;
    }

    public String toText() {
        return ((Object)this.parse).toString();
    }

    public void setGender(GenderEnum gender, double probability) {
        this.gender = gender;
        this.genderProb = probability;
    }

    public GenderEnum getGender() {
        return this.gender;
    }

    public double getGenderProb() {
        return this.genderProb;
    }

    public void setNumber(NumberEnum number, double probability) {
        this.number = number;
        this.numberProb = probability;
    }

    public NumberEnum getNumber() {
        return this.number;
    }

    public double getNumberProb() {
        return this.numberProb;
    }
}

