/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.sentdetect;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import opennlp.model.TrainUtil;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.cmdline.sentdetect.TrainingParams;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.sentdetect.SentenceSampleStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SentenceDetectorTrainerTool
implements CmdLineTool {
    @Override
    public String getName() {
        return "SentenceDetectorTrainer";
    }

    @Override
    public String getShortDescription() {
        return "trainer for the learnable sentence detector";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(TrainerToolParams.class);
    }

    static ObjectStream<SentenceSample> openSampleData(String sampleDataName, File sampleDataFile, Charset encoding) {
        CmdLineUtil.checkInputFile(sampleDataName + " Data", sampleDataFile);
        FileInputStream sampleDataIn = CmdLineUtil.openInFile(sampleDataFile);
        PlainTextByLineStream lineStream = new PlainTextByLineStream(sampleDataIn.getChannel(), encoding);
        return new SentenceSampleStream(lineStream);
    }

    static Dictionary loadDict(File f) throws IOException {
        Dictionary dict = null;
        if (f != null) {
            CmdLineUtil.checkInputFile("abb dict", f);
            dict = new Dictionary(new FileInputStream(f));
        }
        return dict;
    }

    @Override
    public void run(String[] args) {
        SentenceModel model;
        if (!ArgumentParser.validateArguments(args, TrainerToolParams.class)) {
            System.err.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        TrainerToolParams params = ArgumentParser.parse(args, TrainerToolParams.class);
        TrainingParameters mlParams = CmdLineUtil.loadTrainingParameters(params.getParams(), false);
        if (mlParams != null && TrainUtil.isSequenceTraining(mlParams.getSettings())) {
            System.err.println("Sequence training is not supported!");
            throw new TerminateToolException(-1);
        }
        File trainingDataInFile = params.getData();
        File modelOutFile = params.getModel();
        CmdLineUtil.checkOutputFile("sentence detector model", modelOutFile);
        ObjectStream<SentenceSample> sampleStream = SentenceDetectorTrainerTool.openSampleData("Training", trainingDataInFile, params.getEncoding());
        try {
            Dictionary dict = SentenceDetectorTrainerTool.loadDict(params.getAbbDict());
            model = mlParams == null ? SentenceDetectorME.train(params.getLang(), sampleStream, true, dict, params.getCutoff(), params.getIterations()) : SentenceDetectorME.train(params.getLang(), sampleStream, true, dict, mlParams);
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException e) {}
        }
        CmdLineUtil.writeModel("sentence detector", modelOutFile, model);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

