/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.parser;

import java.io.IOException;
import opennlp.model.AbstractModel;
import opennlp.tools.cmdline.parser.ModelUpdaterTool;
import opennlp.tools.cmdline.parser.ParserTrainerTool;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserEventTypeEnum;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.parser.chunking.Parser;
import opennlp.tools.parser.chunking.ParserEventStream;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CheckModelUpdaterTool
extends ModelUpdaterTool {
    @Override
    public String getName() {
        return "CheckModelUpdater";
    }

    @Override
    public String getShortDescription() {
        return "trains and updates the check model in a parser model";
    }

    @Override
    protected ParserModel trainAndUpdate(ParserModel originalModel, ObjectStream<Parse> parseSamples, ModelUpdaterTool.ModelUpdaterParams parameters) throws IOException {
        Dictionary mdict = ParserTrainerTool.buildDictionary(parseSamples, originalModel.getHeadRules(), parameters.getCutoff());
        parseSamples.reset();
        System.out.println("Training check model");
        ParserEventStream bes = new ParserEventStream(parseSamples, originalModel.getHeadRules(), ParserEventTypeEnum.CHECK, mdict);
        AbstractModel checkModel = Parser.train(bes, parameters.getIterations(), parameters.getCutoff());
        parseSamples.close();
        return originalModel.updateCheckModel(checkModel);
    }
}

