/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentParser {
    private static final Map<Class<?>, ArgumentFactory> argumentFactories;

    private ArgumentParser() {
    }

    private static <T> void checkProxyInterface(Class<T> proxyInterface) {
        if (!proxyInterface.isInterface()) {
            throw new IllegalArgumentException("proxy interface is not an interface!");
        }
        Method[] methods = proxyInterface.getMethods();
        if (methods.length == 0) {
            throw new IllegalArgumentException("proxy interface must at least declare one method!");
        }
        for (Method method : methods) {
            if (!method.getName().startsWith("get") && method.getName().length() > 3) {
                throw new IllegalArgumentException(method.getName() + " method name does not start with get!");
            }
            if (method.getParameterTypes().length != 0) {
                throw new IllegalArgumentException(method.getName() + " method must have zero parameters!");
            }
            Class<?> returnType = method.getReturnType();
            Set<Class<?>> compatibleReturnTypes = argumentFactories.keySet();
            if (compatibleReturnTypes.contains(returnType)) continue;
            throw new IllegalArgumentException(method.getName() + " method must have compatible return type!");
        }
    }

    private static String methodNameToParameter(String methodName) {
        char[] parameterNameChars = methodName.toCharArray();
        parameterNameChars[3] = Character.toLowerCase(parameterNameChars[3]);
        String parameterName = "-" + new String(parameterNameChars).substring(3);
        return parameterName;
    }

    public static <T> String createUsage(Class<T> argProxyInterface) {
        ArgumentParser.checkProxyInterface(argProxyInterface);
        StringBuilder usage = new StringBuilder();
        StringBuilder details = new StringBuilder();
        for (Method method : argProxyInterface.getMethods()) {
            ParameterDescription desc = method.getAnnotation(ParameterDescription.class);
            OptionalParameter optional = method.getAnnotation(OptionalParameter.class);
            if (desc == null) continue;
            String paramName = ArgumentParser.methodNameToParameter(method.getName());
            if (optional != null) {
                usage.append('[');
            }
            usage.append(paramName).append(' ').append(desc.valueName());
            details.append('\t').append(paramName).append(' ').append(desc.valueName()).append('\n');
            if (desc.description() != null && desc.description().length() > 0) {
                details.append("\t\t").append(desc.description()).append('\n');
            }
            if (optional != null) {
                usage.append(']');
            }
            usage.append(' ');
        }
        if (usage.length() > 0) {
            usage.setLength(usage.length() - 1);
        }
        if (details.length() > 0) {
            details.setLength(details.length() - 1);
            usage.append("\n\nArguments description:\n").append(details.toString());
        }
        return usage.toString();
    }

    public static <T> boolean validateArguments(String[] args, Class<T> argProxyInterface) {
        if (args.length < 2 || args.length % 2 != 0) {
            return false;
        }
        int argumentCount = 0;
        for (Method method : argProxyInterface.getMethods()) {
            String valueString = CmdLineUtil.getParameter(ArgumentParser.methodNameToParameter(method.getName()), args);
            if (valueString == null) {
                OptionalParameter optionalParam = method.getAnnotation(OptionalParameter.class);
                if (optionalParam != null) continue;
                return false;
            }
            ++argumentCount;
        }
        return args.length / 2 == argumentCount;
    }

    public static <T> T parse(String[] args, Class<T> argProxyInterface) {
        ArgumentParser.checkProxyInterface(argProxyInterface);
        if (!ArgumentParser.validateArguments(args, argProxyInterface)) {
            throw new IllegalArgumentException("Passed args must be valid!");
        }
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        for (Method method : argProxyInterface.getMethods()) {
            Object value;
            String parameterName = ArgumentParser.methodNameToParameter(method.getName());
            String valueString = CmdLineUtil.getParameter(parameterName, args);
            if (valueString == null) {
                OptionalParameter optionalParam = method.getAnnotation(OptionalParameter.class);
                valueString = optionalParam.defaultValue().length() > 0 ? optionalParam.defaultValue() : null;
            }
            Class<?> returnType = method.getReturnType();
            if (valueString != null) {
                ArgumentFactory factory = argumentFactories.get(returnType);
                if (factory == null) {
                    throw new IllegalStateException();
                }
                value = factory.parseArgument(method, parameterName, valueString);
            } else {
                value = null;
            }
            arguments.put(method.getName(), value);
        }
        return (T)Proxy.newProxyInstance(argProxyInterface.getClassLoader(), new Class[]{argProxyInterface}, (InvocationHandler)new ArgumentProxy(arguments));
    }

    static {
        HashMap<Class<Charset>, ArgumentFactory> factories = new HashMap<Class<Charset>, ArgumentFactory>();
        factories.put(Integer.class, new IntegerArgumentFactory());
        factories.put(Boolean.class, new BooleanArgumentFactory());
        factories.put(String.class, new StringArgumentFactory());
        factories.put(File.class, new FileArgumentFactory());
        factories.put(Charset.class, new CharsetArgumentFactory());
        argumentFactories = Collections.unmodifiableMap(factories);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArgumentProxy
    implements InvocationHandler {
        private final Map<String, Object> arguments;

        ArgumentProxy(Map<String, Object> arguments) {
            this.arguments = arguments;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args != null) {
                throw new IllegalStateException();
            }
            return this.arguments.get(method.getName());
        }
    }

    private static class CharsetArgumentFactory
    implements ArgumentFactory {
        private CharsetArgumentFactory() {
        }

        public Object parseArgument(Method method, String argName, String charsetName) {
            try {
                if ("DEFAULT_CHARSET".equals(charsetName)) {
                    return Charset.defaultCharset();
                }
                if (Charset.isSupported(charsetName)) {
                    return Charset.forName(charsetName);
                }
                throw new TerminateToolException(-1, String.format("Invalid argument: %s %s \n", argName, charsetName) + "Encoding not supported on this platform.");
            }
            catch (IllegalCharsetNameException e) {
                throw new TerminateToolException(-1, String.format("Invalid argument: %s %s \n", argName, charsetName) + "Illegal encoding name.");
            }
        }
    }

    private static class FileArgumentFactory
    implements ArgumentFactory {
        private FileArgumentFactory() {
        }

        public Object parseArgument(Method method, String argName, String argValue) {
            return new File(argValue);
        }
    }

    private static class StringArgumentFactory
    implements ArgumentFactory {
        private StringArgumentFactory() {
        }

        public Object parseArgument(Method method, String argName, String argValue) {
            return argValue;
        }
    }

    private static class BooleanArgumentFactory
    implements ArgumentFactory {
        private BooleanArgumentFactory() {
        }

        public Object parseArgument(Method method, String argName, String argValue) {
            return Boolean.parseBoolean(argValue);
        }
    }

    private static class IntegerArgumentFactory
    implements ArgumentFactory {
        private IntegerArgumentFactory() {
        }

        public Object parseArgument(Method method, String argName, String argValue) {
            Integer value = null;
            try {
                value = Integer.parseInt(argValue);
            }
            catch (NumberFormatException e) {
                throw new TerminateToolException(-1, String.format("Invalid argument: %s %s \n", argName, argValue) + "Value must be an integer!");
            }
            return value;
        }
    }

    private static interface ArgumentFactory {
        public static final String INVALID_ARG = "Invalid argument: %s %s \n";

        public Object parseArgument(Method var1, String var2, String var3);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ParameterDescription {
        public String valueName();

        public String description() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface OptionalParameter {
        public static final String DEFAULT_CHARSET = "DEFAULT_CHARSET";

        public String defaultValue() default "";
    }
}

