/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.text.extraction.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openimaj.image.processing.threshold.OtsuThreshold;
import org.openimaj.image.text.extraction.swt.Candidate;
import org.openimaj.image.text.extraction.swt.LetterCandidate;
import org.openimaj.image.text.extraction.swt.LineCandidate;
import org.openimaj.image.text.extraction.swt.SWTTextDetector;
import org.openimaj.util.pair.FloatFloatPair;

public class WordCandidate
extends Candidate {
    protected LineCandidate line;
    protected List<LetterCandidate> letters = new ArrayList<LetterCandidate>();

    protected static List<WordCandidate> extractWords(LineCandidate line, SWTTextDetector.Options options) {
        WordCandidate word;
        ArrayList<WordCandidate> words = new ArrayList<WordCandidate>();
        Collections.sort(line.letters, new Comparator<LetterCandidate>(){

            @Override
            public int compare(LetterCandidate o1, LetterCandidate o2) {
                return o1.centroid.x - o2.centroid.x;
            }
        });
        float[] spacings = new float[line.letters.size() - 1];
        float mean = 0.0f;
        int rng = 0;
        for (int i = 1; i < line.letters.size(); ++i) {
            LetterCandidate left = line.letters.get(i - 1);
            LetterCandidate right = line.letters.get(i);
            spacings[i - 1] = Math.max(0.0f, right.getRegularBoundingBox().x - (left.getRegularBoundingBox().x + left.getRegularBoundingBox().width));
            mean += spacings[i - 1];
            if (!(spacings[i - 1] >= (float)rng)) continue;
            rng = (int)(spacings[i - 1] + 1.0f);
        }
        mean /= (float)spacings.length;
        FloatFloatPair threshVar = OtsuThreshold.calculateThresholdAndVariance((float[])spacings, (int)rng);
        float threshold = threshVar.first;
        float variance = threshVar.second;
        if (Math.sqrt(variance) > (double)(mean * options.wordBreakdownRatio)) {
            word = new WordCandidate();
            word.line = line;
            word.letters.add(line.letters.get(0));
            words.add(word);
            for (int i = 0; i < spacings.length; ++i) {
                if (spacings[i] > threshold) {
                    word = new WordCandidate();
                    words.add(word);
                }
                word.letters.add(line.letters.get(i + 1));
            }
        } else {
            word = new WordCandidate();
            word.line = line;
            word.letters = line.letters;
            words.add(word);
        }
        for (WordCandidate w : words) {
            w.regularBoundingBox = LetterCandidate.computeBounds(w.letters);
            for (LetterCandidate letter : w.letters) {
                letter.word = w;
            }
        }
        return words;
    }

    public List<LetterCandidate> getLetters() {
        return this.letters;
    }

    public LineCandidate getLine() {
        return this.line;
    }
}

