/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.text.extraction.swt;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processing.edges.CannyEdgeDetector;
import org.openimaj.image.processing.edges.StrokeWidthTransform;
import org.openimaj.image.processing.resize.ResizeProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.image.text.extraction.swt.LetterCandidate;
import org.openimaj.image.text.extraction.swt.LineCandidate;
import org.openimaj.image.text.extraction.swt.WordCandidate;
import org.openimaj.util.set.DisjointSetForest;

@Reference(type=ReferenceType.Inproceedings, author={"Epshtein, B.", "Ofek, E.", "Wexler, Y."}, title="Detecting text in natural scenes with stroke width transform", year="2010", booktitle="Computer Vision and Pattern Recognition (CVPR), 2010 IEEE Conference on", pages={"2963", "2970"}, customData={"keywords", "image processing;text analysis;image operator;image pixel;natural images;natural scenes;stroke width transform;text detection;Colored noise;Computer vision;Engines;Filter bank;Geometry;Image segmentation;Layout;Optical character recognition software;Pixel;Robustness", "doi", "10.1109/CVPR.2010.5540041", "ISSN", "1063-6919"})
public class SWTTextDetector
implements ImageAnalyser<FImage> {
    private static final int[][] connect8 = new int[][]{{-1, 0}, {1, 0}, {0, -1}, {0, 1}, {-1, -1}, {1, -1}, {-1, 1}, {1, 1}};
    protected Options options;
    private List<LetterCandidate> letters = null;
    private List<LineCandidate> lines = null;
    private List<WordCandidate> words = null;

    public SWTTextDetector() {
        this(new Options());
    }

    public SWTTextDetector(Options options) {
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    private List<ConnectedComponent> findComponents(FImage image) {
        DisjointSetForest forest = new DisjointSetForest();
        Pixel current = new Pixel();
        Pixel next = new Pixel();
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                float currentValue = image.pixels[y][x];
                if (!(currentValue > 0.0f) || currentValue == Float.POSITIVE_INFINITY) continue;
                current.x = x;
                current.y = y;
                if (forest.makeSet((Object)current) != null) {
                    current = current.clone();
                }
                for (int i = 0; i < connect8.length; ++i) {
                    float value;
                    int xx = x + connect8[i][0];
                    int yy = y + connect8[i][1];
                    if (xx < 0 || xx >= image.width - 1 || yy < 0 || yy >= image.height - 1 || !((value = image.pixels[yy][xx]) > 0.0f) || value == Float.POSITIVE_INFINITY) continue;
                    next.x = xx;
                    next.y = yy;
                    if (forest.makeSet((Object)next) != null) {
                        next = next.clone();
                    }
                    if (!(Math.max(currentValue, value) / Math.min(currentValue, value) < this.options.strokeWidthRatio)) continue;
                    forest.union((Object)current, (Object)next);
                }
            }
        }
        ArrayList<ConnectedComponent> components = new ArrayList<ConnectedComponent>();
        for (Set pixels : forest.getSubsets()) {
            ConnectedComponent cc = new ConnectedComponent(pixels);
            components.add(cc);
        }
        return components;
    }

    public void analyseImage(FImage image) {
        this.letters = new ArrayList<LetterCandidate>();
        this.lines = new ArrayList<LineCandidate>();
        this.words = new ArrayList<WordCandidate>();
        if (this.options.doubleSize) {
            image = ResizeProcessor.doubleSize((FImage)image);
        }
        this.options.direction.detect(image, this);
    }

    protected void analyseImage(FImage image, FImage swt) {
        List<ConnectedComponent> comps = this.findComponents(swt);
        List<LetterCandidate> tmpLetters = LetterCandidate.findLetters(comps, swt, image, this.options);
        List<LineCandidate> tmpLines = LineCandidate.extractLines(tmpLetters, this.options);
        this.letters.addAll(tmpLetters);
        this.lines.addAll(tmpLines);
        for (LineCandidate line : tmpLines) {
            this.words.addAll(line.words);
        }
    }

    public List<LineCandidate> getLines() {
        return this.lines;
    }

    public List<LetterCandidate> getLetters() {
        return this.letters;
    }

    public static class Options {
        public Direction direction = Direction.DarkOnLight;
        public CannyEdgeDetector canny = new CannyEdgeDetector(1.0f);
        public boolean doubleSize = false;
        public float strokeWidthRatio = 3.0f;
        public double letterVarianceMean = 0.93;
        public double maxAspectRatio = 10.0;
        public double maxDiameterStrokeRatio = 10.0;
        public int minArea = 38;
        public float minHeight = 10.0f;
        public float maxHeight = 300.0f;
        public int maxNumOverlappingBoxes = 10;
        public int maxStrokeWidth = 70;
        public float medianStrokeWidthRatio = 2.0f;
        public float letterHeightRatio = 2.0f;
        public float intensityThreshold = 0.12f;
        public float widthMultiplier = 3.0f;
        public int minLettersPerLine = 3;
        public float intersectRatio = 1.3f;
        public float wordBreakdownRatio = 1.0f;
    }

    public static enum Direction {
        DarkOnLight{

            @Override
            protected void detect(FImage image, SWTTextDetector detector) {
                StrokeWidthTransform swt = new StrokeWidthTransform(true, detector.options.canny);
                swt.setMaxStrokeWidth(detector.options.maxStrokeWidth);
                FImage swtImage = (FImage)image.process((SinglebandImageProcessor)swt);
                detector.analyseImage(image, swtImage);
            }
        }
        ,
        LightOnDark{

            @Override
            protected void detect(FImage image, SWTTextDetector detector) {
                StrokeWidthTransform swt = new StrokeWidthTransform(false, detector.options.canny);
                swt.setMaxStrokeWidth(detector.options.maxStrokeWidth);
                FImage swtImage = (FImage)image.process((SinglebandImageProcessor)swt);
                detector.analyseImage(image, swtImage);
            }
        }
        ,
        Both{

            @Override
            protected void detect(FImage image, SWTTextDetector detector) {
                StrokeWidthTransform swt = new StrokeWidthTransform(true, detector.options.canny);
                swt.setMaxStrokeWidth(detector.options.maxStrokeWidth);
                FImage swtImage = (FImage)image.process((SinglebandImageProcessor)swt);
                detector.analyseImage(image, swtImage);
                swt.setDirection(false);
                swtImage = (FImage)image.process((SinglebandImageProcessor)swt);
                detector.analyseImage(image, swtImage);
            }
        };


        protected abstract void detect(FImage var1, SWTTextDetector var2);
    }
}

