/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.model.pixel;

import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.model.ImageClassificationModel;
import org.openimaj.util.pair.IndependentPair;

public abstract class PixelClassificationModel<Q, T extends Image<Q, T>>
implements ImageClassificationModel<T> {
    private static final long serialVersionUID = 1L;

    protected abstract float classifyPixel(Q var1);

    @Override
    public FImage classifyImage(T im) {
        FImage out = new FImage(im.getWidth(), im.getHeight());
        for (int y = 0; y < im.getHeight(); ++y) {
            for (int x = 0; x < im.getWidth(); ++x) {
                out.pixels[y][x] = this.classifyPixel(im.getPixel(x, y));
            }
        }
        return out;
    }

    protected abstract T[] getArray(int var1);

    public boolean estimate(List<? extends IndependentPair<T, FImage>> data) {
        Image[] samples = this.getArray(data.size());
        for (int i = 0; i < data.size(); ++i) {
            samples[i] = (Image)data.get(i).firstObject();
        }
        this.learnModel(samples);
        return true;
    }

    public int numItemsToEstimate() {
        return 1;
    }

    public FImage predict(T data) {
        return this.classifyImage(data);
    }

    public abstract PixelClassificationModel<Q, T> clone();
}

