/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import gnu.trove.map.hash.TObjectFloatHashMap;
import gnu.trove.procedure.TObjectFloatProcedure;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.processor.connectedcomponent.render.BoundingBoxRenderer;
import org.openimaj.image.saliency.YehSaliency;
import org.openimaj.util.array.ArrayUtils;

@Reference(type=ReferenceType.Inproceedings, author={"Che-Hua Yeh", "Yuan-Chen Ho", "Brian A. Barsky", "Ming Ouhyoung"}, title="Personalized Photograph Ranking and Selection System", year="2010", booktitle="Proceedings of ACM Multimedia", pages={"211", "220"}, month="October", customData={"location", "Florence, Italy"})
public class ROIProportion
implements ImageAnalyser<MBFImage>,
FeatureVectorProvider<DoubleFV> {
    protected YehSaliency saliencyGenerator;
    protected float alpha = 0.67f;
    protected double roiProportion;

    public ROIProportion() {
        this.saliencyGenerator = new YehSaliency();
    }

    public ROIProportion(float alpha) {
        this();
        this.alpha = alpha;
    }

    public ROIProportion(float saliencySigma, float segmenterSigma, float k, int minSize, float alpha) {
        this.saliencyGenerator = new YehSaliency(saliencySigma, segmenterSigma, k, minSize);
        this.alpha = alpha;
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(new double[]{this.roiProportion});
    }

    public void analyseImage(MBFImage image) {
        image.analyseWith((ImageAnalyser)this.saliencyGenerator);
        TObjectFloatHashMap<ConnectedComponent> componentMap = this.saliencyGenerator.getSaliencyComponents();
        float max = ArrayUtils.maxValue((float[])componentMap.values());
        FImage map = new FImage(image.getWidth(), image.getHeight());
        final float thresh = max * this.alpha;
        final BoundingBoxRenderer renderer = new BoundingBoxRenderer((Image)map, (Object)Float.valueOf(1.0f), true);
        componentMap.forEachEntry((TObjectFloatProcedure)new TObjectFloatProcedure<ConnectedComponent>(){

            public boolean execute(ConnectedComponent cc, float sal) {
                if (sal >= thresh) {
                    renderer.process(cc);
                }
                return true;
            }
        });
        this.roiProportion = 0.0;
        for (int y = 0; y < map.height; ++y) {
            for (int x = 0; x < map.width; ++x) {
                this.roiProportion += (double)map.pixels[y][x];
            }
        }
        this.roiProportion /= (double)(map.width * map.height);
    }
}

