/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.mask.AbstractMaskedObject;

public class AvgBrightness
extends AbstractMaskedObject<FImage>
implements ImageAnalyser<MBFImage>,
FeatureVectorProvider<DoubleFV> {
    private Mode mode;
    private double brightness;

    public AvgBrightness() {
        this(Mode.NTSC_LUMINANCE, null);
    }

    public AvgBrightness(Mode mode) {
        this(mode, null);
    }

    public AvgBrightness(Mode mode, FImage mask) {
        super((Image)mask);
        this.mode = mode;
    }

    public void analyseImage(MBFImage image) {
        this.brightness = this.mode.computeBrightness(image, (FImage)this.mask);
    }

    public double getBrightness() {
        return this.brightness;
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(new double[]{this.brightness});
    }

    public static enum Mode {
        NTSC_LUMINANCE{

            @Override
            public double computeBrightness(MBFImage image, FImage mask) {
                FImage R = (FImage)image.getBand(0);
                FImage G = (FImage)image.getBand(1);
                FImage B = (FImage)image.getBand(2);
                double brightness = 0.0;
                if (mask != null) {
                    for (int y = 0; y < R.height; ++y) {
                        for (int x = 0; x < R.width; ++x) {
                            if (mask.pixels[y][x] != 1.0f) continue;
                            brightness += (double)(0.299f * R.pixels[y][x] + 0.587f * G.pixels[y][x] + 0.114f * B.pixels[y][x]);
                        }
                    }
                } else {
                    for (int y = 0; y < R.height; ++y) {
                        for (int x = 0; x < R.width; ++x) {
                            brightness += (double)(0.299f * R.pixels[y][x] + 0.587f * G.pixels[y][x] + 0.114f * B.pixels[y][x]);
                        }
                    }
                }
                return brightness / (double)(R.height * R.width);
            }
        };


        public abstract double computeBrightness(MBFImage var1, FImage var2);
    }
}

