/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.dense.gradient.dsift;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.feature.local.list.MemoryLocalFeatureList;
import org.openimaj.image.Image;
import org.openimaj.image.feature.dense.gradient.dsift.AbstractDenseSIFT;
import org.openimaj.image.feature.dense.gradient.dsift.ByteDSIFTKeypoint;
import org.openimaj.image.feature.dense.gradient.dsift.FloatDSIFTKeypoint;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.array.ArrayUtils;
import org.openimaj.util.pair.IntObjectPair;

public class PyramidDenseSIFT<IMAGE extends Image<?, IMAGE>>
extends AbstractDenseSIFT<IMAGE> {
    int[] sizes;
    float magnificationFactor;
    private List<AbstractDenseSIFT<IMAGE>> levels;

    public PyramidDenseSIFT(AbstractDenseSIFT<IMAGE> dsift, float magFactor, int ... sizes) {
        this.sizes = sizes;
        this.magnificationFactor = magFactor;
        this.levels = new ArrayList<AbstractDenseSIFT<IMAGE>>(sizes.length);
        for (int i = 0; i < sizes.length; ++i) {
            this.levels.add((AbstractDenseSIFT<IMAGE>)dsift.clone());
        }
    }

    @Override
    public void analyseImage(IMAGE image, Rectangle originalBounds) {
        Rectangle bounds = originalBounds;
        for (int i = 0; i < this.sizes.length; ++i) {
            Object smoothed;
            int size = this.sizes[i];
            int offset = (int)Math.floor(1.5f * (float)(ArrayUtils.maxValue((int[])this.sizes) - size));
            if (this.magnificationFactor == 0.0f) {
                smoothed = image;
            } else {
                float sigma = (float)size / this.magnificationFactor;
                smoothed = ((SinglebandImageProcessor.Processable)image).process((SinglebandImageProcessor)new FGaussianConvolve(sigma));
            }
            bounds.x = originalBounds.x + (float)offset;
            bounds.y = originalBounds.y + (float)offset;
            AbstractDenseSIFT<IMAGE> dsift = this.levels.get(i);
            dsift.setBinWidth(size);
            dsift.setBinHeight(size);
            dsift.analyseImage(smoothed, bounds);
        }
    }

    @Override
    public LocalFeatureList<FloatDSIFTKeypoint> getFloatKeypoints() {
        MemoryLocalFeatureList kpts = new MemoryLocalFeatureList(this.getNumOriBins() * this.getNumBinsX() * this.getNumBinsY());
        for (int i = 0; i < this.sizes.length; ++i) {
            AbstractDenseSIFT<IMAGE> dsift = this.levels.get(i);
            kpts.addAll(dsift.getFloatKeypoints());
        }
        return kpts;
    }

    @Override
    public LocalFeatureList<ByteDSIFTKeypoint> getByteKeypoints() {
        MemoryLocalFeatureList kpts = new MemoryLocalFeatureList(this.getNumOriBins() * this.getNumBinsX() * this.getNumBinsY());
        for (int i = 0; i < this.sizes.length; ++i) {
            AbstractDenseSIFT<IMAGE> dsift = this.levels.get(i);
            kpts.addAll(dsift.getByteKeypoints());
        }
        return kpts;
    }

    @Override
    public LocalFeatureList<FloatDSIFTKeypoint> getFloatKeypoints(float energyThreshold) {
        MemoryLocalFeatureList kpts = new MemoryLocalFeatureList(this.getNumOriBins() * this.getNumBinsX() * this.getNumBinsY());
        for (int i = 0; i < this.sizes.length; ++i) {
            AbstractDenseSIFT<IMAGE> dsift = this.levels.get(i);
            kpts.addAll(dsift.getFloatKeypoints(energyThreshold));
        }
        return kpts;
    }

    @Override
    public LocalFeatureList<ByteDSIFTKeypoint> getByteKeypoints(float energyThreshold) {
        MemoryLocalFeatureList kpts = new MemoryLocalFeatureList(this.getNumOriBins() * this.getNumBinsX() * this.getNumBinsY());
        for (int i = 0; i < this.sizes.length; ++i) {
            AbstractDenseSIFT<IMAGE> dsift = this.levels.get(i);
            kpts.addAll(dsift.getByteKeypoints(energyThreshold));
        }
        return kpts;
    }

    public List<IntObjectPair<LocalFeatureList<FloatDSIFTKeypoint>>> getFloatKeypointsGrouped() {
        ArrayList<IntObjectPair<LocalFeatureList<FloatDSIFTKeypoint>>> prs = new ArrayList<IntObjectPair<LocalFeatureList<FloatDSIFTKeypoint>>>(this.sizes.length);
        for (int i = 0; i < this.sizes.length; ++i) {
            AbstractDenseSIFT<IMAGE> dsift = this.levels.get(i);
            prs.add((IntObjectPair<LocalFeatureList<FloatDSIFTKeypoint>>)new IntObjectPair(this.sizes[i], dsift.getFloatKeypoints()));
        }
        return prs;
    }

    public List<IntObjectPair<LocalFeatureList<ByteDSIFTKeypoint>>> getByteKeypointsGrouped() {
        ArrayList<IntObjectPair<LocalFeatureList<ByteDSIFTKeypoint>>> prs = new ArrayList<IntObjectPair<LocalFeatureList<ByteDSIFTKeypoint>>>(this.sizes.length);
        for (int i = 0; i < this.sizes.length; ++i) {
            AbstractDenseSIFT<IMAGE> dsift = this.levels.get(i);
            prs.add((IntObjectPair<LocalFeatureList<ByteDSIFTKeypoint>>)new IntObjectPair(this.sizes[i], dsift.getByteKeypoints()));
        }
        return prs;
    }

    public List<IntObjectPair<LocalFeatureList<FloatDSIFTKeypoint>>> getFloatKeypointsGrouped(float energyThreshold) {
        ArrayList<IntObjectPair<LocalFeatureList<FloatDSIFTKeypoint>>> prs = new ArrayList<IntObjectPair<LocalFeatureList<FloatDSIFTKeypoint>>>(this.sizes.length);
        for (int i = 0; i < this.sizes.length; ++i) {
            AbstractDenseSIFT<IMAGE> dsift = this.levels.get(i);
            prs.add((IntObjectPair<LocalFeatureList<FloatDSIFTKeypoint>>)new IntObjectPair(this.sizes[i], dsift.getFloatKeypoints(energyThreshold)));
        }
        return prs;
    }

    public List<IntObjectPair<LocalFeatureList<ByteDSIFTKeypoint>>> getByteKeypointsGrouped(float energyThreshold) {
        ArrayList<IntObjectPair<LocalFeatureList<ByteDSIFTKeypoint>>> prs = new ArrayList<IntObjectPair<LocalFeatureList<ByteDSIFTKeypoint>>>(this.sizes.length);
        for (int i = 0; i < this.sizes.length; ++i) {
            AbstractDenseSIFT<IMAGE> dsift = this.levels.get(i);
            prs.add((IntObjectPair<LocalFeatureList<ByteDSIFTKeypoint>>)new IntObjectPair(this.sizes[i], dsift.getByteKeypoints(energyThreshold)));
        }
        return prs;
    }

    public float[][][] getLevelDescriptors() {
        float[][][] descr = new float[this.sizes.length][][];
        for (int i = 0; i < this.sizes.length; ++i) {
            descr[i] = this.levels.get(i).getDescriptors();
        }
        return descr;
    }

    public int[] getSizes() {
        return this.sizes;
    }

    @Override
    public void setBinWidth(int size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinHeight(int size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getBinWidth() {
        return this.sizes[0];
    }

    @Override
    public int getBinHeight() {
        return this.sizes[0];
    }

    @Override
    public int getNumBinsX() {
        return this.levels.get(0).getNumBinsX();
    }

    @Override
    public int getNumBinsY() {
        return this.levels.get(0).getNumBinsY();
    }

    @Override
    public int getNumOriBins() {
        return this.levels.get(0).getNumOriBins();
    }

    @Override
    public float[][] getDescriptors() {
        int len = 0;
        for (int i = 0; i < this.sizes.length; ++i) {
            len += this.levels.get(i).getDescriptors().length;
        }
        float[][] descr = new float[len][];
        int offset = 0;
        for (int i = 0; i < this.sizes.length; ++i) {
            float[][] ldescr = this.levels.get(i).getDescriptors();
            for (int j = 0; j < ldescr.length; ++j) {
                descr[offset++] = ldescr[j];
            }
        }
        return descr;
    }
}

