/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.dense.gradient.dsift;

import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.feature.local.list.MemoryLocalFeatureList;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.feature.dense.gradient.dsift.AbstractDenseSIFT;
import org.openimaj.image.feature.dense.gradient.dsift.ByteDSIFTKeypoint;
import org.openimaj.image.feature.dense.gradient.dsift.DenseSIFT;
import org.openimaj.image.feature.dense.gradient.dsift.FloatDSIFTKeypoint;
import org.openimaj.math.geometry.shape.Rectangle;

public class ColourDenseSIFT
extends AbstractDenseSIFT<MBFImage> {
    DenseSIFT dsift;
    ColourSpace colourSpace;
    volatile float[][] descriptors;
    volatile float[] energies;

    public ColourDenseSIFT(DenseSIFT dsift, ColourSpace colourSpace) {
        this.dsift = dsift;
        this.colourSpace = colourSpace;
    }

    @Override
    public void analyseImage(MBFImage image, Rectangle bounds) {
        int i;
        MBFImage cimg = this.colourSpace.convert(image);
        this.dsift.analyseImage((FImage)cimg.bands.get(0), bounds);
        int len = this.dsift.descriptors[0].length;
        this.descriptors = new float[this.dsift.descriptors.length][len * cimg.bands.size()];
        float[][] tmpEnergies = new float[this.dsift.descriptors.length][cimg.bands.size()];
        for (i = 0; i < this.descriptors.length; ++i) {
            System.arraycopy(this.dsift.descriptors[i], 0, this.descriptors[i], 0, len);
            tmpEnergies[i][0] = this.dsift.energies[i];
        }
        for (int j = 1; j < cimg.bands.size(); ++j) {
            this.dsift.analyseImage((FImage)cimg.bands.get(j), bounds);
            for (int i2 = 0; i2 < this.descriptors.length; ++i2) {
                System.arraycopy(this.dsift.descriptors[i2], 0, this.descriptors[i2], j * len, len);
                tmpEnergies[i2][j] = this.dsift.energies[i2];
            }
        }
        this.energies = new float[this.descriptors.length];
        for (i = 0; i < this.descriptors.length; ++i) {
            this.energies[i] = this.colourSpace.computeIntensity(tmpEnergies[i]);
        }
    }

    @Override
    public LocalFeatureList<FloatDSIFTKeypoint> getFloatKeypoints() {
        MemoryLocalFeatureList keys = new MemoryLocalFeatureList(this.dsift.numOriBins * this.dsift.numBinsX * this.dsift.numBinsY, this.descriptors.length);
        int frameSizeX = this.dsift.binWidth * (this.dsift.numBinsX - 1) + 1;
        int frameSizeY = this.dsift.binHeight * (this.dsift.numBinsY - 1) + 1;
        float deltaCenterX = 0.5f * (float)this.dsift.binWidth * (float)(this.dsift.numBinsX - 1);
        float deltaCenterY = 0.5f * (float)this.dsift.binHeight * (float)(this.dsift.numBinsY - 1);
        int i = 0;
        for (int framey = this.dsift.data.boundMinY; framey <= this.dsift.data.boundMaxY - frameSizeY + 1; framey += this.dsift.stepY) {
            int framex = this.dsift.data.boundMinX;
            while (framex <= this.dsift.data.boundMaxX - frameSizeX + 1) {
                keys.add((Object)new FloatDSIFTKeypoint((float)framex + deltaCenterX, (float)framey + deltaCenterY, this.descriptors[i], this.energies[i]));
                framex += this.dsift.stepX;
                ++i;
            }
        }
        return keys;
    }

    @Override
    public LocalFeatureList<ByteDSIFTKeypoint> getByteKeypoints() {
        MemoryLocalFeatureList keys = new MemoryLocalFeatureList(this.dsift.numOriBins * this.dsift.numBinsX * this.dsift.numBinsY, this.descriptors.length);
        int frameSizeX = this.dsift.binWidth * (this.dsift.numBinsX - 1) + 1;
        int frameSizeY = this.dsift.binHeight * (this.dsift.numBinsY - 1) + 1;
        float deltaCenterX = 0.5f * (float)this.dsift.binWidth * (float)(this.dsift.numBinsX - 1);
        float deltaCenterY = 0.5f * (float)this.dsift.binHeight * (float)(this.dsift.numBinsY - 1);
        int i = 0;
        for (int framey = this.dsift.data.boundMinY; framey <= this.dsift.data.boundMaxY - frameSizeY + 1; framey += this.dsift.stepY) {
            int framex = this.dsift.data.boundMinX;
            while (framex <= this.dsift.data.boundMaxX - frameSizeX + 1) {
                keys.add((Object)new ByteDSIFTKeypoint((float)framex + deltaCenterX, (float)framey + deltaCenterY, this.descriptors[i], this.energies[i]));
                framex += this.dsift.stepX;
                ++i;
            }
        }
        return keys;
    }

    @Override
    public LocalFeatureList<FloatDSIFTKeypoint> getFloatKeypoints(float energyThreshold) {
        MemoryLocalFeatureList keys = new MemoryLocalFeatureList(this.dsift.numOriBins * this.dsift.numBinsX * this.dsift.numBinsY);
        int frameSizeX = this.dsift.binWidth * (this.dsift.numBinsX - 1) + 1;
        int frameSizeY = this.dsift.binHeight * (this.dsift.numBinsY - 1) + 1;
        float deltaCenterX = 0.5f * (float)this.dsift.binWidth * (float)(this.dsift.numBinsX - 1);
        float deltaCenterY = 0.5f * (float)this.dsift.binHeight * (float)(this.dsift.numBinsY - 1);
        int i = 0;
        for (int framey = this.dsift.data.boundMinY; framey <= this.dsift.data.boundMaxY - frameSizeY + 1; framey += this.dsift.stepY) {
            int framex = this.dsift.data.boundMinX;
            while (framex <= this.dsift.data.boundMaxX - frameSizeX + 1) {
                if (this.energies[i] >= energyThreshold) {
                    keys.add((Object)new FloatDSIFTKeypoint((float)framex + deltaCenterX, (float)framey + deltaCenterY, this.descriptors[i], this.energies[i]));
                }
                framex += this.dsift.stepX;
                ++i;
            }
        }
        return keys;
    }

    @Override
    public LocalFeatureList<ByteDSIFTKeypoint> getByteKeypoints(float energyThreshold) {
        MemoryLocalFeatureList keys = new MemoryLocalFeatureList(this.dsift.numOriBins * this.dsift.numBinsX * this.dsift.numBinsY);
        int frameSizeX = this.dsift.binWidth * (this.dsift.numBinsX - 1) + 1;
        int frameSizeY = this.dsift.binHeight * (this.dsift.numBinsY - 1) + 1;
        float deltaCenterX = 0.5f * (float)this.dsift.binWidth * (float)(this.dsift.numBinsX - 1);
        float deltaCenterY = 0.5f * (float)this.dsift.binHeight * (float)(this.dsift.numBinsY - 1);
        int i = 0;
        for (int framey = this.dsift.data.boundMinY; framey <= this.dsift.data.boundMaxY - frameSizeY + 1; framey += this.dsift.stepY) {
            int framex = this.dsift.data.boundMinX;
            while (framex <= this.dsift.data.boundMaxX - frameSizeX + 1) {
                if (this.energies[i] >= energyThreshold) {
                    keys.add((Object)new ByteDSIFTKeypoint((float)framex + deltaCenterX, (float)framey + deltaCenterY, this.descriptors[i], this.energies[i]));
                }
                framex += this.dsift.stepX;
                ++i;
            }
        }
        return keys;
    }

    @Override
    public void setBinWidth(int size) {
        this.dsift.setBinWidth(size);
    }

    @Override
    public void setBinHeight(int size) {
        this.dsift.setBinHeight(size);
    }

    @Override
    public int getBinWidth() {
        return 0;
    }

    @Override
    public int getBinHeight() {
        return 0;
    }

    @Override
    public int getNumBinsX() {
        return 0;
    }

    @Override
    public int getNumBinsY() {
        return 0;
    }

    @Override
    public int getNumOriBins() {
        return 0;
    }

    @Override
    public float[][] getDescriptors() {
        return this.descriptors;
    }
}

