/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.astheticode;

import java.util.Arrays;
import org.openimaj.image.contour.Contour;

public class Aestheticode {
    public int[] code;
    public Contour root;

    public Aestheticode(int[] code) {
        this.code = code;
        Arrays.sort(code);
    }

    public Aestheticode(Aestheticode acode) {
        this.code = (int[])acode.code.clone();
        this.root = acode.root;
    }

    public Aestheticode(Contour root) {
        this.root = root;
        this.code = new int[root.children.size()];
        int i = 0;
        for (Contour child : root.children) {
            this.code[i++] = child.children.size();
        }
        Arrays.sort(this.code);
    }

    public int hashCode() {
        return Arrays.hashCode(this.code);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Aestheticode)) {
            return false;
        }
        Aestheticode that = (Aestheticode)obj;
        if (that.code.length != this.code.length) {
            return false;
        }
        for (int i = 0; i < this.code.length; ++i) {
            if (this.code[i] == that.code[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String ret = "" + this.code[0];
        for (int i = 1; i < this.code.length; ++i) {
            ret = ret + ":" + this.code[i];
        }
        return ret;
    }
}

