/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.model;

import info.bliki.htmlcleaner.TagToken;
import info.bliki.wiki.model.IConfiguration;
import info.bliki.wiki.tags.ATag;
import info.bliki.wiki.tags.BrTag;
import info.bliki.wiki.tags.DdTag;
import info.bliki.wiki.tags.DlTag;
import info.bliki.wiki.tags.DtTag;
import info.bliki.wiki.tags.HTMLBlockTag;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.HrTag;
import info.bliki.wiki.tags.MathTag;
import info.bliki.wiki.tags.NowikiTag;
import info.bliki.wiki.tags.PTag;
import info.bliki.wiki.tags.PreTag;
import info.bliki.wiki.tags.RefTag;
import info.bliki.wiki.tags.ReferencesTag;
import info.bliki.wiki.tags.SourceTag;
import info.bliki.wiki.tags.code.ABAPCodeFilter;
import info.bliki.wiki.tags.code.CSharpCodeFilter;
import info.bliki.wiki.tags.code.GroovyCodeFilter;
import info.bliki.wiki.tags.code.JavaCodeFilter;
import info.bliki.wiki.tags.code.JavaScriptCodeFilter;
import info.bliki.wiki.tags.code.PHPCodeFilter;
import info.bliki.wiki.tags.code.PythonCodeFilter;
import info.bliki.wiki.tags.code.SQLCodeFilter;
import info.bliki.wiki.tags.code.SourceCodeFormatter;
import info.bliki.wiki.tags.code.XMLCodeFilter;
import info.bliki.wiki.template.Anchorencode;
import info.bliki.wiki.template.Expr;
import info.bliki.wiki.template.Formatnum;
import info.bliki.wiki.template.Fullurl;
import info.bliki.wiki.template.ITemplateFunction;
import info.bliki.wiki.template.If;
import info.bliki.wiki.template.Ifeq;
import info.bliki.wiki.template.Iferror;
import info.bliki.wiki.template.Ifexist;
import info.bliki.wiki.template.Ifexpr;
import info.bliki.wiki.template.LC;
import info.bliki.wiki.template.LCFirst;
import info.bliki.wiki.template.Localurl;
import info.bliki.wiki.template.NS;
import info.bliki.wiki.template.Padleft;
import info.bliki.wiki.template.Padright;
import info.bliki.wiki.template.Plural;
import info.bliki.wiki.template.Switch;
import info.bliki.wiki.template.Tag;
import info.bliki.wiki.template.Time;
import info.bliki.wiki.template.Titleparts;
import info.bliki.wiki.template.UC;
import info.bliki.wiki.template.UCFirst;
import info.bliki.wiki.template.URLEncode;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements IConfiguration {
    private static final String INTERWIKI_RESOURCE_NAME = "/interwiki.properties";
    public static Properties interwikiMapping;
    public static final String BLOCK_TAGS = "|address|blockquote|center|del|dir|div|dl|fieldset|form|h1|h2|h3|h4|h5|h6|hr|ins|isindex|menu|noframes|noscript|ol|p|pre|table|ul|";
    public static final String INLINE_TAGS = "|a|abbr|acronym|applet|snippet|b|basefont|bdo|big|br|button|cite|code|del|dfn|em|font|i|img|ins|input|iframe|kbd|label|map|object|q|samp|script|select|small|span|strong|sub|sup|textarea|tt|var|";
    public static final String SPECIAL_BLOCK_TAGS = "|applet|snippet|blockquote|body|button|center|dd|del|div|fieldset|form|iframe|ins|li|map|noframes|noscript|object|td|th|";
    static final HTMLTag HTML_A_OPEN;
    public static final HTMLTag HTML_EM_OPEN;
    public static final HTMLTag HTML_H1_OPEN;
    public static final HTMLTag HTML_H2_OPEN;
    public static final HTMLTag HTML_H3_OPEN;
    public static final HTMLTag HTML_H4_OPEN;
    public static final HTMLTag HTML_H5_OPEN;
    public static final HTMLTag HTML_H6_OPEN;
    public static final HTMLTag HTML_ITALIC_OPEN;
    public static final HTMLTag HTML_BOLD_OPEN;
    public static final HTMLTag HTML_PARAGRAPH_OPEN;
    public static final HTMLTag HTML_BLOCKQUOTE_OPEN;
    public static final HTMLTag HTML_STRIKE_OPEN;
    public static final HTMLTag HTML_STRONG_OPEN;
    public static final HTMLTag HTML_UNDERLINE_OPEN;
    public static final HTMLTag HTML_SUB_OPEN;
    public static final HTMLTag HTML_SUP_OPEN;
    public static final HTMLTag HTML_CENTER_OPEN;
    public static final HTMLTag HTML_TT_OPEN;
    public static final HTMLTag HTML_TABLE_OPEN;
    public static final HTMLTag HTML_CAPTION_OPEN;
    public static final HTMLTag HTML_TH_OPEN;
    public static final HTMLTag HTML_TR_OPEN;
    public static final HTMLTag HTML_TD_OPEN;
    public static final HTMLTag HTML_UL_OPEN;
    public static final HTMLTag HTML_OL_OPEN;
    public static final HTMLTag HTML_LI_OPEN;
    public static final HTMLTag HTML_FONT_OPEN;
    public static final HTMLTag HTML_CITE_OPEN;
    public static final HTMLTag HTML_DIV_OPEN;
    public static final HTMLTag HTML_DD_OPEN;
    public static final HTMLTag HTML_DL_OPEN;
    public static final HTMLTag HTML_DT_OPEN;
    public static final HTMLTag HTML_SPAN_OPEN;
    public static final HTMLTag HTML_VAR_OPEN;
    public static final HTMLTag HTML_CODE_OPEN;
    public static final HTMLTag HTML_S_OPEN;
    public static final HTMLTag HTML_SMALL_OPEN;
    public static final HTMLTag HTML_BIG_OPEN;
    public static final HTMLTag HTML_U_OPEN;
    public static final HTMLTag HTML_DEL_OPEN;
    public static final HTMLTag HTML_PRE_OPEN;
    public static Map<String, String> TEMPLATE_CALLS_CACHE;
    protected static final Map<String, String> INTERWIKI_MAP;
    protected static final HashMap<String, TagToken> TAG_TOKEN_MAP;
    protected static final HashMap<String, SourceCodeFormatter> CODE_FORMATTER_MAP;
    protected static final Map<String, ITemplateFunction> TEMPLATE_FUNCTION_MAP;
    protected static final Set<String> URI_SCHEME_MAP;
    public static final Pattern NOWIKI_OPEN_PATTERN;
    public static final Pattern NOWIKI_CLOSE_PATTERN;
    public static final Configuration DEFAULT_CONFIGURATION;
    public static final int PARSER_RECURSION_LIMIT = 32;
    public static final int RENDERER_RECURSION_LIMIT = 256;
    public static final int TEMPLATE_RECURSION_LIMIT = 100000;
    public static final int TEMPLATE_BUFFER_LIMIT = 65536;
    public static final int TEMPLATE_VALUE_LIMIT = 8192;
    public static final int GLOBAL_RECURSION_LIMIT = 100000;

    @Override
    public Map<String, String> getInterwikiMap() {
        return INTERWIKI_MAP;
    }

    @Override
    public String addInterwikiLink(String key, String value) {
        return INTERWIKI_MAP.put(key, value);
    }

    @Override
    public Set<String> getUriSchemeSet() {
        return URI_SCHEME_MAP;
    }

    public boolean addUriScheme(String uriKey) {
        return URI_SCHEME_MAP.add(uriKey);
    }

    public boolean containsUriScheme(String uriKey) {
        return URI_SCHEME_MAP.contains(uriKey);
    }

    @Override
    public Map<String, ITemplateFunction> getTemplateMap() {
        return TEMPLATE_FUNCTION_MAP;
    }

    @Override
    public ITemplateFunction addTemplateFunction(String key, ITemplateFunction value) {
        return TEMPLATE_FUNCTION_MAP.put(key, value);
    }

    @Override
    public Map<String, String> getTemplateCallsCache() {
        return TEMPLATE_CALLS_CACHE;
    }

    @Override
    public void setTemplateCallsCache(Map<String, String> map) {
        TEMPLATE_CALLS_CACHE = map;
    }

    @Override
    public Map<String, SourceCodeFormatter> getCodeFormatterMap() {
        return CODE_FORMATTER_MAP;
    }

    @Override
    public SourceCodeFormatter addCodeFormatter(String key, SourceCodeFormatter value) {
        return CODE_FORMATTER_MAP.put(key, value);
    }

    @Override
    public Map<String, TagToken> getTokenMap() {
        return TAG_TOKEN_MAP;
    }

    @Override
    public TagToken addTokenTag(String key, TagToken value) {
        return TAG_TOKEN_MAP.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String propertyFile) {
        Properties properties = new Properties();
        InputStream in = null;
        FileInputStream fis = null;
        try {
            in = Configuration.class.getResourceAsStream(propertyFile);
            properties.load(in);
        }
        catch (Exception e) {
            System.err.println("Configuration.java - Properties file:" + propertyFile + " not found.");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    static {
        HTML_A_OPEN = new ATag();
        HTML_EM_OPEN = new HTMLTag("em");
        HTML_H1_OPEN = new HTMLBlockTag("h1", SPECIAL_BLOCK_TAGS);
        HTML_H2_OPEN = new HTMLBlockTag("h2", SPECIAL_BLOCK_TAGS);
        HTML_H3_OPEN = new HTMLBlockTag("h3", SPECIAL_BLOCK_TAGS);
        HTML_H4_OPEN = new HTMLBlockTag("h4", SPECIAL_BLOCK_TAGS);
        HTML_H5_OPEN = new HTMLBlockTag("h5", SPECIAL_BLOCK_TAGS);
        HTML_H6_OPEN = new HTMLBlockTag("h6", SPECIAL_BLOCK_TAGS);
        HTML_ITALIC_OPEN = new HTMLTag("i");
        HTML_BOLD_OPEN = new HTMLTag("b");
        HTML_PARAGRAPH_OPEN = new PTag();
        HTML_BLOCKQUOTE_OPEN = new HTMLBlockTag("blockquote", SPECIAL_BLOCK_TAGS);
        HTML_STRIKE_OPEN = new HTMLTag("strike");
        HTML_STRONG_OPEN = new HTMLTag("strong");
        HTML_UNDERLINE_OPEN = new HTMLTag("u");
        HTML_SUB_OPEN = new HTMLTag("sub");
        HTML_SUP_OPEN = new HTMLTag("sup");
        HTML_CENTER_OPEN = new HTMLTag("center");
        HTML_TT_OPEN = new HTMLTag("tt");
        HTML_TABLE_OPEN = new HTMLBlockTag("table", SPECIAL_BLOCK_TAGS);
        HTML_CAPTION_OPEN = new HTMLBlockTag("caption", "|table|");
        HTML_TH_OPEN = new HTMLBlockTag("th", "|tr|");
        HTML_TR_OPEN = new HTMLBlockTag("tr", "|table|tbody|tfoot|thead|");
        HTML_TD_OPEN = new HTMLBlockTag("td", "|tr|");
        HTML_UL_OPEN = new HTMLBlockTag("ul", SPECIAL_BLOCK_TAGS);
        HTML_OL_OPEN = new HTMLBlockTag("ol", SPECIAL_BLOCK_TAGS);
        HTML_LI_OPEN = new HTMLBlockTag("li", "|dir|menu|ol|ul|");
        HTML_FONT_OPEN = new HTMLTag("font");
        HTML_CITE_OPEN = new HTMLTag("cite");
        HTML_DIV_OPEN = new HTMLBlockTag("div", SPECIAL_BLOCK_TAGS);
        HTML_DD_OPEN = new DdTag();
        HTML_DL_OPEN = new DlTag();
        HTML_DT_OPEN = new DtTag();
        HTML_SPAN_OPEN = new HTMLTag("span");
        HTML_VAR_OPEN = new HTMLTag("var");
        HTML_CODE_OPEN = new HTMLTag("code");
        HTML_S_OPEN = new HTMLTag("s");
        HTML_SMALL_OPEN = new HTMLTag("small");
        HTML_BIG_OPEN = new HTMLTag("big");
        HTML_U_OPEN = new HTMLTag("u");
        HTML_DEL_OPEN = new HTMLTag("del");
        HTML_PRE_OPEN = new PreTag();
        TEMPLATE_CALLS_CACHE = null;
        INTERWIKI_MAP = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        TAG_TOKEN_MAP = new HashMap();
        CODE_FORMATTER_MAP = new HashMap();
        TEMPLATE_FUNCTION_MAP = new TreeMap<String, ITemplateFunction>(String.CASE_INSENSITIVE_ORDER);
        URI_SCHEME_MAP = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        NOWIKI_OPEN_PATTERN = Pattern.compile("\\<nowiki\\>", 2);
        NOWIKI_CLOSE_PATTERN = Pattern.compile("\\<\\/nowiki\\>", 2);
        interwikiMapping = Configuration.loadProperties(INTERWIKI_RESOURCE_NAME);
        URI_SCHEME_MAP.add("http");
        URI_SCHEME_MAP.add("https");
        URI_SCHEME_MAP.add("ftp");
        Enumeration<Object> eKeys = interwikiMapping.keys();
        while (eKeys.hasMoreElements()) {
            String key = (String)eKeys.nextElement();
            if (INTERWIKI_MAP.containsKey(key)) continue;
            INTERWIKI_MAP.put(key, interwikiMapping.getProperty(key));
        }
        TEMPLATE_FUNCTION_MAP.put("anchorencode", Anchorencode.CONST);
        TEMPLATE_FUNCTION_MAP.put("formatnum", Formatnum.CONST);
        TEMPLATE_FUNCTION_MAP.put("fullurl", Fullurl.CONST);
        TEMPLATE_FUNCTION_MAP.put("ns", NS.CONST);
        TEMPLATE_FUNCTION_MAP.put("urlencode", URLEncode.CONST);
        TEMPLATE_FUNCTION_MAP.put("lc", LC.CONST);
        TEMPLATE_FUNCTION_MAP.put("uc", UC.CONST);
        TEMPLATE_FUNCTION_MAP.put("localurl", Localurl.CONST);
        TEMPLATE_FUNCTION_MAP.put("lcfirst", LCFirst.CONST);
        TEMPLATE_FUNCTION_MAP.put("ucfirst", UCFirst.CONST);
        TEMPLATE_FUNCTION_MAP.put("padleft", Padleft.CONST);
        TEMPLATE_FUNCTION_MAP.put("padright", Padright.CONST);
        TEMPLATE_FUNCTION_MAP.put("plural", Plural.CONST);
        TEMPLATE_FUNCTION_MAP.put("#expr", Expr.CONST);
        TEMPLATE_FUNCTION_MAP.put("#if", If.CONST);
        TEMPLATE_FUNCTION_MAP.put("#iferror", Iferror.CONST);
        TEMPLATE_FUNCTION_MAP.put("#ifeq", Ifeq.CONST);
        TEMPLATE_FUNCTION_MAP.put("#ifexist", Ifexist.CONST);
        TEMPLATE_FUNCTION_MAP.put("#ifexpr", Ifexpr.CONST);
        TEMPLATE_FUNCTION_MAP.put("#switch", Switch.CONST);
        TEMPLATE_FUNCTION_MAP.put("#tag", Tag.CONST);
        TEMPLATE_FUNCTION_MAP.put("#time", Time.CONST);
        TEMPLATE_FUNCTION_MAP.put("#timel", Time.CONST);
        TEMPLATE_FUNCTION_MAP.put("#titleparts", Titleparts.CONST);
        CODE_FORMATTER_MAP.put("abap", new ABAPCodeFilter());
        CODE_FORMATTER_MAP.put("csharp", new CSharpCodeFilter());
        CODE_FORMATTER_MAP.put("groovy", new GroovyCodeFilter());
        CODE_FORMATTER_MAP.put("java", new JavaCodeFilter());
        CODE_FORMATTER_MAP.put("javascript", new JavaScriptCodeFilter());
        CODE_FORMATTER_MAP.put("php", new PHPCodeFilter());
        CODE_FORMATTER_MAP.put("python", new PythonCodeFilter());
        CODE_FORMATTER_MAP.put("html4strict", new XMLCodeFilter());
        CODE_FORMATTER_MAP.put("sql", new SQLCodeFilter());
        CODE_FORMATTER_MAP.put("xml", new XMLCodeFilter());
        TAG_TOKEN_MAP.put("br", new BrTag());
        TAG_TOKEN_MAP.put("hr", new HrTag());
        TAG_TOKEN_MAP.put("nowiki", new NowikiTag());
        TAG_TOKEN_MAP.put("pre", HTML_PRE_OPEN);
        TAG_TOKEN_MAP.put("math", new MathTag());
        TAG_TOKEN_MAP.put("ref", new RefTag());
        TAG_TOKEN_MAP.put("references", new ReferencesTag());
        TAG_TOKEN_MAP.put("syntaxhighlight", new SourceTag());
        TAG_TOKEN_MAP.put("source", new SourceTag());
        TAG_TOKEN_MAP.put("a", HTML_A_OPEN);
        TAG_TOKEN_MAP.put("h1", HTML_H1_OPEN);
        TAG_TOKEN_MAP.put("h2", HTML_H2_OPEN);
        TAG_TOKEN_MAP.put("h3", HTML_H3_OPEN);
        TAG_TOKEN_MAP.put("h4", HTML_H4_OPEN);
        TAG_TOKEN_MAP.put("h5", HTML_H5_OPEN);
        TAG_TOKEN_MAP.put("h6", HTML_H6_OPEN);
        TAG_TOKEN_MAP.put("em", HTML_EM_OPEN);
        TAG_TOKEN_MAP.put("i", HTML_ITALIC_OPEN);
        TAG_TOKEN_MAP.put("b", HTML_BOLD_OPEN);
        TAG_TOKEN_MAP.put("strong", HTML_STRONG_OPEN);
        TAG_TOKEN_MAP.put("u", HTML_UNDERLINE_OPEN);
        TAG_TOKEN_MAP.put("p", HTML_PARAGRAPH_OPEN);
        TAG_TOKEN_MAP.put("blockquote", HTML_BLOCKQUOTE_OPEN);
        TAG_TOKEN_MAP.put("var", HTML_VAR_OPEN);
        TAG_TOKEN_MAP.put("code", HTML_CODE_OPEN);
        TAG_TOKEN_MAP.put("s", HTML_S_OPEN);
        TAG_TOKEN_MAP.put("small", HTML_SMALL_OPEN);
        TAG_TOKEN_MAP.put("big", HTML_BIG_OPEN);
        TAG_TOKEN_MAP.put("del", HTML_DEL_OPEN);
        TAG_TOKEN_MAP.put("sub", HTML_SUB_OPEN);
        TAG_TOKEN_MAP.put("sup", HTML_SUP_OPEN);
        TAG_TOKEN_MAP.put("strike", HTML_STRIKE_OPEN);
        TAG_TOKEN_MAP.put("table", HTML_TABLE_OPEN);
        TAG_TOKEN_MAP.put("th", HTML_TH_OPEN);
        TAG_TOKEN_MAP.put("tr", HTML_TR_OPEN);
        TAG_TOKEN_MAP.put("td", HTML_TD_OPEN);
        TAG_TOKEN_MAP.put("caption", HTML_CAPTION_OPEN);
        TAG_TOKEN_MAP.put("ul", HTML_UL_OPEN);
        TAG_TOKEN_MAP.put("ol", HTML_OL_OPEN);
        TAG_TOKEN_MAP.put("li", HTML_LI_OPEN);
        TAG_TOKEN_MAP.put("font", HTML_FONT_OPEN);
        TAG_TOKEN_MAP.put("center", HTML_CENTER_OPEN);
        TAG_TOKEN_MAP.put("tt", HTML_TT_OPEN);
        TAG_TOKEN_MAP.put("div", HTML_DIV_OPEN);
        TAG_TOKEN_MAP.put("span", HTML_SPAN_OPEN);
        TAG_TOKEN_MAP.put("cite", HTML_CITE_OPEN);
        DEFAULT_CONFIGURATION = new Configuration();
    }
}

