/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.model;

import info.bliki.Messages;
import info.bliki.htmlcleaner.BaseToken;
import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.TagNode;
import info.bliki.htmlcleaner.TagToken;
import info.bliki.htmlcleaner.Utils;
import info.bliki.wiki.filter.AbstractParser;
import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.filter.HTMLConverter;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.MagicWord;
import info.bliki.wiki.filter.PDFConverter;
import info.bliki.wiki.filter.SectionHeader;
import info.bliki.wiki.filter.TemplateParser;
import info.bliki.wiki.filter.WikipediaParser;
import info.bliki.wiki.model.Configuration;
import info.bliki.wiki.model.IConfiguration;
import info.bliki.wiki.model.IContext;
import info.bliki.wiki.model.IEventListener;
import info.bliki.wiki.model.ITableOfContent;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.model.ImageFormat;
import info.bliki.wiki.model.Reference;
import info.bliki.wiki.model.SemanticAttribute;
import info.bliki.wiki.model.SemanticRelation;
import info.bliki.wiki.namespaces.INamespace;
import info.bliki.wiki.namespaces.Namespace;
import info.bliki.wiki.tags.TableOfContentTag;
import info.bliki.wiki.tags.WPATag;
import info.bliki.wiki.tags.WPTag;
import info.bliki.wiki.tags.code.SourceCodeFormatter;
import info.bliki.wiki.tags.util.TagStack;
import info.bliki.wiki.template.ITemplateFunction;
import info.bliki.wiki.template.extension.AttributeList;
import info.bliki.wiki.template.extension.AttributeRenderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWikiModel
implements IWikiModel,
IContext {
    private static int fNextNumberCounter = 0;
    protected ArrayList<Reference> fReferences;
    protected Map<String, Integer> fReferenceNames;
    protected int fRecursionLevel;
    protected int fParserRecursionCount;
    protected int fTemplateRecursionCount;
    protected TagStack fTagStack;
    private boolean fInitialized;
    private final Locale fLocale;
    private IConfiguration fConfiguration;
    private IEventListener fWikiListener = null;
    protected INamespace fNamespace;
    protected String fRedirectLink = null;
    protected String fPageTitle = "PAGENAME";
    protected int fSectionCounter;
    protected boolean fTemplateTopic = false;
    protected int fExternalLinksCounter;
    protected TableOfContentTag fTableOfContentTag = null;
    protected List<Object> fTableOfContent = null;
    protected HashSet<String> fToCSet;
    protected Map<String, Object> attributes;
    protected Map<Class, Object> attributeRenderers;

    public AbstractWikiModel() {
        this(Configuration.DEFAULT_CONFIGURATION);
    }

    public AbstractWikiModel(Configuration configuration) {
        this(configuration, Locale.ENGLISH);
    }

    public AbstractWikiModel(Configuration configuration, Locale locale) {
        this(configuration, locale, Messages.getResourceBundle(locale), new Namespace(locale));
    }

    @Deprecated
    public AbstractWikiModel(Configuration configuration, ResourceBundle resourceBundle, INamespace namespace) {
        this(configuration, Locale.ENGLISH, resourceBundle, namespace);
    }

    public AbstractWikiModel(Configuration configuration, Locale locale, ResourceBundle resourceBundle, INamespace namespace) {
        this.fLocale = locale;
        this.fInitialized = false;
        this.fConfiguration = configuration;
        this.fNamespace = namespace;
        this.initialize();
    }

    @Override
    public void addCategory(String categoryName, String sortKey) {
    }

    @Override
    public SourceCodeFormatter addCodeFormatter(String key, SourceCodeFormatter value) {
        return this.fConfiguration.addCodeFormatter(key, value);
    }

    @Override
    public String addInterwikiLink(String key, String value) {
        return this.fConfiguration.addInterwikiLink(key, value);
    }

    @Override
    public void addLink(String topicName) {
    }

    @Override
    public boolean addSemanticAttribute(String attribute, String attributeValue) {
        return false;
    }

    @Override
    public boolean addSemanticRelation(String relation, String relationValue) {
        return false;
    }

    @Override
    public void addTemplate(String template) {
    }

    @Override
    public ITemplateFunction addTemplateFunction(String key, ITemplateFunction value) {
        return this.fConfiguration.addTemplateFunction(key, value);
    }

    @Override
    public TagToken addTokenTag(String key, TagToken value) {
        return this.fConfiguration.addTokenTag(key, value);
    }

    @Override
    public String[] addToReferences(String reference, String nameAttribute) {
        Integer index;
        String[] result = new String[2];
        result[1] = null;
        if (this.fReferences == null) {
            this.fReferences = new ArrayList();
            this.fReferenceNames = new HashMap<String, Integer>();
        }
        if (nameAttribute != null && (index = this.fReferenceNames.get(nameAttribute)) != null) {
            result[0] = index.toString();
            Reference ref = this.fReferences.get(index - 1);
            int count = ref.incCounter();
            result[1] = count >= "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRTSUVWXYZ".length() ? nameAttribute + '_' + 'Z' : (count == 0 ? nameAttribute : nameAttribute + '_' + "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRTSUVWXYZ".charAt(count));
            return result;
        }
        if (nameAttribute != null) {
            this.fReferences.add(new Reference(reference, nameAttribute));
            index = this.fReferences.size();
            this.fReferenceNames.put(nameAttribute, index);
            result[1] = nameAttribute;
        } else {
            this.fReferences.add(new Reference(reference));
        }
        result[0] = Integer.toString(this.fReferences.size());
        return result;
    }

    protected void addToTableOfContent(List<Object> toc, SectionHeader strPair, int headLevel) {
        if (headLevel == 1) {
            toc.add(strPair);
        } else {
            if (toc.size() > 0 && toc.get(toc.size() - 1) instanceof List) {
                this.addToTableOfContent((List)toc.get(toc.size() - 1), strPair, --headLevel);
                return;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            toc.add(list);
            this.addToTableOfContent(list, strPair, --headLevel);
        }
    }

    @Override
    public void append(BaseToken contentNode) {
        this.fTagStack.append(contentNode);
    }

    @Override
    public void appendExternalImageLink(String imageSrc, String imageAltText) {
        TagNode spanTagNode = new TagNode("span");
        this.append(spanTagNode);
        spanTagNode.addAttribute("class", "image", true);
        TagNode imgTagNode = new TagNode("img");
        spanTagNode.addChild(imgTagNode);
        imgTagNode.addAttribute("src", imageSrc, true);
        imgTagNode.addAttribute("alt", imageAltText, true);
    }

    @Override
    @Deprecated
    public void appendExternalLink(String link, String linkName, boolean withoutSquareBrackets) {
        this.appendExternalLink("", link, linkName, withoutSquareBrackets);
    }

    @Override
    public void appendExternalLink(String uriSchemeName, String link, String linkName, boolean withoutSquareBrackets) {
        link = Utils.escapeXml(link, true, false, false);
        TagNode aTagNode = new TagNode("a");
        aTagNode.addAttribute("href", link, true);
        aTagNode.addAttribute("rel", "nofollow", true);
        if (withoutSquareBrackets) {
            aTagNode.addAttribute("class", "externallink", true);
            aTagNode.addAttribute("title", link, true);
            this.append(aTagNode);
            aTagNode.addChild(new ContentToken(linkName));
        } else {
            String trimmedText = linkName.trim();
            if (trimmedText.length() > 0) {
                this.pushNode(aTagNode);
                if (linkName.equals(link)) {
                    if (withoutSquareBrackets) {
                        aTagNode.addAttribute("class", "externallink", true);
                        aTagNode.addAttribute("title", link, true);
                        aTagNode.addChild(new ContentToken(trimmedText));
                    } else {
                        aTagNode.addAttribute("class", "external autonumber", true);
                        aTagNode.addChild(new ContentToken("[" + ++this.fExternalLinksCounter + "]"));
                    }
                } else {
                    aTagNode.addAttribute("class", "externallink", true);
                    aTagNode.addAttribute("title", link, true);
                    WikipediaParser.parseRecursive(trimmedText, this, false, true);
                }
                this.popNode();
            }
        }
    }

    @Override
    public ITableOfContent appendHead(String rawHead, int headLevel, boolean noToC, int headCounter) {
        return this.appendHead(rawHead, headLevel, noToC, headCounter, 0, 0);
    }

    @Override
    public ITableOfContent appendHead(String rawHead, int headLevel, boolean noToC, int headCounter, int startPosition, int endPosition) {
        TagStack localStack = WikipediaParser.parseRecursive(rawHead.trim(), this, true, true);
        WPTag headTagNode = new WPTag("h" + headLevel);
        TagNode spanTagNode = new TagNode("span");
        spanTagNode.addChildren(localStack.getNodeList());
        headTagNode.addChild(spanTagNode);
        String tocHead = headTagNode.getBodyString();
        String anchor = Encoder.encodeDotUrl(tocHead);
        this.createTableOfContent(false);
        if (!noToC && headCounter > 3) {
            this.fTableOfContentTag.setShowToC(true);
        }
        if (this.fToCSet.contains(anchor)) {
            String newAnchor = anchor;
            for (int i = 2; i < Integer.MAX_VALUE && this.fToCSet.contains(newAnchor = anchor + '_' + Integer.toString(i)); ++i) {
            }
            anchor = newAnchor;
        }
        this.fToCSet.add(anchor);
        SectionHeader strPair = new SectionHeader(headLevel, startPosition, endPosition, tocHead, anchor);
        this.addToTableOfContent(this.fTableOfContent, strPair, headLevel);
        if (this.getRecursionLevel() == 1) {
            this.buildEditLinkUrl(this.fSectionCounter++);
        }
        spanTagNode.addAttribute("class", "mw-headline", true);
        spanTagNode.addAttribute("id", anchor, true);
        this.append(headTagNode);
        return this.fTableOfContentTag;
    }

    @Override
    public void appendInternalImageLink(String hrefImageLink, String srcImageLink, ImageFormat imageFormat) {
        int pxWidth = imageFormat.getWidth();
        int pxHeight = imageFormat.getHeight();
        String caption = imageFormat.getCaption();
        String imageType = imageFormat.getType();
        TagNode divInnerTagNode = new TagNode("div");
        divInnerTagNode.addAttribute("id", "image", false);
        if (hrefImageLink.length() != 0) {
            divInnerTagNode.addAttribute("href", hrefImageLink, false);
        }
        divInnerTagNode.addAttribute("src", srcImageLink, false);
        this.setDefaultThumbWidth(imageFormat);
        divInnerTagNode.addObjectAttribute("wikiobject", imageFormat);
        this.pushNode(divInnerTagNode);
        if (caption != null && caption.length() > 0 && ("frame".equals(imageType) || "thumb".equals(imageType) || "thumbnail".equals(imageType))) {
            TagNode captionTagNode = new TagNode("div");
            String clazzValue = "caption";
            String type = imageFormat.getType();
            if (type != null) {
                clazzValue = type + clazzValue;
            }
            captionTagNode.addAttribute("class", clazzValue, false);
            TagStack localStack = WikipediaParser.parseRecursive(caption, this, true, true);
            captionTagNode.addChildren(localStack.getNodeList());
            String altAttribute = imageFormat.getAlt();
            if (altAttribute == null) {
                altAttribute = captionTagNode.getBodyString();
                imageFormat.setAlt(Encoder.encodeHtml(altAttribute));
            }
            this.pushNode(captionTagNode);
            this.popNode();
        }
        this.popNode();
    }

    protected void setDefaultThumbWidth(ImageFormat imageFormat) {
        int pxWidth = imageFormat.getWidth();
        String imageType = imageFormat.getType();
        if (pxWidth == -1 && (imageType == null || "thumb".equals(imageType))) {
            imageFormat.setWidth(220);
        }
    }

    @Override
    public void appendInternalLink(String topic, String hashSection, String topicDescription, String cssClass, boolean parseRecursive) {
        WPATag aTagNode = new WPATag();
        String href = this.encodeTitleToUrl(topic, true);
        if (hashSection != null) {
            href = href + '#' + this.encodeTitleDotUrl(hashSection, true);
        }
        aTagNode.addAttribute("href", href, true);
        if (cssClass != null) {
            aTagNode.addAttribute("class", cssClass, true);
        }
        aTagNode.addObjectAttribute("wikilink", topic);
        this.pushNode(aTagNode);
        if (parseRecursive) {
            WikipediaParser.parseRecursive(topicDescription.trim(), this, false, true);
        } else {
            aTagNode.addChild(new ContentToken(topicDescription));
        }
        this.popNode();
    }

    @Override
    public void appendInterWikiLink(String namespace, String title, String linkText) {
        String hrefLink = this.getInterwikiMap().get(namespace);
        if (hrefLink == null) {
            hrefLink = "#";
        }
        String encodedtopic = this.encodeTitleToUrl(title, false);
        if (this.replaceColon()) {
            encodedtopic = encodedtopic.replace(':', '/');
        }
        hrefLink = hrefLink.replace("${title}", encodedtopic);
        TagNode aTagNode = new TagNode("a");
        aTagNode.addAttribute("href", hrefLink, true);
        this.pushNode(aTagNode);
        WikipediaParser.parseRecursive(linkText.trim(), this, false, true);
        this.popNode();
    }

    @Override
    public void appendISBNLink(String isbnPureText) {
        StringBuffer isbnUrl = new StringBuffer(isbnPureText.length() + 100);
        isbnUrl.append("http://www.amazon.com/exec/obidos/ASIN/");
        for (int index = 0; index < isbnPureText.length(); ++index) {
            if (isbnPureText.charAt(index) < '0' || isbnPureText.charAt(index) > '9') continue;
            isbnUrl.append(isbnPureText.charAt(index));
        }
        String isbnString = isbnUrl.toString();
        TagNode aTagNode = new TagNode("a");
        this.append(aTagNode);
        aTagNode.addAttribute("href", isbnString, true);
        aTagNode.addAttribute("class", "external text", true);
        aTagNode.addAttribute("title", isbnString, true);
        aTagNode.addAttribute("rel", "nofollow", true);
        aTagNode.addChild(new ContentToken(isbnPureText));
    }

    @Override
    public void appendMailtoLink(String link, String linkName, boolean withoutSquareBrackets) {
        TagNode aTagNode = new TagNode("a");
        this.append(aTagNode);
        aTagNode.addAttribute("href", link, true);
        aTagNode.addAttribute("class", "external free", true);
        aTagNode.addAttribute("title", link, true);
        aTagNode.addAttribute("rel", "nofollow", true);
        aTagNode.addChild(new ContentToken(linkName));
    }

    @Override
    public boolean appendRawNamespaceLinks(String rawNamespaceTopic, String viewableLinkDescription, boolean containsNoPipe) {
        int colonIndex = rawNamespaceTopic.indexOf(58);
        if (colonIndex != -1) {
            String title;
            String nameSpace = rawNamespaceTopic.substring(0, colonIndex);
            if (this.isSemanticWebActive() && rawNamespaceTopic.length() > colonIndex + 1) {
                String attributeValue;
                if (rawNamespaceTopic.charAt(colonIndex + 1) == ':') {
                    String relationValue = rawNamespaceTopic.substring(colonIndex + 2);
                    if (this.addSemanticRelation(nameSpace, relationValue)) {
                        if (containsNoPipe) {
                            viewableLinkDescription = relationValue;
                        }
                        if (viewableLinkDescription.trim().length() > 0) {
                            this.appendInternalLink(relationValue, null, viewableLinkDescription, "interwiki", true);
                        }
                        return true;
                    }
                } else if (rawNamespaceTopic.charAt(colonIndex + 1) == '=' && this.addSemanticAttribute(nameSpace, attributeValue = rawNamespaceTopic.substring(colonIndex + 2))) {
                    this.append(new ContentToken(attributeValue));
                    return true;
                }
            }
            if (this.isCategoryNamespace(nameSpace)) {
                String category = rawNamespaceTopic.substring(colonIndex + 1).trim();
                if (category != null && category.length() > 0) {
                    this.addCategory(category, viewableLinkDescription);
                    return true;
                }
            } else if (this.isInterWiki(nameSpace) && (title = rawNamespaceTopic.substring(colonIndex + 1)) != null && title.length() > 0) {
                this.appendInterWikiLink(nameSpace, title, viewableLinkDescription);
                return true;
            }
        }
        return false;
    }

    @Override
    public void appendRawWikipediaLink(String rawLinkText, String suffix) {
        String rawTopicName = rawLinkText;
        if (rawTopicName != null) {
            String viewableLinkDescription;
            int trimRightIndex;
            int trimLeftIndex;
            for (trimLeftIndex = 0; trimLeftIndex < rawTopicName.length() && rawTopicName.charAt(trimLeftIndex) <= ' '; ++trimLeftIndex) {
            }
            if (trimLeftIndex > 0) {
                rawTopicName = rawTopicName.substring(trimLeftIndex);
            }
            int pipeIndex = rawTopicName.lastIndexOf(124);
            String alias = "";
            if (-1 != pipeIndex) {
                alias = rawTopicName.substring(pipeIndex + 1);
                rawTopicName = rawTopicName.substring(0, pipeIndex);
                if (alias.length() == 0) {
                    alias = rawTopicName;
                    int index = alias.indexOf(58);
                    if (index != -1) {
                        alias = alias.substring(index + 1).trim();
                    } else {
                        index = alias.indexOf(40);
                        if (index != -1) {
                            alias = alias.substring(0, index).trim();
                        } else {
                            index = alias.indexOf(44);
                            if (index != -1) {
                                alias = alias.substring(0, index).trim();
                            }
                        }
                    }
                }
            }
            int hashIndex = rawTopicName.lastIndexOf(35);
            String hash = "";
            if (-1 != hashIndex && hashIndex != rawTopicName.length() - 1) {
                hash = rawTopicName.substring(hashIndex + 1);
                rawTopicName = rawTopicName.substring(0, hashIndex);
            }
            for (trimRightIndex = rawTopicName.length() - 1; trimRightIndex >= 0 && rawTopicName.charAt(trimRightIndex) <= ' '; --trimRightIndex) {
            }
            if (trimRightIndex != rawTopicName.length() - 1) {
                rawTopicName = rawTopicName.substring(0, trimRightIndex + 1);
            }
            if (this.appendRawNamespaceLinks(rawTopicName, viewableLinkDescription = -1 != pipeIndex ? alias + suffix : (rawTopicName.length() > 0 && rawTopicName.charAt(0) == ':' ? rawTopicName.substring(1) + suffix : rawTopicName + suffix), pipeIndex == -1)) {
                return;
            }
            int indx = rawTopicName.indexOf(58);
            String namespace = null;
            if (indx >= 0) {
                namespace = rawTopicName.substring(0, indx);
            }
            if (namespace != null && this.isImageNamespace(namespace)) {
                this.parseInternalImageLink(namespace, rawLinkText);
                return;
            }
            if (rawTopicName.length() > 0 && rawTopicName.charAt(0) == ':') {
                rawTopicName = rawTopicName.substring(1);
            }
            if (rawTopicName.length() > 0 && rawTopicName.charAt(0) == ':') {
                rawTopicName = rawTopicName.substring(1);
            }
            this.addLink(rawTopicName);
            if (-1 != hashIndex) {
                this.appendInternalLink(rawTopicName, hash, viewableLinkDescription, null, true);
            } else {
                this.appendInternalLink(rawTopicName, null, viewableLinkDescription, null, true);
            }
        }
    }

    @Override
    public boolean appendRedirectLink(String redirectLink) {
        this.fRedirectLink = redirectLink;
        return true;
    }

    @Override
    public void appendSignature(Appendable writer, int numberOfTildes) throws IOException {
        switch (numberOfTildes) {
            case 3: {
                writer.append("~~~");
                break;
            }
            case 4: {
                writer.append("~~~~");
                break;
            }
            case 5: {
                writer.append("~~~~~");
            }
        }
    }

    @Override
    public void appendStack(TagStack stack) {
        if (stack != null) {
            this.fTagStack.append(stack);
        }
    }

    public TagNode appendToCAnchor(String anchor) {
        TagNode aTagNode = new TagNode("a");
        aTagNode.addAttribute("name", anchor, true);
        aTagNode.addAttribute("id", anchor, true);
        return aTagNode;
    }

    @Override
    public void buildEditLinkUrl(int section) {
    }

    @Override
    public AbstractParser createNewInstance(String rawWikitext) {
        return new WikipediaParser(rawWikitext, this.isTemplateTopic(), this.getWikiListener());
    }

    @Override
    public ITableOfContent createTableOfContent(boolean isTOCIdentifier) {
        if (this.fTableOfContentTag == null) {
            TableOfContentTag tableOfContentTag = new TableOfContentTag("div");
            tableOfContentTag.addAttribute("id", "tableofcontent", true);
            tableOfContentTag.setShowToC(false);
            tableOfContentTag.setTOCIdentifier(isTOCIdentifier);
            this.fTableOfContentTag = tableOfContentTag;
            this.append(this.fTableOfContentTag);
        } else if (isTOCIdentifier) {
            TableOfContentTag tableOfContentTag = (TableOfContentTag)this.fTableOfContentTag.clone();
            this.fTableOfContentTag.setShowToC(false);
            tableOfContentTag.setShowToC(true);
            tableOfContentTag.setTOCIdentifier(isTOCIdentifier);
            this.fTableOfContentTag = tableOfContentTag;
            this.fTableOfContent = null;
            this.append(this.fTableOfContentTag);
        }
        if (this.fTableOfContentTag != null && this.fTableOfContent == null) {
            this.fTableOfContent = this.fTableOfContentTag.getTableOfContent();
        }
        if (this.fToCSet == null) {
            this.fToCSet = new HashSet();
        }
        return this.fTableOfContentTag;
    }

    @Override
    public int decrementRecursionLevel() {
        return --this.fRecursionLevel;
    }

    @Override
    public String encodeTitleDotUrl(String wikiTitle, boolean firstCharacterAsUpperCase) {
        return Encoder.encodeTitleDotUrl(wikiTitle, firstCharacterAsUpperCase);
    }

    @Override
    public String encodeTitleToUrl(String wikiTitle, boolean firstCharacterAsUpperCase) {
        return Encoder.encodeTitleToUrl(wikiTitle, firstCharacterAsUpperCase);
    }

    @Override
    public String get2ndCategoryNamespace() {
        return this.fNamespace.getCategory2();
    }

    @Override
    public String get2ndImageNamespace() {
        return this.fNamespace.getImage2();
    }

    @Override
    public String get2ndTemplateNamespace() {
        return this.fNamespace.getTemplate2();
    }

    @Override
    public Object getAttribute(String attribute) {
        Object o = null;
        if (this.attributes != null) {
            o = this.attributes.get(attribute);
        }
        return o;
    }

    @Override
    public AttributeRenderer getAttributeRenderer(Class attributeClassType) {
        AttributeRenderer renderer = null;
        if (this.attributeRenderers != null) {
            renderer = (AttributeRenderer)this.attributeRenderers.get(attributeClassType);
        }
        if (renderer != null) {
            return renderer;
        }
        return null;
    }

    @Override
    public String getCategoryNamespace() {
        return this.fNamespace.getCategory();
    }

    @Override
    public Map<String, SourceCodeFormatter> getCodeFormatterMap() {
        return this.fConfiguration.getCodeFormatterMap();
    }

    @Override
    public Date getCurrentTimeStamp() {
        return new Date(System.currentTimeMillis());
    }

    @Override
    public String getImageNamespace() {
        return this.fNamespace.getImage();
    }

    @Override
    public Map<String, String> getInterwikiMap() {
        return this.fConfiguration.getInterwikiMap();
    }

    @Override
    public Locale getLocale() {
        return this.fLocale;
    }

    @Override
    public synchronized int getNextNumber() {
        return fNextNumberCounter++;
    }

    @Override
    public TagToken getNode(int offset) {
        return (TagToken)this.fTagStack.get(offset);
    }

    @Override
    public String getPageName() {
        return this.fPageTitle;
    }

    @Override
    public String getRawWikiContent(String namespace, String templateName, Map<String, String> templateParameters) {
        if (this.isTemplateNamespace(namespace)) {
            String magicWord = templateName;
            String parameter = "";
            int index = magicWord.indexOf(58);
            if (index > 0) {
                parameter = magicWord.substring(index + 1).trim();
                magicWord = magicWord.substring(0, index);
            }
            if (MagicWord.isMagicWord(magicWord)) {
                return MagicWord.processMagicWord(magicWord, parameter, this);
            }
        }
        return null;
    }

    @Override
    public int getRecursionLevel() {
        return this.fRecursionLevel;
    }

    @Override
    public String getRedirectLink() {
        return this.fRedirectLink;
    }

    @Override
    public List<Reference> getReferences() {
        return this.fReferences;
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.fNamespace.getResourceBundle();
    }

    @Override
    public List<SemanticAttribute> getSemanticAttributes() {
        return null;
    }

    @Override
    public List<SemanticRelation> getSemanticRelations() {
        return null;
    }

    @Override
    public ITableOfContent getTableOfContent() {
        return this.fTableOfContentTag;
    }

    @Override
    public Map<String, String> getTemplateCallsCache() {
        return this.fConfiguration.getTemplateCallsCache();
    }

    @Override
    public ITemplateFunction getTemplateFunction(String name) {
        return this.getTemplateMap().get(name);
    }

    @Override
    public Map<String, ITemplateFunction> getTemplateMap() {
        return this.fConfiguration.getTemplateMap();
    }

    @Override
    public String getTemplateNamespace() {
        return this.fNamespace.getTemplate();
    }

    @Override
    public Map<String, TagToken> getTokenMap() {
        return this.fConfiguration.getTokenMap();
    }

    @Override
    public Set<String> getUriSchemeSet() {
        return this.fConfiguration.getUriSchemeSet();
    }

    @Override
    public IEventListener getWikiListener() {
        return this.fWikiListener;
    }

    @Override
    public int incrementParserRecursionCount() {
        return ++this.fParserRecursionCount;
    }

    @Override
    public int incrementRecursionLevel() {
        return ++this.fRecursionLevel;
    }

    @Override
    public int incrementTemplateRecursionCount() {
        return ++this.fTemplateRecursionCount;
    }

    protected void initialize() {
        if (!this.fInitialized) {
            this.fWikiListener = null;
            this.fToCSet = null;
            this.fTableOfContent = null;
            this.fTableOfContentTag = null;
            this.fTagStack = new TagStack();
            this.fReferences = null;
            this.fReferenceNames = null;
            this.fParserRecursionCount = 0;
            this.fRecursionLevel = 0;
            this.fTemplateRecursionCount = 0;
            this.fSectionCounter = 0;
            this.fExternalLinksCounter = 0;
            this.fInitialized = true;
        }
    }

    @Override
    public boolean isCamelCaseEnabled() {
        return false;
    }

    @Override
    public boolean isCategoryNamespace(String namespace) {
        return namespace.equalsIgnoreCase(this.fNamespace.getCategory()) || namespace.equalsIgnoreCase(this.fNamespace.getCategory2());
    }

    @Override
    public boolean isEditorMode() {
        return false;
    }

    @Override
    public boolean isImageNamespace(String namespace) {
        return namespace.equalsIgnoreCase(this.fNamespace.getImage()) || namespace.equalsIgnoreCase(this.fNamespace.getImage2());
    }

    @Override
    public boolean isInterWiki(String namespace) {
        return this.getInterwikiMap().containsKey(namespace);
    }

    @Override
    public boolean isMathtranRenderer() {
        return false;
    }

    @Override
    public boolean isNamespace(String namespace) {
        return this.isImageNamespace(namespace) || this.isTemplateNamespace(namespace) || this.isCategoryNamespace(namespace);
    }

    @Override
    public boolean isPreviewMode() {
        return false;
    }

    @Override
    public boolean isSemanticWebActive() {
        return false;
    }

    @Override
    public boolean isTemplateNamespace(String namespace) {
        return namespace.equalsIgnoreCase(this.fNamespace.getTemplate()) || namespace.equalsIgnoreCase(this.fNamespace.getTemplate2());
    }

    @Override
    public boolean isTemplateTopic() {
        return this.fTemplateTopic;
    }

    @Override
    public boolean isValidUriScheme(String uriScheme) {
        return this.getUriSchemeSet().contains(uriScheme);
    }

    @Override
    public boolean isValidUriSchemeSpecificPart(String uriScheme, String uriSchemeSpecificPart) {
        if (uriScheme.equals("ftp") || uriScheme.equals("http") || uriScheme.equals("https")) {
            return uriSchemeSpecificPart.length() >= 2 && uriSchemeSpecificPart.substring(0, 2).equals("//");
        }
        return true;
    }

    @Override
    public boolean parseBBCodes() {
        return false;
    }

    @Override
    public boolean parseBehaviorSwitch(String identifier) {
        for (int i = 0; i < WikipediaParser.TOC_IDENTIFIERS.length; ++i) {
            if (!WikipediaParser.TOC_IDENTIFIERS[i].equals(identifier)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void parseEvents(IEventListener listener, String rawWikiText) {
        this.initialize();
        if (rawWikiText == null) {
            return;
        }
        this.fWikiListener = listener;
        WikipediaParser.parse(rawWikiText, this, false, null);
        this.fInitialized = false;
    }

    @Override
    public String parseTemplates(String rawWikiText) {
        return this.parseTemplates(rawWikiText, false);
    }

    @Override
    public String parseTemplates(String rawWikiText, boolean parseOnlySignature) {
        if (rawWikiText == null) {
            return "";
        }
        if (!parseOnlySignature) {
            this.initialize();
        }
        StringBuilder buf = new StringBuilder(rawWikiText.length() + rawWikiText.length() / 10);
        try {
            TemplateParser.parse(rawWikiText, this, buf, parseOnlySignature, true);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            buf.append("<span class=\"error\">TemplateParser exception: " + ioe.getClass().getSimpleName() + "</span>");
        }
        return buf.toString();
    }

    @Override
    public TagToken peekNode() {
        return this.fTagStack.peek();
    }

    @Override
    public TagToken popNode() {
        return this.fTagStack.pop();
    }

    @Override
    public boolean pushNode(TagToken node) {
        return this.fTagStack.push(node);
    }

    protected void rawSetAttribute(Map attributes, String name, Object value) {
        if (value == null) {
            return;
        }
        attributes.put(name, value);
    }

    @Override
    public void registerRenderer(Class attributeClassType, AttributeRenderer renderer) {
        if (this.attributeRenderers == null) {
            this.attributeRenderers = new HashMap<Class, Object>();
        }
        this.attributeRenderers.put(attributeClassType, renderer);
    }

    @Override
    public String render(ITextConverter converter, String rawWikiText) {
        return this.render(converter, rawWikiText, false);
    }

    @Override
    public String render(ITextConverter converter, String rawWikiText, boolean templateTopic) {
        this.initialize();
        if (rawWikiText == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(rawWikiText.length() + rawWikiText.length() / 10);
        try {
            this.render(converter, rawWikiText, buf, templateTopic, true);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(ITextConverter converter, String rawWikiText, Appendable buf, boolean templateTopic, boolean parseTemplates) throws IOException {
        this.initialize();
        if (rawWikiText == null) {
            return;
        }
        this.fTemplateTopic = templateTopic;
        WikipediaParser.parse(rawWikiText, this, parseTemplates, null);
        if (converter != null) {
            List<BaseToken> list = this.fTagStack.getNodeList();
            try {
                converter.nodesToText(list, buf, this);
            }
            finally {
                this.fInitialized = false;
            }
            return;
        }
        this.fInitialized = false;
    }

    @Override
    public String render(String rawWikiText) {
        return this.render(rawWikiText, false);
    }

    @Override
    public String render(String rawWikiText, boolean templateTopic) {
        return this.render(new HTMLConverter(), rawWikiText, templateTopic);
    }

    @Override
    public String renderPDF(String rawWikiText) {
        return this.render(new PDFConverter(), rawWikiText, false);
    }

    @Override
    public boolean replaceColon() {
        return true;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (value == null || name == null) {
            return;
        }
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("cannot have '.' in attribute names");
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        AttributeList v = null;
        Object o = this.attributes.get(name);
        if (o == null) {
            if (value instanceof List) {
                v = new AttributeList(((List)value).size());
                v.addAll((List)value);
                this.rawSetAttribute(this.attributes, name, v);
                return;
            }
            this.rawSetAttribute(this.attributes, name, value);
            return;
        }
        if (o.getClass() == AttributeList.class) {
            v = (AttributeList)o;
        } else if (o instanceof List) {
            List listAttr = (List)o;
            v = new AttributeList(listAttr.size());
            v.addAll(listAttr);
            this.rawSetAttribute(this.attributes, name, v);
        } else {
            v = new AttributeList();
            this.rawSetAttribute(this.attributes, name, v);
            v.add(o);
        }
        if (value instanceof List) {
            if (v != value) {
                v.addAll((List)value);
            }
        } else {
            v.add(value);
        }
    }

    public void setAttributeRenderers(Map renderers) {
        this.attributeRenderers = renderers;
    }

    @Override
    public void setPageName(String pageTitle) {
        this.fPageTitle = pageTitle;
    }

    @Override
    public void setSemanticWebActive(boolean semanticWeb) {
    }

    @Override
    public void setTemplateCallsCache(Map<String, String> map) {
        this.fConfiguration.setTemplateCallsCache(map);
    }

    @Override
    public void setUp() {
        this.fToCSet = null;
        this.fTableOfContent = null;
        this.fTableOfContentTag = null;
        this.fTagStack = new TagStack();
        this.fReferences = null;
        this.fReferenceNames = null;
        this.fParserRecursionCount = 0;
        this.fRecursionLevel = 0;
        this.fTemplateRecursionCount = 0;
        this.fRedirectLink = null;
        this.fSectionCounter = 0;
        this.fExternalLinksCounter = 0;
    }

    @Override
    public boolean showSyntax(String tagName) {
        return true;
    }

    @Override
    public int stackSize() {
        return this.fTagStack.size();
    }

    @Override
    public void substituteTemplateCall(String templateName, Map<String, String> parameterMap, Appendable writer) throws IOException {
        String plainContent;
        AbstractWikiModel config;
        Map<String, String> templateCallsCache = null;
        String cacheKey = null;
        if (this instanceof IConfiguration && (templateCallsCache = (config = this).getTemplateCallsCache()) != null) {
            String value;
            StringBuilder cacheKeyBuffer = new StringBuilder();
            cacheKeyBuffer.append(templateName);
            cacheKeyBuffer.append("|");
            for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
                cacheKeyBuffer.append(entry.getKey());
                cacheKeyBuffer.append("=");
                cacheKeyBuffer.append(entry.getValue());
                cacheKeyBuffer.append("|");
            }
            cacheKey = cacheKeyBuffer.toString();
            if (cacheKey.length() < 256 && (value = templateCallsCache.get(cacheKey)) != null) {
                writer.append(value);
                return;
            }
        }
        if (templateName.length() > 0 && templateName.charAt(0) == ':') {
            templateCallsCache = null;
            plainContent = this.getRawWikiContent("", templateName.substring(1), parameterMap);
        } else {
            this.addTemplate(templateName);
            plainContent = this.getRawWikiContent(this.getTemplateNamespace(), templateName, parameterMap);
        }
        if (plainContent != null) {
            StringBuilder templateBuffer = new StringBuilder(plainContent.length());
            TemplateParser.parseRecursive(plainContent.trim(), this, templateBuffer, false, false, parameterMap);
            if (templateCallsCache != null && cacheKey != null && cacheKey.length() < 256) {
                String cacheValue = templateBuffer.toString();
                templateCallsCache.put(cacheKey, cacheValue);
                writer.append(cacheValue);
            } else {
                writer.append(templateBuffer);
            }
            return;
        }
        writer.append("{{");
        writer.append(templateName);
        writer.append("}}");
    }

    @Override
    public TagStack swapStack(TagStack stack) {
        TagStack temp = this.fTagStack;
        this.fTagStack = stack;
        return temp;
    }

    @Override
    public void tearDown() {
    }

    @Deprecated
    public List<BaseToken> toNodeList(String rawWikiText) {
        this.initialize();
        if (rawWikiText == null) {
            return new ArrayList<BaseToken>();
        }
        WikipediaParser.parse(rawWikiText, this, true, null);
        this.fInitialized = false;
        return this.fTagStack.getNodeList();
    }
}

