/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.web.flickr;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.web.flickr.FlickrBaseEncoder;

public class FlickrImage {
    public static final String sizeSuffixes = "sqtnm-zcbo";
    private long id;
    private URI url;
    private int farm;
    private int server;
    private String secret;
    private char size;
    private boolean isOriginal;
    private String extension;
    private File localFile;

    public FlickrImage(long id, int farm, int server, String secret, char size, String extension) {
        this.id = id;
        this.farm = farm;
        this.server = server;
        this.secret = secret;
        this.size = size;
        this.extension = extension;
        this.url = this.createURI();
        if (!sizeSuffixes.contains("" + size)) {
            throw new IllegalArgumentException("Size suffixes must be one of sqtnm-zcbo");
        }
    }

    public static FlickrImage create(URL url) {
        int farm = 0;
        long id = 0L;
        int server = 0;
        String secret = null;
        char size = 'o';
        String extension = "jpg";
        Pattern p1 = Pattern.compile("http://farm([0-9]+).static.flickr.com/([0-9]+)/([0-9]+)_([0-9a-f]+).jpg");
        Pattern p2 = Pattern.compile("http://farm([0-9]+).static.flickr.com/([0-9]+)/([0-9]+)_([0-9a-f]+)_([mstzb]).jpg");
        Pattern p3 = Pattern.compile("http://farm([0-9]+).static.flickr.com/([0-9]+)/([0-9]+)_([0-9a-f]+)_o.(jpg|png|gif)");
        Pattern p4 = Pattern.compile("http://flic.kr/p/([0-9A-Za-z]+)");
        FlickrImage f = null;
        Matcher m = null;
        m = p1.matcher(url.toString());
        if (m.find()) {
            farm = Integer.parseInt(m.group(1));
            server = Integer.parseInt(m.group(2));
            id = Long.parseLong(m.group(3));
            secret = m.group(4);
            f = new FlickrImage(id, farm, server, secret, size, extension);
        } else {
            m = p2.matcher(url.toString());
            if (m.find()) {
                farm = Integer.parseInt(m.group(1));
                server = Integer.parseInt(m.group(2));
                id = Long.parseLong(m.group(3));
                secret = m.group(4);
                size = m.group(5).charAt(0);
                f = new FlickrImage(id, farm, server, secret, size, extension);
            } else {
                m = p3.matcher(url.toString());
                if (m.find()) {
                    farm = Integer.parseInt(m.group(1));
                    server = Integer.parseInt(m.group(2));
                    id = Long.parseLong(m.group(3));
                    secret = m.group(4);
                    size = 'o';
                    extension = m.group(5);
                    f = new FlickrImage(id, farm, server, secret, size, extension);
                    f.setOriginal(true);
                } else if (p4.matcher(url.toString()).find()) {
                    id = FlickrBaseEncoder.decode(url.toString());
                    f = new FlickrImage(id, 0, 0, null, 'z', null);
                } else {
                    System.err.println("WARNING: No pattern matched the Flickr URL " + url.toString());
                }
            }
        }
        return f;
    }

    private URI createURI() {
        URI url = null;
        url = this.size == 'o' ? URI.create("http://farm" + this.farm + ".staticflickr.com/" + this.server + "/" + this.id + "_" + this.secret + "_" + this.size + "." + this.extension) : URI.create("http://farm" + this.farm + ".staticflickr.com/" + this.server + "/" + this.id + "_" + this.secret + "_" + this.size + ".jpg");
        return url;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public int getFarm() {
        return this.farm;
    }

    public void setFarm(int farm) {
        this.farm = farm;
    }

    public int getServer() {
        return this.server;
    }

    public void setServer(int server) {
        this.server = server;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public char getSize() {
        return this.size;
    }

    public void setSize(char size) {
        this.size = size;
    }

    public boolean isOriginal() {
        return this.isOriginal;
    }

    public void setOriginal(boolean isOriginal) {
        this.isOriginal = isOriginal;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(File localFile) {
        this.localFile = localFile;
    }

    public MBFImage getImage() throws IOException {
        if (this.localFile != null) {
            return ImageUtilities.readMBF((File)this.localFile);
        }
        return ImageUtilities.readMBF((URL)this.url.toURL());
    }
}

