/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.filters;

import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.FixedSizeSampleAudioProcessor;
import org.openimaj.audio.samples.SampleBuffer;

public abstract class WeightedWindowedAudioProcessor
extends FixedSizeSampleAudioProcessor {
    protected double[] weightTable = null;
    protected boolean useWeights = true;

    public WeightedWindowedAudioProcessor(int sizeRequired) {
        super(sizeRequired);
    }

    public WeightedWindowedAudioProcessor(AudioStream stream, int sizeRequired) {
        super(stream, sizeRequired);
    }

    public WeightedWindowedAudioProcessor(int nSamplesInWindow, int nSamplesOverlap) {
        super(nSamplesInWindow, nSamplesOverlap);
    }

    public WeightedWindowedAudioProcessor(AudioStream as, int nSamplesInWindow, int nSamplesOverlap) {
        super(as, nSamplesInWindow, nSamplesOverlap);
    }

    private void generateWeightTableCache(SampleChunk sample) {
        this.generateWeightTableCache(sample.getNumberOfSamples() / sample.getFormat().getNumChannels(), sample.getFormat().getNumChannels());
    }

    protected abstract void generateWeightTableCache(int var1, int var2);

    public final SampleChunk process(SampleChunk sample) {
        if (sample == null) {
            return null;
        }
        if (this.weightTable == null) {
            this.generateWeightTableCache(sample);
        }
        this.process(sample.getSampleBuffer());
        return this.processSamples(sample);
    }

    public final SampleBuffer process(SampleBuffer b) {
        int nc = b.getFormat().getNumChannels();
        if (this.weightTable == null) {
            this.generateWeightTableCache(b.size() / nc, nc);
        }
        for (int c = 0; c < nc; ++c) {
            for (int n = 0; n < b.size() / nc; ++n) {
                float x = b.get(n * nc + c);
                float v = (float)((double)x * this.weightTable[n * nc + c]);
                if (!this.useWeights) {
                    v = x;
                }
                b.set(n * nc + c, v);
            }
        }
        return b;
    }

    public SampleChunk processSamples(SampleChunk sample) {
        return sample;
    }

    public double getWindowSum(SampleChunk samples) {
        return this.getWindowSum(samples.getNumberOfSamples() / samples.getFormat().getNumChannels(), samples.getFormat().getNumChannels());
    }

    public double getWindowSum(int length, int numChannels) {
        if (this.weightTable == null) {
            this.generateWeightTableCache(length, numChannels);
        }
        double sum = 0.0;
        for (int i = 0; i < this.weightTable.length; i += numChannels) {
            sum += this.weightTable[i];
        }
        return sum;
    }

    public double[] getWeights() {
        return this.weightTable;
    }
}

