/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.filters;

import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.filters.MusicalNoteFilterBank;
import org.openimaj.audio.processor.AudioProcessor;

public class MusicalNoteOnsetDetector
extends AudioProcessor {
    private final MusicalNoteFilterBank filterBank = new MusicalNoteFilterBank(60, 72, null);
    private double previousPower = 0.0;
    private boolean onsetDetected = false;
    private final double threshold = 100.0;

    public SampleChunk process(SampleChunk sample) throws Exception {
        this.filterBank.process(sample);
        double p = this.filterBank.getOutputPower();
        double delta = Math.abs(this.previousPower - p);
        if (delta > this.threshold) {
            this.onsetDetected = true;
        }
        this.previousPower = p;
        return sample;
    }

    public boolean hasOnsetBeenDetected() {
        return this.onsetDetected;
    }
}

