/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.conversion;

import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.AudioProcessor;
import org.openimaj.audio.samples.SampleBuffer;
import org.openimaj.audio.samples.SampleBufferFactory;
import org.openimaj.math.util.Interpolation;

public class SampleRateConverter
extends AudioProcessor {
    private SampleRateConversionAlgorithm sampleConverter = SampleRateConversionAlgorithm.LINEAR_INTERPOLATION;
    private AudioFormat outputFormat = null;

    public SampleRateConverter(SampleRateConversionAlgorithm converter, AudioFormat outputFormat) {
        this.sampleConverter = converter;
        this.outputFormat = outputFormat;
        this.setFormat(outputFormat);
    }

    public SampleRateConverter(AudioStream as, SampleRateConversionAlgorithm converter, AudioFormat outputFormat) {
        super(as);
        this.sampleConverter = converter;
        this.outputFormat = outputFormat;
        this.setFormat(outputFormat);
    }

    public SampleChunk process(SampleChunk sample) throws Exception {
        if (sample.getFormat().getNBits() != this.outputFormat.getNBits()) {
            throw new IllegalArgumentException("The number of bits in the output format is not the same as the sample chunk. Use a resampling conversion first before using the sample-rate converter.");
        }
        if (sample.getFormat().getNumChannels() != this.outputFormat.getNumChannels()) {
            throw new IllegalArgumentException("The number of channels in the output format is not the same as the sample chunk. Use a channel converter first before using the sample-rate converter.");
        }
        if (sample.getFormat().getSampleRateKHz() == this.outputFormat.getSampleRateKHz()) {
            return sample;
        }
        SampleChunk sc = this.sampleConverter.process(sample, this.outputFormat);
        sc.setStartTimecode(sample.getStartTimecode());
        return sc;
    }

    public static enum SampleRateConversionAlgorithm {
        LINEAR_INTERPOLATION{

            @Override
            public SampleChunk process(SampleChunk s, AudioFormat output) {
                AudioFormat input = s.getFormat();
                if (input.getSampleRateKHz() == output.getSampleRateKHz()) {
                    return s;
                }
                double scalar = input.getSampleRateKHz() / output.getSampleRateKHz();
                SampleBuffer sbin = s.getSampleBuffer();
                double size = (double)sbin.size() / scalar;
                if (this.sbout == null || this.sbout.size() != (int)size) {
                    this.sbout = SampleBufferFactory.createSampleBuffer((AudioFormat)output, (int)((int)size));
                    this.sbout.setFormat(output);
                }
                if (scalar > 1.0) {
                    for (int i = 0; i < this.sbout.size(); ++i) {
                        this.sbout.set(i, sbin.get((int)((double)i * scalar)));
                    }
                    return this.sbout.getSampleChunk();
                }
                for (int i = 0; i < this.sbout.size() - 1; ++i) {
                    int inputSampleX = (int)((double)i * scalar);
                    this.sbout.set(i, Interpolation.lerp((float)((float)((double)i * scalar)), (float)inputSampleX, (float)sbin.get(inputSampleX), (float)(inputSampleX + 1), (float)sbin.get(inputSampleX + 1)));
                }
                this.sbout.set(this.sbout.size() - 1, sbin.get(sbin.size() - 1));
                return this.sbout.getSampleChunk();
            }
        };

        protected SampleBuffer sbout = null;

        public abstract SampleChunk process(SampleChunk var1, AudioFormat var2);
    }
}

