/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.conversion;

import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.conversion.BitDepthConverter;
import org.openimaj.audio.conversion.MultichannelToMonoProcessor;
import org.openimaj.audio.conversion.SampleRateConverter;
import org.openimaj.audio.processor.AudioProcessor;

public class AudioConverter
extends AudioProcessor {
    private AudioFormat inputFormat = null;
    private AudioProcessor processor = null;

    public AudioConverter(AudioStream stream, AudioFormat output) {
        super(stream);
        this.inputFormat = stream.getFormat().clone();
        this.setFormat(output.clone());
        this.processor = AudioConverter.calculateProcess(this.inputFormat, output);
    }

    public AudioConverter(AudioFormat input, AudioFormat output) {
        this.inputFormat = input.clone();
        this.setFormat(output.clone());
        this.processor = AudioConverter.calculateProcess(input, output);
    }

    public static AudioProcessor calculateProcess(AudioFormat input, AudioFormat output) {
        if (input.equals((Object)output)) {
            return null;
        }
        AudioProcessor ap = null;
        if (input.isBigEndian() != output.isBigEndian()) {
            throw new IllegalArgumentException("Cannot convert " + input + " to " + output + ". There is no endian conversion implemented yet.");
        }
        if (input.isSigned() != output.isSigned()) {
            throw new IllegalArgumentException("Cannot convert " + input + " to " + output + ". There is no sign conversion implemented yet.");
        }
        if (input.getSampleRateKHz() != output.getSampleRateKHz()) {
            ap = AudioConverter.getProcessor(ap, new SampleRateConverter(SampleRateConverter.SampleRateConversionAlgorithm.LINEAR_INTERPOLATION, AudioConverter.getFormatSR(ap, output)));
        }
        if (input.getNBits() != output.getNBits()) {
            ap = AudioConverter.getProcessor(ap, new BitDepthConverter(BitDepthConverter.BitDepthConversionAlgorithm.NEAREST, AudioConverter.getFormatBits(ap, output)));
        }
        if (input.getNumChannels() != output.getNumChannels()) {
            if (output.getNumChannels() == 1) {
                ap = AudioConverter.getProcessor(ap, new MultichannelToMonoProcessor());
            } else {
                throw new IllegalArgumentException("Cannot convert " + input + " to " + output + ". Unable to find an appropriate channel converter.");
            }
        }
        return ap;
    }

    private static AudioFormat getFormatBits(AudioProcessor ap, AudioFormat output) {
        if (ap == null) {
            return output;
        }
        AudioFormat f = ap.getFormat().clone();
        f.setNBits(output.getNBits());
        return f;
    }

    private static AudioFormat getFormatSR(AudioProcessor ap, AudioFormat output) {
        if (ap == null) {
            return output;
        }
        AudioFormat f = ap.getFormat().clone();
        f.setSampleRateKHz(output.getSampleRateKHz());
        return f;
    }

    private static AudioProcessor getProcessor(AudioProcessor ap, AudioProcessor ap2) {
        if (ap == null) {
            return ap2;
        }
        ap2.setUnderlyingStream((AudioStream)ap);
        return ap2;
    }

    public SampleChunk process(SampleChunk sample) throws Exception {
        return this.processor.process(sample);
    }

    public AudioFormat getOutputFormat() {
        return this.getFormat();
    }
}

