/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.analysis.FourierTransform;
import org.openimaj.audio.processor.AudioProcessor;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.pair.Pair;

public class FrequencyAudioSource
extends AudioProcessor
implements Runnable {
    private final FourierTransform fftProc = new FourierTransform();
    private final List<IndependentPair<Listener, Pair<Integer>>> listeners = new ArrayList<IndependentPair<Listener, Pair<Integer>>>();
    private float[] fftReal;
    private float[] fftImag;

    public FrequencyAudioSource(AudioStream stream) {
        super(stream);
        new Thread(this).start();
    }

    public SampleChunk process(SampleChunk sample) throws Exception {
        this.fftProc.process(sample);
        float[] fft = this.fftProc.getLastFFT()[0];
        this.fireFrequencyEvent(fft, sample);
        return sample;
    }

    private void fireFrequencyEvent(float[] fft, SampleChunk sample) {
        double binSize = sample.getFormat().getSampleRateKHz() * 1000.0 / (double)(fft.length / 2);
        if (this.fftReal == null || fft.length / 4 != this.fftReal.length) {
            this.fftReal = new float[fft.length / 4];
            this.fftImag = new float[fft.length / 4];
        }
        for (int i = 0; i < fft.length / 4; ++i) {
            float re = fft[i * 2];
            float im = fft[i * 2 + 1];
            this.fftReal[i] = re;
            this.fftImag[i] = im;
        }
        for (IndependentPair<Listener, Pair<Integer>> l : this.listeners) {
            Pair range = (Pair)l.secondObject();
            int low = (int)((double)((Integer)range.firstObject()).intValue() / binSize);
            int high = (int)((double)((Integer)range.secondObject()).intValue() / binSize);
            ((Listener)l.firstObject()).consumeFrequency(this.fftReal, this.fftImag, low, high);
        }
    }

    @Override
    public void run() {
        try {
            Thread.sleep(500L);
            SampleChunk s = null;
            while ((s = this.nextSampleChunk()) != null) {
                this.process(s);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addFrequencyListener(Listener l) {
        Object range = null;
        this.listeners.add((IndependentPair<Listener, Pair<Integer>>)IndependentPair.pair((Object)l, range));
    }

    public void addFrequencyListener(Listener l, Pair<Integer> requestFrequencyRange) {
        this.listeners.add((IndependentPair<Listener, Pair<Integer>>)IndependentPair.pair((Object)l, requestFrequencyRange));
    }

    public static interface Listener {
        public void consumeFrequency(float[] var1, float[] var2, int var3, int var4);
    }
}

