/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.web;

import com.trolltech.qt.core.QSize;
import com.trolltech.qt.core.QUrl;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QPaintDeviceInterface;
import com.trolltech.qt.gui.QPainter;
import com.trolltech.qt.webkit.QWebElement;
import com.trolltech.qt.webkit.QWebElementCollection;
import com.trolltech.qt.webkit.QWebFrame;
import com.trolltech.qt.webkit.QWebPage;
import java.net.URL;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.web.BrowserDelegate;
import org.openimaj.web.DefaultBrowserDelegate;

public class ProgrammaticBrowser {
    private static final Logger logger = Logger.getLogger(ProgrammaticBrowser.class);
    private QWebPage webpage;
    private QWebFrame webframe;
    private Boolean currentLoadingStatus;
    private long mainLoopSleepTime = 10L;
    private static boolean qapp_init = false;

    public ProgrammaticBrowser() {
        this(new DefaultBrowserDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgrammaticBrowser(final BrowserDelegate delegate) {
        Class<ProgrammaticBrowser> clazz = ProgrammaticBrowser.class;
        synchronized (ProgrammaticBrowser.class) {
            if (!qapp_init) {
                QApplication.initialize((String[])new String[0]);
                qapp_init = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.webpage = new QWebPage(){

                protected void javaScriptAlert(QWebFrame originatingFrame, String msg) {
                    if (delegate != null) {
                        delegate.javaScriptAlert(originatingFrame, msg);
                    } else {
                        super.javaScriptAlert(originatingFrame, msg);
                    }
                }

                protected boolean javaScriptConfirm(QWebFrame originatingFrame, String msg) {
                    if (delegate != null) {
                        return delegate.javaScriptConfirm(originatingFrame, msg);
                    }
                    return super.javaScriptConfirm(originatingFrame, msg);
                }

                protected void javaScriptConsoleMessage(String message, int lineNumber, String sourceID) {
                    if (delegate != null) {
                        delegate.javaScriptConsoleMessage(message, lineNumber, sourceID);
                    }
                    super.javaScriptConsoleMessage(message, lineNumber, sourceID);
                }

                protected String javaScriptPrompt(QWebFrame originatingFrame, String msg, String defaultValue) {
                    if (delegate != null) {
                        delegate.javaScriptPrompt(originatingFrame, msg, defaultValue);
                    }
                    return super.javaScriptPrompt(originatingFrame, msg, defaultValue);
                }
            };
            this.webframe = this.webpage.mainFrame();
            this.currentLoadingStatus = null;
            this.webpage.loadFinished.connect((Object)this, "loadFinished(boolean)");
            this.webpage.loadStarted.connect((Object)this, "loadStarted()");
            return;
        }
    }

    private void mainEventLoop() {
        QApplication.processEvents();
        try {
            Thread.sleep(this.mainLoopSleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void loadStarted() {
        logger.debug((Object)("Loading page " + this.getURL()));
    }

    protected boolean waitForLoad() {
        try {
            return this.waitForLoad(0L);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    protected void loadFinished(boolean successful) {
        this.currentLoadingStatus = successful;
        logger.info((Object)String.format("Page load finished (%d bytes): %s (%s)", this.getHTML().length(), this.getURL(), successful ? "successful" : "error"));
    }

    private boolean waitForLoad(long timeout) throws TimeoutException {
        this.mainEventLoop();
        long itime = System.currentTimeMillis();
        this.currentLoadingStatus = null;
        while (this.currentLoadingStatus == null) {
            if (timeout != 0L && System.currentTimeMillis() - itime > timeout) {
                throw new TimeoutException(String.format("Timeout reached: %d seconds", timeout));
            }
            this.mainEventLoop();
        }
        this.mainEventLoop();
        if (this.currentLoadingStatus.booleanValue()) {
            this.webpage.setViewportSize(this.webpage.mainFrame().contentsSize());
        }
        return this.currentLoadingStatus;
    }

    public void mainLoop(long timeout) {
        this.mainEventLoop();
        long itime = System.currentTimeMillis();
        while (timeout != 0L && System.currentTimeMillis() - itime <= timeout) {
            this.mainEventLoop();
        }
        this.mainEventLoop();
    }

    public String getHTML() {
        return this.webframe.toHtml();
    }

    public String getURL() {
        return this.webframe.url().toString();
    }

    public boolean load(URL url) {
        return this.load(url.toString());
    }

    public boolean load(URL url, long timeout) throws TimeoutException {
        return this.load(url.toString(), timeout);
    }

    public boolean load(String url, long timeout) throws TimeoutException {
        this.webframe.load(new QUrl(url));
        return this.waitForLoad(timeout);
    }

    public boolean load(String url) {
        this.webframe.load(new QUrl(url));
        return this.waitForLoad();
    }

    public boolean loadHTML(String html) {
        this.webframe.setHtml(html);
        return this.waitForLoad();
    }

    public QWebElement getBody() {
        return this.webframe.findFirstElement("BODY");
    }

    public QWebElementCollection findAllElements(String selectorQuery) {
        return this.webframe.findAllElements(selectorQuery);
    }

    public QWebElement findFirstElement(String selectorQuery) {
        return this.webframe.findFirstElement(selectorQuery);
    }

    public MBFImage renderToImage() {
        QWebElement ele = this.webframe.documentElement();
        if (ele == null) {
            return null;
        }
        QSize size = ele.geometry().size();
        System.out.println(size);
        if (size.width() <= 0 || size.height() <= 0) {
            return null;
        }
        QImage image = new QImage(size, QImage.Format.Format_ARGB32_Premultiplied);
        QPainter p = new QPainter((QPaintDeviceInterface)image);
        p.setRenderHint(QPainter.RenderHint.Antialiasing, false);
        p.setRenderHint(QPainter.RenderHint.TextAntialiasing, false);
        p.setRenderHint(QPainter.RenderHint.SmoothPixmapTransform, false);
        ele.render(p);
        p.end();
        int width = image.width();
        int height = image.height();
        MBFImage mbfimage = new MBFImage(width, height, ColourSpace.RGB);
        FImage rf = (FImage)mbfimage.bands.get(0);
        FImage gf = (FImage)mbfimage.bands.get(1);
        FImage bf = (FImage)mbfimage.bands.get(2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = image.pixel(x, y);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                rf.pixels[y][x] = (float)r / 255.0f;
                gf.pixels[y][x] = (float)g / 255.0f;
                bf.pixels[y][x] = (float)b / 255.0f;
            }
        }
        return mbfimage;
    }

    public MBFImage renderToImage(int width, int height) {
        QWebElement ele = this.webframe.documentElement();
        if (ele == null) {
            return null;
        }
        QSize size = ele.geometry().size();
        if (size.width() < width) {
            width = size.width();
        }
        if (size.height() < height) {
            height = size.height();
        }
        if (width <= 0 || height <= 0) {
            return null;
        }
        QImage image = new QImage(new QSize(width, height), QImage.Format.Format_ARGB32_Premultiplied);
        QPainter p = new QPainter((QPaintDeviceInterface)image);
        p.setRenderHint(QPainter.RenderHint.Antialiasing, false);
        p.setRenderHint(QPainter.RenderHint.TextAntialiasing, false);
        p.setRenderHint(QPainter.RenderHint.SmoothPixmapTransform, false);
        ele.render(p);
        p.end();
        MBFImage mbfimage = new MBFImage(width, height, ColourSpace.RGB);
        FImage rf = (FImage)mbfimage.bands.get(0);
        FImage gf = (FImage)mbfimage.bands.get(1);
        FImage bf = (FImage)mbfimage.bands.get(2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = image.pixel(x, y);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                rf.pixels[y][x] = (float)r / 255.0f;
                gf.pixels[y][x] = (float)g / 255.0f;
                bf.pixels[y][x] = (float)b / 255.0f;
            }
        }
        return mbfimage;
    }

    public int getWidth() {
        return this.webframe.contentsSize().width();
    }

    public int getHeight() {
        return this.webframe.contentsSize().height();
    }
}

