/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.objectdetection.hog;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.objectdetection.filtering.OpenCVGrouping;
import org.openimaj.image.objectdetection.hog.HOGClassifier;
import org.openimaj.image.objectdetection.hog.HOGDetector;
import org.openimaj.io.IOUtils;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.util.pair.ObjectIntPair;

public class Testing {
    public static void main(String[] args) throws IOException {
        HOGClassifier classifier = (HOGClassifier)IOUtils.readFromFile((File)new File("final-classifier.dat"));
        HOGDetector detector = new HOGDetector(classifier);
        FImage img = ImageUtilities.readF((File)new File("/Users/jsh2/Data/INRIAPerson/Test/pos/crop_000006.png"));
        List<Rectangle> dets = detector.detect(img);
        List<ObjectIntPair<Rectangle>> fdets = new OpenCVGrouping().apply(dets);
        MBFImage rgb = img.toRGB();
        for (Rectangle rectangle : dets) {
            rgb.drawShape((Shape)rectangle, (Object)RGBColour.RED);
        }
        for (ObjectIntPair objectIntPair : fdets) {
            rgb.drawShape((Shape)objectIntPair.first, (Object)RGBColour.GREEN);
        }
        DisplayUtilities.display((Image)rgb);
    }
}

