/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.system;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.openjena.atlas.lib.Chars;
import org.openjena.atlas.logging.Log;

public abstract class JenaWriterBase
implements RDFWriter {
    protected Map<String, String> writerPropertyMap = new HashMap<String, String>();
    private RDFErrorHandler errorHandler = null;

    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }

    public Object setProperty(String propName, Object propValue) {
        if (!(propValue instanceof String)) {
            Log.warn(this, "setProperty: Property for '" + propName + "' is not a string");
            propValue = propValue.toString();
        }
        propName = this.absolutePropName(propName);
        if (this.writerPropertyMap == null) {
            this.writerPropertyMap = new HashMap<String, String>();
        }
        String oldValue = this.writerPropertyMap.get(propName);
        this.writerPropertyMap.put(propName, (String)propValue);
        return oldValue;
    }

    protected String absolutePropName(String propName) {
        return propName;
    }

    public void write(Model model, Writer out, String base) {
        this.write(model.getGraph(), out, base);
    }

    public void write(Model model, OutputStream out, String base) {
        Writer w = new OutputStreamWriter(out, Chars.createEncoder());
        w = new BufferedWriter(w, 8192);
        this.write(model.getGraph(), w, base);
        try {
            w.flush();
        }
        catch (Exception e2) {
            // empty catch block
        }
    }

    protected abstract void write(Graph var1, Writer var2, String var3);
}

