/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.web;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.web.MediaType;

public class TypedInputStream
extends FilterInputStream {
    private final MediaType mediaType;

    public TypedInputStream(InputStream in) {
        this(in, null, null);
    }

    public TypedInputStream(InputStream in, MediaType mediaType) {
        super(in);
        this.mediaType = mediaType;
    }

    public TypedInputStream(InputStream in, String mediaType, String charset) {
        this(in, MediaType.create(mediaType, charset));
    }

    public String getMediaType() {
        return this.mediaType.getContentType();
    }

    public String getCharset() {
        return this.mediaType.getCharset();
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }
}

