/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.json;

import org.openjena.atlas.json.JsonException;

public class JsonParseException
extends JsonException {
    private int line = -1;
    private int column = -1;

    public JsonParseException(int line, int column) {
        this.set(line, column);
    }

    public JsonParseException(Throwable cause, int line, int column) {
        super(cause);
        this.set(line, column);
    }

    public JsonParseException(String msg, int line, int column) {
        super(msg);
        this.set(line, column);
    }

    public JsonParseException(String msg, Throwable cause, int line, int column) {
        super(msg, cause);
        this.set(line, column);
    }

    private void set(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public static String formatMessage(String msg, int line, int column) {
        if (line == -1 || column == -1) {
            return msg;
        }
        return String.format("[line: %d, col: %d] " + msg, line, column);
    }
}

