/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemVisitor;

public class ItemWalker {
    static void walk(ItemVisitor visitor, Item item) {
        item.visit(new Worker(visitor));
    }

    static class Worker
    implements ItemVisitor {
        private ItemVisitor visitor;

        Worker(ItemVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public void visit(Item item, ItemList list) {
            for (Item subItem : list) {
                subItem.visit(this);
            }
            this.visitor.visit(item, list);
        }

        @Override
        public void visit(Item item, Node node) {
            this.visitor.visit(item, node);
        }

        @Override
        public void visit(Item item, String symbol) {
            this.visitor.visit(item, symbol);
        }

        @Override
        public void visitNil() {
            this.visitor.visitNil();
        }
    }
}

