/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTopN;
import com.hp.hpl.jena.sparql.util.Symbol;

public class TransformTopN
extends TransformCopy {
    private static final int defaultTopNSortingThreshold = 1000;
    public static final Symbol externalSortBufferSize = ARQConstants.allocSymbol("topNSortingThreshold");

    @Override
    public Op transform(OpSlice opSlice, Op subOp) {
        Op subSubOp;
        long offset;
        if (opSlice.getLength() == Long.MIN_VALUE) {
            return super.transform(opSlice, subOp);
        }
        int threshold = (Integer)ARQ.getContext().get(externalSortBufferSize, 1000);
        long l = offset = opSlice.getStart() != Long.MIN_VALUE ? opSlice.getStart() : 0L;
        if (offset + opSlice.getLength() >= (long)threshold) {
            return super.transform(opSlice, subOp);
        }
        if (subOp instanceof OpOrder) {
            OpOrder opOrder = (OpOrder)subOp;
            OpTopN opTopN = new OpTopN(opOrder.getSubOp(), (int)(offset + opSlice.getLength()), opOrder.getConditions());
            if (offset == 0L) {
                return opTopN;
            }
            return new OpSlice(opTopN, offset, Long.MIN_VALUE);
        }
        if ((subOp instanceof OpDistinct || subOp instanceof OpReduced) && (subSubOp = ((Op1)subOp).getSubOp()) instanceof OpOrder) {
            OpOrder opOrder = (OpOrder)subSubOp;
            Op opDistinct2 = OpDistinct.create(opOrder.getSubOp());
            OpTopN opTopN = new OpTopN(opDistinct2, (int)(offset + opSlice.getLength()), opOrder.getConditions());
            if (offset == 0L) {
                return opTopN;
            }
            return new OpSlice(opTopN, offset, Long.MIN_VALUE);
        }
        if (subOp instanceof OpProject && (subSubOp = ((Op1)subOp).getSubOp()) instanceof OpOrder) {
            OpProject opProject = (OpProject)subOp;
            OpOrder opOrder = (OpOrder)subSubOp;
            OpTopN opTopN = new OpTopN(opOrder.getSubOp(), (int)(offset + opSlice.getLength()), opOrder.getConditions());
            OpProject proj = new OpProject(opTopN, opProject.getVars());
            if (offset == 0L) {
                return proj;
            }
            return new OpSlice(proj, offset, Long.MIN_VALUE);
        }
        return super.transform(opSlice, subOp);
    }
}

