/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.Op2;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpN;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_SameTerm;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.ExprVars;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.Set;

public class TransformFilterEquality
extends TransformCopy {
    private boolean stringsAsTerms;

    public TransformFilterEquality(boolean stringsAsTerms) {
        this.stringsAsTerms = stringsAsTerms;
    }

    @Override
    public Op transform(OpFilter opFilter, Op subOp) {
        ExprList exprs = opFilter.getExprs();
        if (!TransformFilterEquality.safeToTransform(exprs, subOp)) {
            return super.transform(opFilter, subOp);
        }
        Op op = subOp;
        Set<Var> patternVars = OpVars.patternVars(op);
        ExprList exprs2 = new ExprList();
        for (Expr e2 : exprs.getList()) {
            Op op2 = TransformFilterEquality.processFilterWorker(e2, op, patternVars);
            if (op2 == null) {
                exprs2.add(e2);
                continue;
            }
            op = op2;
        }
        if (exprs2.size() > 0) {
            op = OpFilter.filter(exprs2, op);
        }
        return op;
    }

    public static Op processFilterOrOpFilter(Expr e2, Op subOp) {
        Op op2 = TransformFilterEquality.processFilterWorker(e2, subOp, null);
        if (op2 == null) {
            op2 = OpFilter.filter(e2, subOp);
        }
        return op2;
    }

    private static boolean safeToTransform(Expr expr, Op op) {
        return TransformFilterEquality.safeToTransform(new ExprList(expr), op);
    }

    private static boolean safeToTransform(ExprList exprs, Op op) {
        if (op instanceof OpBGP || op instanceof OpQuadPattern) {
            return true;
        }
        if (op instanceof OpSequence) {
            OpN opN = (OpN)op;
            for (Op subOp : opN.getElements()) {
                if (TransformFilterEquality.safeToTransform(exprs, subOp)) continue;
                return false;
            }
            return true;
        }
        if (op instanceof OpJoin) {
            Op2 op2 = (Op2)op;
            return TransformFilterEquality.safeToTransform(exprs, op2.getLeft()) && TransformFilterEquality.safeToTransform(exprs, op2.getRight());
        }
        if (op instanceof OpConditional || op instanceof OpLeftJoin) {
            Set<Var> y;
            Op2 opleftjoin = (Op2)op;
            if (!TransformFilterEquality.safeToTransform(exprs, opleftjoin.getLeft()) || !TransformFilterEquality.safeToTransform(exprs, opleftjoin.getRight())) {
                return false;
            }
            Op opLeft = opleftjoin.getLeft();
            Set<Var> x = OpVars.patternVars(opLeft);
            return x.containsAll(y = ExprVars.getVarsMentioned(exprs));
        }
        if (op instanceof OpGraph) {
            OpGraph opg = (OpGraph)op;
            return TransformFilterEquality.safeToTransform(exprs, opg.getSubOp());
        }
        return false;
    }

    public static Op processFilter(Expr e2, Op subOp) {
        if (!TransformFilterEquality.safeToTransform(e2, subOp)) {
            return null;
        }
        return TransformFilterEquality.processFilterWorker(e2, subOp, null);
    }

    private static Op processFilterWorker(Expr e2, Op subOp, Set<Var> patternVars) {
        if (patternVars == null) {
            patternVars = OpVars.patternVars(subOp);
        }
        if (!(e2 instanceof E_Equals) && !(e2 instanceof E_SameTerm)) {
            return null;
        }
        ExprFunction2 eq = (ExprFunction2)e2;
        Expr left = eq.getArg1();
        Expr right = eq.getArg2();
        Var var = null;
        NodeValue constant = null;
        if (left.isVariable() && right.isConstant()) {
            var = left.asVar();
            constant = right.getConstant();
        } else if (right.isVariable() && left.isConstant()) {
            var = right.asVar();
            constant = left.getConstant();
        }
        if (var == null || constant == null) {
            return null;
        }
        if (!patternVars.contains((Object)var)) {
            return null;
        }
        if (e2 instanceof E_SameTerm && !ARQ.isStrictMode() && constant.isString()) {
            return null;
        }
        if (e2 instanceof E_Equals && !ARQ.isStrictMode() && constant.isLiteral()) {
            return null;
        }
        return TransformFilterEquality.subst(subOp, var, constant);
    }

    private static Op subst(Op subOp, Var var, NodeValue nv) {
        Op op = Substitute.substitute(subOp, var, nv.asNode());
        return OpAssign.assign(op, var, nv);
    }

    private static Op subst(Op subOp, ExprVar var1, ExprVar var2) {
        Op op = Substitute.substitute(subOp, var2.asVar(), (Node)var1.asVar());
        return OpAssign.assign(op, var2.asVar(), var1);
    }
}

