/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib.cache;

import java.util.Arrays;
import java.util.Iterator;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.IteratorArray;
import org.openjena.atlas.lib.ActionKeyValue;
import org.openjena.atlas.lib.Cache;

public class CacheSimple<K, V>
implements Cache<K, V> {
    private final V[] values;
    private final K[] keys;
    private final int size;
    private int currentSize = 0;
    private ActionKeyValue<K, V> dropHandler = null;

    public CacheSimple(int size) {
        Object[] x = new Object[size];
        this.values = x;
        Object[] z = new Object[size];
        this.keys = z;
        this.size = size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, null);
        Arrays.fill(this.keys, null);
        this.currentSize = 0;
    }

    @Override
    public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    private final int index(K key) {
        int x = (key.hashCode() & Integer.MAX_VALUE) % this.size;
        if (this.keys[x] != null && this.keys[x].equals(key)) {
            return x;
        }
        return -x - 1;
    }

    private final int decode(int x) {
        if (x >= 0) {
            return x;
        }
        return -x - 1;
    }

    @Override
    public V get(K key) {
        int x = this.index(key);
        if (x < 0) {
            return null;
        }
        return this.values[x];
    }

    @Override
    public V put(K key, V thing) {
        int x = this.index(key);
        V old = null;
        if (x < 0) {
            x = this.decode(x);
        } else {
            old = this.values[x];
            if (this.dropHandler != null) {
                this.dropHandler.apply(this.keys[x], old);
            }
            --this.currentSize;
        }
        this.values[x] = thing;
        this.keys[x] = thing == null ? null : key;
        ++this.currentSize;
        return old;
    }

    @Override
    public boolean remove(K key) {
        Object old = this.put(key, (V)null);
        return old != null;
    }

    @Override
    public long size() {
        return this.currentSize;
    }

    @Override
    public Iterator<K> keys() {
        IteratorArray<K> iter = IteratorArray.create(this.keys);
        return Iter.removeNulls(iter);
    }

    @Override
    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    @Override
    public void setDropHandler(ActionKeyValue<K, V> dropHandler) {
        this.dropHandler = dropHandler;
    }
}

