/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hadoop.mapreduce.stage.helper;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.openimaj.hadoop.mapreduce.stage.Stage;
import org.openimaj.hadoop.mapreduce.stage.helper.MultipleOutputReducer;

public abstract class MultipleOutputStage<INPUT_FORMAT extends FileInputFormat<INPUT_KEY, INPUT_VALUE>, INPUT_KEY, INPUT_VALUE, MAP_OUTPUT_KEY, MAP_OUTPUT_VALUE, OUTPUT_KEY, OUTPUT_VALUE>
extends Stage<INPUT_FORMAT, FileOutputFormat<OUTPUT_KEY, OUTPUT_VALUE>, INPUT_KEY, INPUT_VALUE, MAP_OUTPUT_KEY, MAP_OUTPUT_VALUE, OUTPUT_KEY, OUTPUT_VALUE> {
    @Override
    public abstract Class<? extends MultipleOutputReducer<MAP_OUTPUT_KEY, MAP_OUTPUT_VALUE, OUTPUT_KEY, OUTPUT_VALUE>> reducer();

    @Override
    public Job stage(Path[] inputs, Path output, Configuration conf) throws Exception {
        Job job = super.stage(inputs, output, conf);
        job.setOutputFormatClass(NullOutputFormat.class);
        MultipleOutputs.addNamedOutput((Job)job, (String)"text", TextOutputFormat.class, NullWritable.class, Text.class);
        return job;
    }
}

