/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hadoop.mapreduce;

import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.openimaj.hadoop.mapreduce.stage.Stage;

public abstract class StageRunner
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        this.args(args);
        Stage<?, ?, ?, ?, ?, ?, ?, ?> thestage = this.stage();
        Job job = thestage.stage(this.inputs(), this.output(), this.getConf());
        if (this.shouldWait()) {
            job.waitForCompletion(true);
            thestage.finished(job);
        } else {
            job.submit();
        }
        return 0;
    }

    public boolean shouldWait() {
        return true;
    }

    public abstract Stage<?, ?, ?, ?, ?, ?, ?, ?> stage();

    public abstract Path output();

    public abstract Path[] inputs() throws Exception;

    public abstract void args(String[] var1) throws Exception;

    public void runMain(String[] args) throws Exception {
        ToolRunner.run((Tool)this, (String[])args);
    }
}

