/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hadoop.mapreduce;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.openimaj.hadoop.mapreduce.SingleStagedJob;
import org.openimaj.hadoop.mapreduce.stage.Stage;
import org.openimaj.hadoop.sequencefile.SequenceFileUtility;

public class MultiStagedJob {
    private Path outputRoot;
    private boolean removePreliminary;
    private LinkedList<Stage<?, ?, ?, ?, ?, ?, ?, ?>> stages;
    private Path[] initial;
    private String[] toolArgs;
    private Map<String, Path[]> completedJobs;

    public MultiStagedJob(Path[] initialInput, Path root, String[] args) {
        this(initialInput, root, false, args);
    }

    public MultiStagedJob(Path[] initialInput, Path root, boolean removePreliminary, String[] args) {
        this.outputRoot = root;
        this.initial = initialInput;
        this.removePreliminary = removePreliminary;
        this.stages = new LinkedList();
        this.toolArgs = args;
        this.completedJobs = new HashMap<String, Path[]>();
    }

    public MultiStagedJob(String inpath, String outpath, String[] args) throws IOException {
        this(SequenceFileUtility.getFilePaths(inpath, "path"), new Path(outpath), args);
    }

    public void queueStage(Stage<?, ?, ?, ?, ?, ?, ?, ?> s) {
        this.stages.offer(s);
    }

    public Path runAll() throws Exception {
        Stage<?, ?, ?, ?, ?, ?, ?, ?> s = null;
        Path[] currentInputs = this.initial;
        Path constructedOutputPath = null;
        ArrayList<String> toRemove = new ArrayList<String>();
        constructedOutputPath = this.constructOutputPath(this.stages.getLast().outname());
        boolean finalOutputExists = MultiStagedJob.fileExists(constructedOutputPath.toString());
        if (finalOutputExists && SequenceFileUtility.getFilePaths(constructedOutputPath.toString(), "part").length != 0) {
            return constructedOutputPath;
        }
        while ((s = this.stages.pollFirst()) != null) {
            constructedOutputPath = this.constructOutputPath(s.outname());
            boolean fExists = MultiStagedJob.fileExists(constructedOutputPath.toString());
            if (!fExists || SequenceFileUtility.getFilePaths(constructedOutputPath.toString(), "part").length == 0) {
                if (fExists) {
                    System.out.println("File exists but was empty, removing");
                    FileSystem fs = MultiStagedJob.getFileSystem(constructedOutputPath.toUri());
                    fs.delete(constructedOutputPath, true);
                }
                SingleStagedJob runner = new SingleStagedJob(s, currentInputs, constructedOutputPath);
                runner.runMain(this.toolArgs);
            }
            currentInputs = SequenceFileUtility.getFilePaths(constructedOutputPath.toString(), "part");
            if (this.removePreliminary && this.stages.size() > 0) {
                toRemove.add(constructedOutputPath.toString());
            }
            this.completedJobs.put(s.outname(), currentInputs);
        }
        for (String toremove : toRemove) {
            System.out.println("Removing intermediate output: " + toremove);
            Path ptoremove = new Path(toremove);
            FileSystem fs = MultiStagedJob.getFileSystem(ptoremove.toUri());
            fs.delete(ptoremove, true);
        }
        return constructedOutputPath;
    }

    private static boolean fileExists(String path) throws IOException {
        URI outuri = SequenceFileUtility.convertToURI(path);
        FileSystem fs = MultiStagedJob.getFileSystem(outuri);
        Path p = new Path(outuri.toString());
        return fs.exists(p);
    }

    private static FileSystem getFileSystem(URI uri) throws IOException {
        Configuration config = new Configuration();
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)config);
        if (fs instanceof LocalFileSystem) {
            fs = ((LocalFileSystem)fs).getRaw();
        }
        return fs;
    }

    private Path constructOutputPath(String outname) {
        String newOutPath = this.outputRoot.toString();
        if (outname != null) {
            newOutPath = newOutPath + "/" + outname;
        }
        return new Path(newOutPath);
    }

    public Path[] getStagePaths(String completedJobId) {
        return this.completedJobs.get(completedJobId);
    }

    public void removeIntermediate(boolean b) {
        this.removePreliminary = b;
    }
}

