/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.stream.window;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openimaj.util.function.Function;

public class WindowAverage
implements Function<List<Map<String, Double>>, Map<String, Double>> {
    @Override
    public Map<String, Double> apply(List<Map<String, Double>> in) {
        HashMap<String, Double> ret = new HashMap<String, Double>();
        HashMap<String, Long> count = new HashMap<String, Long>();
        for (Map<String, Double> map : in) {
            for (Map.Entry<String, Double> item : map.entrySet()) {
                String key = item.getKey();
                if (!count.containsKey(key)) {
                    ret.put(key, item.getValue());
                    count.put(key, 1L);
                    continue;
                }
                ret.put(key, (Double)ret.get(key) + item.getValue());
                count.put(key, (Long)count.get(key) + 1L);
            }
        }
        for (Map.Entry entry : ret.entrySet()) {
            String key = (String)entry.getKey();
            ret.put(key, (Double)entry.getValue() / (double)((Long)count.get(key)).longValue());
        }
        return ret;
    }
}

