/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.iterator;

import java.util.Iterator;
import org.openimaj.util.iterator.NumericIterable;

public class UniformByteRangeIterable
implements NumericIterable<Byte> {
    private byte stop;
    private byte step;
    private byte current;

    public UniformByteRangeIterable(byte start, byte stop, byte step) {
        this.stop = stop;
        this.step = step;
        this.current = start;
    }

    public UniformByteRangeIterable(byte start, byte stop) {
        this(start, stop, 1);
    }

    @Override
    public Iterator<Byte> iterator() {
        return new Iterator<Byte>(){

            @Override
            public boolean hasNext() {
                return UniformByteRangeIterable.this.current + UniformByteRangeIterable.this.step <= UniformByteRangeIterable.this.stop;
            }

            @Override
            public Byte next() {
                byte ret = UniformByteRangeIterable.this.current;
                UniformByteRangeIterable.this.current = (byte)(UniformByteRangeIterable.this.current + UniformByteRangeIterable.this.step);
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }
}

