/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.iterator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;

public class TextLineIterable
implements Iterable<String> {
    private Provider source;

    public TextLineIterable(Provider source) {
        this.source = source;
    }

    public TextLineIterable(final File f) {
        this.source = new Provider(){

            @Override
            public BufferedReader open() throws IOException {
                return new BufferedReader(new FileReader(f));
            }
        };
    }

    public TextLineIterable(final File f, final String charset) {
        this.source = new Provider(){

            @Override
            public BufferedReader open() throws IOException {
                return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), charset));
            }
        };
    }

    public TextLineIterable(final URL f, final String charset) {
        this.source = new Provider(){

            @Override
            public BufferedReader open() throws IOException {
                return new BufferedReader(new InputStreamReader(f.openStream(), charset));
            }
        };
    }

    public TextLineIterable(final URL f) {
        this.source = new Provider(){

            @Override
            public BufferedReader open() throws IOException {
                return new BufferedReader(new InputStreamReader(f.openStream()));
            }
        };
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            BufferedReader br = this.open();
            String nextLine = this.readLine();

            @Override
            public boolean hasNext() {
                return this.nextLine != null;
            }

            @Override
            public String next() {
                String result = this.nextLine;
                if (this.nextLine != null) {
                    this.nextLine = this.readLine();
                    if (this.nextLine == null) {
                        this.closeQuietly();
                    }
                }
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("not supported");
            }

            private String readLine() {
                try {
                    return this.br.readLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            private BufferedReader open() {
                try {
                    return TextLineIterable.this.source.open();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            private void closeQuietly() {
                try {
                    this.br.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
    }

    public static class GZIPFileProvider
    implements Provider {
        File f;

        public GZIPFileProvider(File f) {
            this.f = f;
        }

        @Override
        public BufferedReader open() throws IOException {
            return new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.f))));
        }
    }

    public static interface Provider {
        public BufferedReader open() throws IOException;
    }
}

