/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io.wrappers;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.io.ReadWriteable;

public class ReadWriteableDouble
implements ReadWriteable,
Comparable<ReadWriteableDouble> {
    public double value;

    public ReadWriteableDouble(double value) {
        this.value = value;
    }

    public ReadWriteableDouble() {
        this.value = 0.0;
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        this.value = in.readDouble();
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        this.value = in.nextDouble();
    }

    @Override
    public byte[] binaryHeader() {
        return new byte[0];
    }

    @Override
    public String asciiHeader() {
        return "";
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeDouble(this.value);
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.print(this.value + "\n");
    }

    public boolean equals(Object o) {
        return o instanceof ReadWriteableDouble && ((ReadWriteableDouble)o).value == this.value;
    }

    public int hashCode() {
        return new Double(this.value).hashCode();
    }

    @Override
    public int compareTo(ReadWriteableDouble arg0) {
        return new Double(this.value).compareTo(arg0.value);
    }
}

