/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;

public class FileUtils {
    public static boolean deleteRecursive(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteRecursive(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void downloadURL(URL url, File file) throws IOException {
        URLConnection conn = url.openConnection();
        InputStream stream = conn.getInputStream();
        FileOutputStream fos = new FileOutputStream(file);
        byte[] buffer = new byte[1024];
        int read = 0;
        while ((read = stream.read(buffer)) != -1) {
            fos.write(buffer, 0, read);
        }
        fos.close();
    }

    public static BufferedReader read(File file) throws IOException {
        return new BufferedReader(new InputStreamReader(new FileInputStream(file)));
    }

    public static String readall(InputStream stream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        String line = null;
        StringBuilder builder = new StringBuilder();
        while ((line = br.readLine()) != null) {
            builder.append(line);
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String readall(InputStream stream, String encoding) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, encoding));
        String line = null;
        StringBuilder builder = new StringBuilder();
        while ((line = br.readLine()) != null) {
            builder.append(line);
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String readall(File file) throws IOException {
        return FileUtils.readall(new FileInputStream(file));
    }

    public static File copyStreamToFile(InputStream stream, File output) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(stream));
        String l = null;
        PrintWriter writer = new PrintWriter(new FileWriter(output));
        while ((l = r.readLine()) != null) {
            writer.println(l);
        }
        writer.close();
        r.close();
        return output;
    }

    public static File copyStreamToFileBinary(InputStream stream, File output) throws IOException {
        FileOutputStream out = new FileOutputStream(output);
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = stream.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.close();
        stream.close();
        return output;
    }

    public static File unpackJarFile(URL resource) throws IOException {
        return FileUtils.unpackJarFile(resource, true);
    }

    public static File unpackJarFile(URL resource, boolean deleteOnExit) throws IOException {
        if (!FileUtils.isJarResource(resource)) {
            return null;
        }
        String ext = resource.toString().substring(resource.toString().lastIndexOf("."));
        File f = File.createTempFile("openimaj", ext);
        FileUtils.unpackJarFile(resource, f, deleteOnExit);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void unpackJarFile(URL resource, File destination, boolean deleteOnExit) {
        block32: {
            FilterOutputStream fout;
            BufferedInputStream urlin;
            block31: {
                if (deleteOnExit) {
                    destination.deleteOnExit();
                }
                urlin = null;
                fout = null;
                int bufSize2333333332 = 8192;
                urlin = new BufferedInputStream(resource.openConnection().getInputStream(), 8192);
                fout = new BufferedOutputStream(new FileOutputStream(destination), 8192);
                int read = -1;
                byte[] buf = new byte[8192];
                while ((read = urlin.read(buf, 0, 8192)) >= 0) {
                    ((BufferedOutputStream)fout).write(buf, 0, read);
                }
                ((BufferedOutputStream)fout).flush();
                if (urlin == null) break block31;
                try {
                    urlin.close();
                }
                catch (IOException bufSize2333333332) {
                    // empty catch block
                }
            }
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException bufSize2333333332) {}
            }
            break block32;
            catch (IOException ioex) {
                if (urlin != null) {
                    try {
                        urlin.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
            catch (SecurityException sx) {
                if (urlin != null) {
                    try {
                        urlin.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
                {
                    catch (Throwable throwable) {
                        if (urlin != null) {
                            try {
                                urlin.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (fout != null) {
                            try {
                                fout.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    public static boolean isJarResource(URL resource) {
        return FileUtils.isJarResource(resource.toString());
    }

    public static boolean isJarResource(String resourceURL) {
        return resourceURL.startsWith("jar:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countLines(File filename) {
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(filename));
            byte[] c = new byte[1024];
            int count = 0;
            int readChars = 0;
            while ((readChars = is.read(c)) != -1) {
                for (int i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++count;
                }
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                return -1;
            }
        }
    }

    public static File[] findRecursive(File start, final FilenameFilter filenameFilter) {
        final Stack<File> filesToCheck = new Stack<File>();
        ArrayList<File> found = new ArrayList<File>();
        filesToCheck.push(start);
        while (filesToCheck.size() > 0) {
            final File toCheck = (File)filesToCheck.pop();
            File[] afiles = toCheck.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    File found = new File(dir, name);
                    boolean accept = filenameFilter.accept(found, name);
                    if (toCheck != found && found.isDirectory()) {
                        System.out.println("Adding: " + found);
                        filesToCheck.push(found);
                    }
                    return accept;
                }
            });
            found.addAll(Arrays.asList(afiles));
        }
        return found.toArray(new File[found.size()]);
    }

    public static String[] readlines(File file) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String line = null;
        ArrayList<String> allLines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            allLines.add(line);
        }
        br.close();
        return allLines.toArray(new String[allLines.size()]);
    }

    public static String[] readlines(File file, String encoding) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        String line = null;
        ArrayList<String> allLines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            allLines.add(line);
        }
        br.close();
        return allLines.toArray(new String[allLines.size()]);
    }

    public static String[] readlines(InputStream stream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        String line = null;
        ArrayList<String> allLines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            allLines.add(line);
        }
        return allLines.toArray(new String[allLines.size()]);
    }

    public static String[] readlines(InputStream stream, String encoding) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, encoding));
        String line = null;
        ArrayList<String> allLines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            allLines.add(line);
        }
        return allLines.toArray(new String[allLines.size()]);
    }
}

