/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.fieldtypes;

import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;
import org.apache.sanselan.util.Debug;

public class FieldTypeLong
extends FieldType {
    public FieldTypeLong(int type, String name) {
        super(type, 4, name);
    }

    public Object getSimpleValue(TiffField entry) {
        if (entry.length == 1) {
            return new Integer(this.convertByteArrayToInt(this.name + " (" + entry.tagInfo.name + ")", entry.valueOffsetBytes, entry.byteOrder));
        }
        return this.convertByteArrayToIntArray(this.name + " (" + entry.tagInfo.name + ")", this.getRawBytes(entry), 0, entry.length, entry.byteOrder);
    }

    public byte[] writeData(Object o, int byteOrder) throws ImageWriteException {
        if (o instanceof Integer) {
            return this.convertIntArrayToByteArray(new int[]{(Integer)o}, byteOrder);
        }
        if (o instanceof int[]) {
            int[] numbers = (int[])o;
            return this.convertIntArrayToByteArray(numbers, byteOrder);
        }
        if (o instanceof Integer[]) {
            Integer[] numbers = (Integer[])o;
            int[] values = new int[numbers.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = numbers[i];
            }
            return this.convertIntArrayToByteArray(values, byteOrder);
        }
        throw new ImageWriteException("Invalid data: " + o + " (" + Debug.getType(o) + ")");
    }
}

